//
//  PlusOneFinder.h
//  ArmorP3V1
//

#import <Foundation/Foundation.h>
#import "PSSession.h"
#import "PSArmorSet.h"
#import "DecorationMatcher.h"
#import "IProgress.h"

@interface PlusOneFinder : NSObject {
}

@property (nonatomic, readonly) PSSession* session;
@property (nonatomic, readonly) SkillSet* searchSkill;
@property (nonatomic, readonly) NSMutableArray* listSearchSkills;
@property (nonatomic, readonly) NSMutableDictionary* matcherCache;
@property (nonatomic, readonly) NSMutableDictionary* matchedResult;
@property (nonatomic, retain)   NSMutableDictionary* baseScanned;
@property (nonatomic, readonly) NSMutableArray* seekList;

@property (nonatomic, assign) BOOL useNestedFind;
@property (nonatomic, assign) BOOL wasTimeout;
@property (nonatomic, assign) BOOL onlySkillScan;
@property (nonatomic, assign) BOOL debug;
@property (nonatomic, assign) BOOL isZeroTask;

@property (nonatomic, readonly) id CONFLICT;
@property (nonatomic, readonly) id NOTHING;
@property (nonatomic, readonly) id BASE_TRUE;
@property (nonatomic, readonly) id BASE_FALSE;

@property (nonatomic, assign) int seekListMax;

-(id)initWith:(PSSession*) session;
-(void)addToResult: (PSArmorSet*)set : (SkillSet*) skills : (NSString*) tag;
-(BOOL)quickFindPlusSkills:(NSMutableSet*)ret:(PSArmorSet*)set:(SkillSet*)searchSkills:(NSMutableArray*)prevResult;
-(DecorationMatcher*)getMatcherCached:(SkillSet*)skills;
-(BOOL)findPlusOne:(PSArmorSet*)set:(SkillSet*)skills:(NSMutableArray*)result:(BOOL)isBase;
-(BOOL)findAnyPlusOne:(PSArmorSet*)set:(NSMutableArray*)prevResult:(id<IProgress>)progress;
-(void)getResultMap:(NSMutableDictionary*)skillAndArmors:(NSMutableArray*)listArmorSet;
-(void)tryFixMinus:(NSMutableArray*) listArmorSet: (NSMutableArray*) slotList;

@end