//
//  PSSession.m
//  ArmorP3V1
//

#import "PSSession.h"
#import "SkillSet.h"
#import "DecorationCount.h"
#import "PSMutex.h"

@implementation PSSession

@synthesize searchHunterRank = _searchHunterRank;
@synthesize searchTownRank = _searchTownRank;
@synthesize searchGenderType = _searchGenderType;
@synthesize searchHunterType = _searchHunterType;
@synthesize searchWeaponSlotCount = _searchWeaponSlotCount;
@synthesize searchSkills = _searchSkills;
@synthesize searchMaxCount = _searchMaxCount;
@synthesize searchMatome = _searchMatome;
@synthesize searchCharmCSVTable = _searchCharmCSVTable;
@synthesize searchFukugo = _searchFukugo;
@synthesize searchDecorationCount = _searchDecorationCount;
@synthesize searchWithUsableStatus = _searchWithUsableStatus;
@synthesize searchOrderByDeffence = _searchOrderByDeffence;
@synthesize searchPlusAlpha = _searchPlusAlpha;
@synthesize searchTwoPathThreshold = _searchTwoPathThreshold;

-(id)init {
    self = [super init];
    if (self) {
        _searchSkills = [[SkillSet alloc]init];
        _searchDecorationCount = [[DecorationCount alloc]init];
        _searchHunterRank = 6;
        _searchTownRank = 5;
        _searchGenderType = 1;
        _searchHunterType = 1;
        _searchWeaponSlotCount = 0;
        _searchMaxCount = 9999;
        _searchOrderByDeffence = TRUE;
        _searchCharmCSVTable = 0;
        _searchFukugo = TRUE;
        _searchMatome = TRUE;
        _searchWithUsableStatus = FALSE;
        _searchPlusAlpha = FALSE;
        _searchTwoPathThreshold = 0;
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    [[PSMutex mainMutex] showMemoryAlertIfError];
    return self;
}

-(void)dealloc
{
    [_searchSkills release];
    [_searchDecorationCount release];
    [super dealloc];
}


-(PSSession*)makeCopy {
    PSSession* obj = [[PSSession alloc]init];
    obj.searchHunterRank = _searchHunterRank;
    obj.searchTownRank = _searchTownRank;
    obj.searchGenderType = _searchGenderType;
    obj.searchHunterType = _searchHunterType;
    obj.searchWeaponSlotCount = _searchWeaponSlotCount;
    obj.searchOrderByDeffence = _searchOrderByDeffence;
    obj.searchMaxCount = _searchMaxCount;
    obj.searchMatome = _searchMatome;
    obj.searchFukugo = _searchFukugo;
    obj.searchCharmCSVTable = _searchCharmCSVTable;
    obj.searchWithUsableStatus = _searchWithUsableStatus;
    SkillSet* set = [[SkillSet alloc]init];
    obj.searchSkills = set;
    obj.searchPlusAlpha = _searchPlusAlpha;
    [set release];
    [obj.searchSkills sum_all:_searchSkills];
    return obj;
}

+(BOOL)isExistForThisHunber: (PSSession*)session: (PSItem*)item {
    if (item.itemType == ITEM_TYPE_CHARM) {
        if (item.isCopieSkill) {
            return FALSE;
        }
        return TRUE;
    }
    /*
    if (item.itemType == ITEM_TYPE_DECORATION) {
        return TRUE;
    }
     */
    if (item.existHunterRank <= session.searchHunterRank
        || item.existTownRank <= session.searchTownRank) {
        if (item.genderType == 0 || item.genderType == session.searchGenderType) {
            if (item.hunterType == 0 || item.hunterType == session.searchHunterType) {
                return TRUE;
            }
        }
    }
    return FALSE;
}
    
+(BOOL)isExistForNegativeSkill:(SkillSet*)skills: (PSItem*)item {
    for (int i = 0; i < skills.count; ++i) {
        for (int j = 0; j < item.skills.count; ++j) {
            SkillKind *k1 = [skills.listKind objectAtIndex:i];
            SkillKind *k2 = [item.skills.listKind objectAtIndex: j];
            if (k1 == k2) {
                if (skills.positive[i]) {
                    if (item.skills.point[j] < 0) {
                        return TRUE;
                    }
                } else {
                    if (item.skills.point[j] > 0) {
                        return TRUE;
                    }
                }
            }
        }
    }
    return FALSE;
}

+(BOOL)isExistForSkill:(SkillSet*) skills: (PSItem*) item {
    for (int i = 0; i < skills.count; ++i) {
        SkillKind* k1 = [skills.listKind objectAtIndex:i];

        for (int j = 0; j < item.skills.count; ++j) {
            SkillKind* k2 = [item.skills.listKind objectAtIndex:j];

            if (k1 == k2) {
                if (skills.positive[i]) {
                    if (item.skills.point[j] > 0) {
                        return TRUE;
                    }
                }else {
                    if (item.skills.point[j] < 0) {
                        return TRUE;
                    }
                }
            }
        }
    }
    return FALSE;
}

@end
