//
//  IProgress.m
//  ArmorP3V1
//

#import "PSProgressView.h"
#import "Repository.h"
#import "PSProgressView2.h"
#import "PSMutex.h"

@implementation PSProgressView

@synthesize cancelFlag = _cancelFlag;
@synthesize actionSheet = _actionSheet;

@synthesize progressBar = _progressBar;
@synthesize progressLabel = _progressLabel;

@synthesize progressBar2 = _progressBar2;
@synthesize progressLabel2 = _progressLabel2;

@synthesize labelText = _labelText;
@synthesize labelText2 = _labelText2;

@synthesize percent = _percent;
@synthesize percent2 = _percent2;

-(id)init {
    self = [super init];
    if (self) {
        Repository* repo = [Repository mainRepository];
        
        _actionSheet = [[UIActionSheet alloc] initWithTitle:@"少々お時間を頂きます\n\n\n\n\n"
                                                   delegate:self
                                          cancelButtonTitle:NSLocalizedString(@"STOP",nil)
                                     destructiveButtonTitle:nil
                                          otherButtonTitles:nil];
        _progressBar = [[UIProgressView alloc] initWithFrame:CGRectMake(30.0f, 40.0f, 240.0f, 90.0f)];
        _progressBar.progressViewStyle = UIProgressViewStyleDefault;
        _progressBar.progress = 0.0f;
        [_actionSheet addSubview:_progressBar];
        
        _progressLabel = [[UILabel alloc] initWithFrame:CGRectMake(30.0f, 50.0f, 240.0f, 20.0f)];
        _progressLabel.backgroundColor = [UIColor clearColor];
        _progressLabel.textColor = [UIColor whiteColor];
        _progressLabel.font = repo.userFont;
        [_actionSheet addSubview:_progressLabel];
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    [[PSMutex mainMutex] showMemoryAlertIfError];
    
    return self;
}

-(void)dealloc {
    [_actionSheet release];
    [_progressLabel release];
    [_progressBar release];
    [_progressBar2 release];
    [_labelText release];
    [super dealloc];
}

- (void)showSheet:(UIView*) view: (NSString*) title {
    @synchronized(self) {
        _progressBar.progress = 0;
        _progressLabel.text = title;
        while (view.superview != nil) {
            view = view.superview;
        }
    }
    [self performSelectorInBackground:@selector(showSheet_internal:) withObject:view];
}

-(void)showSheet_internal:(UIView *)view {
    @synchronized(self) {
        [_actionSheet showInView:view];
    }
}

-(void)setLabelText:(NSString *)labelText {
    @synchronized(self) {
        [_labelText release];
        _labelText = labelText;
        [_labelText retain];
        [self performSelectorOnMainThread:@selector(print_internal:) withObject:nil waitUntilDone:FALSE];
    }
}

-(NSString *)labelText {
    return _labelText;
}

-(void)setLabelText2:(NSString *)labelText2 {
    @synchronized(self) {
        [_labelText2 release];
        _labelText2 = labelText2;
        [_labelText2 retain];
    }
    [self performSelectorOnMainThread:@selector(print_internal:) withObject:nil waitUntilDone:FALSE];
}

-(NSString *)labelText2 {
    return _labelText2;
}

-(void)print_internal:(NSString *)text {
    @synchronized(self) {
        _progressLabel.text = _labelText;
        if (_progressLabel != nil) {
            _progressLabel.text = _labelText;
        }
        if (_progressLabel2 != nil) {
            _progressLabel2.text = _labelText2;
        }
    }
}

-(void)setPercent:(float)percent {
    _percent = percent;
    [self performSelectorOnMainThread:@selector(progress_internal:) withObject:nil waitUntilDone:FALSE];
}

-(void)setPercent2:(float)percent2 {
    _percent2 = percent2;
    [self performSelectorOnMainThread:@selector(progress_internal:) withObject:nil waitUntilDone:FALSE];
}

-(float)percent {
    return _percent;
}

-(float)percent2 {
    return _percent2;
}

- (void)progress_internal:(NSNumber *)amount {
    @synchronized(self) {
        _progressBar.progress = _percent / 100.0;
        _progressBar2.progress = _percent2 / 100.0;
    }
}

- (void)actionSheet:(UIActionSheet *)sheet didDismissWithButtonIndex:(NSInteger)buttonIndex {
	if (buttonIndex == sheet.cancelButtonIndex) {
		_cancelFlag = TRUE;
	}
}

- (void)finish {
    [self performSelectorOnMainThread:@selector(finish_internal:) withObject:nil waitUntilDone:TRUE];
}

- (void)finish_internal:(NSString*)dummy {
    [_actionSheet dismissWithClickedButtonIndex:-1 animated:YES];
    [_actionSheet release];
    _actionSheet = nil;
    [_progressLabel release];
    _progressLabel = nil;
    [_progressBar release];
    _progressBar = nil;
    [_progressBar2 release];
    _progressBar2 = nil;
    [_labelText release];
    _labelText = nil;
}

- (id<IProgress>)createSub {
    if (_subview == nil) {
        _progressBar2 = [[UIProgressView alloc] initWithFrame:CGRectMake(30.0f, 70.0f, 240.0f, 90.0f)];
        _progressBar2.progressViewStyle = UIProgressViewStyleDefault;
        _progressBar2.progress = 0.0f;
        [_actionSheet addSubview:_progressBar2];
        
        Repository* repo = [Repository mainRepository];
        _progressLabel2 = [[UILabel alloc] initWithFrame:CGRectMake(30.0f, 80.0f, 240.0f, 20.0f)];
        _progressLabel2.backgroundColor = [UIColor clearColor];
        _progressLabel2.textColor = [UIColor whiteColor];
        _progressLabel2.font = repo.userFont;
        [_actionSheet addSubview:_progressLabel2];
        
        [_actionSheet sizeToFit];
        
        _subview = [[PSProgressView2 alloc]initWithRoot:self];
    }
    return _subview;
}

@end
