//
//  IProgress.h
//  ArmorP3V1
//

#import <Foundation/Foundation.h>
#import "IProgress.h"

@interface PSProgressView : NSObject<IProgress, UIActionSheetDelegate> {
    float _percent;
    id<IProgress> _subview;
}

@property (readonly, retain) UIActionSheet* actionSheet;
@property (readonly, retain) UIProgressView* progressBar;
@property (readonly, retain) UILabel* progressLabel;

@property (nonatomic) BOOL cancelFlag;
@property (atomic, retain) NSString* labelText;
@property (atomic, assign) float percent;

@property (readonly, retain) UIProgressView* progressBar2;
@property (readonly, retain) UILabel* progressLabel2;

@property (atomic, retain) NSString* labelText2;
@property (atomic, assign) float percent2;

- (NSObject<IProgress>*)createSub;
- (void)showSheet:(UIView*) view: (NSString*) title;
- (void)showSheet_internal:(UIView*) view;
- (void)finish;

- (void)progress_internal:(NSNumber *)amount;
- (void)print_internal:(NSString*)text;
- (void)finish_internal:(NSStream*)dummy;

@end
