//
//  PSItemMaterial.m
//  MHP3SkillSim
//

#import "PSItemMaterial.h"
#import "PSMutex.h"

@implementation PSItemMaterial

-(id)init
{
    self = [super init];
    if (self) {
        nameList = [[NSMutableArray alloc]init];
        countList = [[NSMutableArray alloc]init];
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    [[PSMutex mainMutex] showMemoryAlertIfError];
    return self;
}

-(int)count
{
    return nameList.count;
}

-(NSString*) itemNameAtIndex:(int)index
{
    return (NSString*)[nameList objectAtIndex:index];
}

-(int) itemCountAtIndex:(int)index
{
    return [((NSNumber*)[countList objectAtIndex:index]) intValue];
}

-(void)addItem:(NSString*)itemName itemCount:(int)count
{
    NSNumber* num = [NSNumber numberWithInt:count];
    [nameList addObject:itemName];
    [countList addObject: num];
    [num release];
}

-(void)dealloc
{
    [nameList release];
    [countList release];
    [super dealloc];
}

@end
