//
//  IntArray.m
//  ArmorP3V1
//
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "IntArray.h"
#import "PSMutex.h"

@implementation IntArray

@synthesize array = _array;
@synthesize count = _count;

-(id)init
{
    self = [super init];
    if (self) {
        _array = nil;
        _count = 0;
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    [[PSMutex mainMutex] showMemoryAlertIfError];
    return self;
}

-(void)dealloc {
    if (_array != nil) {
        free(_array);
    }
    [super dealloc];
}

-(void)ensureCapacity:(NSInteger)number {
    if (_count < number) {
        int* newArray = calloc(sizeof(int), number);
        for (int i = 0; i < _count; ++ i) {
            newArray[i] = _array[i];
        }
        if (_array != nil) {
            free(_array);
        }
        _array = newArray;
        _count = number;
    }
}


@end
