//
//  DecorationMatcher.h
//  ArmorP3V1
//

#import <Foundation/Foundation.h>
#import "PSSession.h"
#import "SkillSet.h"
#import "RelationKey.h"
#import "IntArray.h"

#import "DecorationMatcher.h"
#import "Repository.h"
#import "DoubleArray.h"
#import "IntArray.h"
#import "DecorationSlot.h"
#import "PSWrap.h"
#import "PSItemType.h"
#import "MatrixBuilder.h"

@interface DecorationMatcher : NSObject {
}

@property (nonatomic, retain) NSMutableArray* decorations;
@property (nonatomic, assign) BOOL quickScan;
@property (nonatomic, assign) BOOL existConflict;
@property (nonatomic, retain) DecorationMatcher* conflictMatcher;
@property (nonatomic, retain) SkillSet* targetSkills;
@property (nonatomic, assign) BOOL useAnotherCheck;
@property (nonatomic, assign) BOOL existAnotherSlot;
@property (nonatomic, assign) BOOL existAnotherSkill;

@property (nonatomic, assign) int searchHunterType;
@property (nonatomic, assign) int searchHunterRank;
@property (nonatomic, assign) int searchTownRank;
@property (nonatomic, assign) int searchGenderType;

@property (nonatomic, retain) NSMutableDictionary* decorationWeight;
@property (nonatomic, assign) BOOL existSomeRelation;

@property (nonatomic, retain) NSMutableDictionary* relationCache;
@property (nonatomic, retain) RelationKey* pool1;
@property (nonatomic, retain) IntArray* step_cache;

@property (nonatomic, retain) SkillSet* cache1;

@property (nonatomic, retain) NSMutableArray* poolQueue;
@property (nonatomic, retain) NSMutableSet* poolAlready1;
@property (nonatomic, retain) NSMutableSet* poolAlready2;
@property (nonatomic, retain) DecorationSlot* firstSlot;

-(id)initWithData: (PSSession*)session;
-(double)getDecorationWeight:(SkillKind*)kind :(BOOL) range:(int)slotMax;
-(IntArray*)getPlusRelationCached: (SkillSet*)diffSkills;
-(IntArray*)getPlusRelation:(SkillSet*)diffSkills;
-(int)getNeedSlotCount:(DecorationSlot*)slot;
-(BOOL)canHaveEnoughDecoration:(PSArmorSet*)set :(BOOL)fullScan :(NSMutableArray*)result;
-(BOOL)checkUsableCount:(DecorationSlot*)set;
-(BOOL)decoIsForDiffSkill: (PSItem*) item: (SkillSet*) skills:(BOOL) quickScan;
-(BOOL)decoIsForSkillKind:(PSItem*) item: (SkillSet*) skills;
+(BOOL)existMoreSlot:(NSMutableArray*) prevResult;
-(int)fixRealWeaponSlot:(PSArmorSet*) set: (NSArray*) prevResult;
-(BOOL)isCharmHaveReplacement: (PSArmorSet*) set: (PSWrap*) noneItem;

@end
