//
//  CharmDB.m
//  ArmorP3V1
//
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "CharmDB.h"
#import "PSItem.h"
#import "Repository.h"
#import "StringHolder.h"
#import "PSMutex.h"

@implementation CharmDB

@synthesize acceptTypes = _acceptTypes;
@synthesize listCharm = _listCharm;
@synthesize isPermenent = _isPermenent;

#define STONE_NAZO  0
#define STONE_HIKAR 1
#define STONE_FURUI 2

-(id)init {
    self = [super init];
    if (self) {
        _listCharm = [[NSMutableArray alloc]init];
        _isPermenent = FALSE;
        if (_listCharm == nil) {
            [[PSMutex mainMutex] raiseMemoryError];
        }
    }else {
        [[PSMutex mainMutex] raiseMemoryError];
    }
    [[PSMutex mainMutex] showMemoryAlertIfError];
    return self;
}

-(void)dealloc {
    [_listCharm release];
    [super dealloc];
}

-(void)readProperties: (id<IProgress>)progress {
    [_listCharm removeAllObjects];
    _isPermenent = TRUE;
    progress.labelText = @"ロード中（なぞのお守り)";
    progress.percent = 30;
    [self readPropertiesSub: STONE_NAZO: @"CHARM_NAZO.csv"];
    progress.labelText = @"ロード中（光るお守り）";
    progress.percent = 60;
    [self readPropertiesSub: STONE_HIKAR: @"CHARM_HIKARU.csv"];
    progress.labelText = @"ロード中（古いお守り）";
    progress.percent = 90;
    [self readPropertiesSub: STONE_FURUI: @"CHARM_FURUI.csv"];
    progress.percent = 100;
}

-(void)readPropertiesSub:(int)stone:(NSString*)fileName {
    LineReader* in = [[LineReader alloc]init];
    
    if ([in readFile:fileName] == FALSE) {
        [in release];
        return;
    }
    
    while (TRUE) {
        if ([in parseNextLine] == FALSE) {
            break;
        }
        if (in.columnCount < 8) {
            continue;
        }
        NSString* strSeed = [in columnAtIndex:0];
        NSString* strSkill1 = [in columnAtIndex:1];
        NSString* strPoint1 = [in columnAtIndex:2];
        NSString* strSkill2 = [in columnAtIndex:3];
        NSString* strPoint2 = [in columnAtIndex:4];
        NSString* strSlot = [in columnAtIndex:5];
        NSString* strName = [in columnAtIndex:6];
        NSString* strTable = [in columnAtIndex:7];

        int nSeed;
        int nPoint1;
        int nPoint2;
        int nTable;
        int nSlot;
        SkillKind* kind1;
        SkillKind* kind2;

        nSeed = strSeed.intValue;
        nPoint1 = strPoint1.intValue;
        nPoint2 = strPoint2.intValue;
        nTable = strTable.intValue;
        nSlot = strSlot.intValue;
        kind1 = nil;
        kind2 = nil;
            
        if (strSkill1.length > 0) {
            kind1 = [SkillKind findKindByName: strSkill1];
        }
        if (strSkill2.length > 0) {
            kind2 = [SkillKind findKindByName: strSkill2];
        }

        PSItem* item = [[PSItem alloc]init];

        NSString* strName2 = [[NSString alloc]initWithFormat:@"%@ T%d", strName, nTable];
        item.name = [StringHolder intern: strName2];
        [strName2 release];
        item.slotCount = nSlot;
        item.charmStone = stone;
        item.charmTable = nTable;
        item.itemType = ITEM_TYPE_CHARM;
        
        if (kind1 != nil) {
            [item.skills set:kind1 :nPoint1 :TRUE];
        }
        if (kind2 != nil) {
            [item.skills set:kind2 :nPoint2 :TRUE];
        }
            
        if (kind1 != nil || kind2 != nil) {
            [_listCharm addObject: item];
        }
        [item release];
    }
    [in release];
}

-(NSMutableArray*)readExtraCharm:(int)charmTable:(SkillSet*)searchSkills:(id<IProgress>)progress {
    NSMutableArray* listCharm2 = [[NSMutableArray alloc]init];
    for (int j = 0; j < _listCharm.count; ++ j) {
        PSItem* charm = [_listCharm objectAtIndex:j];
        BOOL hit = FALSE;
        
        for (int i = 0; i < charm.skills.count; ++ i) {
            SkillKind* kind = [charm.skills.listKind objectAtIndex:i];
            int x = [searchSkills findByKind:kind];
            if (x >= 0) {
                if (searchSkills.positive[x]) {
                    if (charm.skills.point[i] > 0) {
                        hit = TRUE;
                        break;
                    }
                } else {
                    if (charm.skills.point[i] < 0) {
                        hit = TRUE;
                        break;
                    }
                }
            }
        }
        if (!hit) {
            continue;
        }
        
        [listCharm2 addObject: charm];
    }
    return listCharm2;
}

@end
