/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.gui.themes;

import java.awt.Font;
import java.awt.Window;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import portablesimulator.csv.Repository;
import portablesimulator.gui.themes.MetalForestTheme;
import portablesimulator.gui.themes.MetalSeaTheme;
import portablesimulator.gui.themes.MetalStoneTheme;
import portablesimulator.gui.themes.MetalWineTheme;

public class ThemeManager {
    public static final int THEME_SEA = 0;
    public static final int THEME_FOREST = 1;
    public static final int THEME_WINE = 2;
    public static final int THEME_STONE = 3;
    public static final int THEME_OS_DEFAULT = 4;
    public static final int THEME_JAVA_DEFAULT = 5;
    public static final int THEME_GTK_DEFAULT = 6;

    public static void setMetalTheme(int type) {
        block14: {
            UIManager.put("swing.boldMetal", Boolean.FALSE);
            try {
                if (type == 4) {
                    String className = UIManager.getSystemLookAndFeelClassName();
                    UIManager.setLookAndFeel(className);
                    Repository.getConfig().themeLabelColorful = false;
                    break block14;
                }
                if (type == 5) {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!"Metal".equalsIgnoreCase(info.getName())) continue;
                        OceanTheme theme = new OceanTheme();
                        MetalLookAndFeel.setCurrentTheme(theme);
                        UIManager.setLookAndFeel(info.getClassName());
                        break;
                    }
                    Repository.getConfig().themeLabelColorful = false;
                    break block14;
                }
                if (type == 6) {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!"Nimbus".equalsIgnoreCase(info.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        break;
                    }
                    Repository.getConfig().themeLabelColorful = false;
                    break block14;
                }
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!"Metal".equalsIgnoreCase(info.getName())) continue;
                    DefaultMetalTheme theme = null;
                    Repository.getConfig().themeLabelColorful = true;
                    switch (type) {
                        case 1: {
                            theme = new MetalForestTheme();
                            break;
                        }
                        case 2: {
                            theme = new MetalWineTheme();
                            break;
                        }
                        case 0: {
                            theme = new MetalSeaTheme();
                            break;
                        }
                        case 3: {
                            theme = new MetalStoneTheme();
                        }
                    }
                    MetalLookAndFeel.setCurrentTheme(theme);
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setFont(String name, int style, int size) {
        for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
            if (!entry.getKey().toString().toLowerCase().endsWith("font")) continue;
            Font f2 = new Font(name, style, size);
            FontUIResource f1 = new FontUIResource(f2);
            UIManager.put(entry.getKey(), f1);
        }
    }

    public static void updateUITree() {
        Window[] win = Window.getWindows();
        for (int i = 0; i < win.length; ++i) {
            SwingUtilities.updateComponentTreeUI(win[i]);
            if (!(win[i] instanceof JDialog)) continue;
            win[i].pack();
        }
    }
}

