/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.decoration;

import java.util.ArrayList;
import portablesimulator.PSArmorSet;
import portablesimulator.PSItem;
import portablesimulator.PSWrap;
import portablesimulator.decoration.DecorationCount;
import portablesimulator.gui.PSFrame;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillSet;

public class DecorationSlot
implements Comparable {
    public final int[] slotCount = new int[7];
    public final int[] slotAvail = new int[7];
    public final ArrayList<PSItem> listDeco;
    public DecorationCount mapDecoration;
    public DecorationCount mapBodyDecoration;
    public final SkillSet diffSkills = new SkillSet();
    public PSArmorSet armorSet;
    int hash = -1;

    private DecorationSlot(DecorationSlot from) {
        this.mapDecoration = from.mapDecoration.makeCopy();
        this.mapBodyDecoration = from.mapBodyDecoration.makeCopy();
        for (int i = 0; i < this.slotCount.length; ++i) {
            this.slotCount[i] = from.slotCount[i];
            this.slotAvail[i] = from.slotAvail[i];
        }
        this.listDeco = from.listDeco;
        this.armorSet = from.armorSet;
        this.diffSkills.set_all(from.diffSkills);
    }

    public DecorationSlot(ArrayList<PSItem> decorations) {
        this.listDeco = decorations;
    }

    public DecorationSlot(ArrayList<PSItem> decorations, SkillSet diffSkills, PSArmorSet set, int weaponSlotCount) {
        this.listDeco = decorations;
        this.construct(diffSkills, set, weaponSlotCount);
    }

    public void construct(SkillSet diffSkills, PSArmorSet set, int weaponSlotCount) {
        int i;
        this.mapDecoration = new DecorationCount(this.listDeco);
        this.mapBodyDecoration = new DecorationCount(this.listDeco);
        this.armorSet = set;
        this.diffSkills.set_all(diffSkills);
        int x = 1;
        for (i = 0; i < set.listItems.size(); ++i) {
            PSWrap wrap = set.listItems.get(i);
            PSItem item = wrap.item;
            if (i == 1) {
                this.slotCount[0] = item.slotCount;
                continue;
            }
            if (item.isCopieSkill) {
                this.slotCount[x] = -1;
                ++x;
                continue;
            }
            this.slotCount[x] = item.slotCount;
            ++x;
        }
        this.slotCount[x] = weaponSlotCount;
        for (i = 0; i < this.slotAvail.length; ++i) {
            this.slotAvail[i] = this.slotCount[i] < 0 ? 0 : this.slotCount[i];
        }
    }

    public int totalAvailCount() {
        int total = 0;
        for (int i = 0; i < this.slotCount.length; ++i) {
            if (this.slotCount[i] == -1) {
                total += this.slotAvail[0];
                continue;
            }
            total += this.slotAvail[i];
        }
        return total;
    }

    public int getBodyAvailable() {
        if (this.armorSet.bodyCopieCount >= 1) {
            return this.slotAvail[0];
        }
        return 0;
    }

    public boolean haveCopie() {
        return this.armorSet.bodyCopieCount > 0;
    }

    public DecorationSlot applyToBody(PSItem deco) {
        if (this.armorSet.bodyCopieCount >= 1 && this.slotAvail[0] >= deco.slotCount) {
            DecorationSlot cache = new DecorationSlot(this);
            cache.slotAvail[0] = cache.slotAvail[0] - deco.slotCount;
            cache.mapBodyDecoration.increment(deco);
            for (int x = 0; x <= this.armorSet.bodyCopieCount; ++x) {
                cache.diffSkills.minus_only(deco.skills);
            }
            return cache;
        }
        return null;
    }

    public DecorationSlot applyAuto(PSItem deco) {
        int i;
        int foundX = -1;
        int foundWidth = -1;
        int n = i = this.armorSet.bodyCopieCount > 0 ? 1 : 0;
        while (i < this.slotCount.length) {
            if (this.slotAvail[i] >= deco.slotCount && foundX < 0) {
                foundX = i;
                foundWidth = this.slotAvail[i];
                break;
            }
            ++i;
        }
        if (foundX < 0) {
            return null;
        }
        if (foundX >= 0) {
            DecorationSlot cache = new DecorationSlot(this);
            cache.diffSkills.minus_only(deco.skills);
            int n2 = foundX;
            cache.slotAvail[n2] = cache.slotAvail[n2] - deco.slotCount;
            cache.mapDecoration.increment(deco);
            return cache;
        }
        return null;
    }

    public DecorationSlot applyAutoFixed(PSItem deco) {
        int i;
        int foundX = -1;
        int foundWidth = -1;
        int n = i = this.armorSet.bodyCopieCount > 0 ? 1 : 0;
        while (i < this.slotCount.length) {
            if (this.slotAvail[i] == deco.slotCount) {
                foundX = i;
                foundWidth = this.slotAvail[i];
                break;
            }
            ++i;
        }
        if (foundX < 0) {
            return null;
        }
        if (foundX >= 0) {
            DecorationSlot cache = new DecorationSlot(this);
            cache.diffSkills.minus_only(deco.skills);
            int n2 = foundX;
            cache.slotAvail[n2] = cache.slotAvail[n2] - deco.slotCount;
            return cache;
        }
        return null;
    }

    public int getSlotMaxCount() {
        int i;
        int width = 0;
        int n = i = this.armorSet.bodyCopieCount > 0 ? 1 : 0;
        while (i < this.slotCount.length) {
            if (width < this.slotAvail[i]) {
                width = this.slotAvail[i];
            }
            ++i;
        }
        if (this.armorSet.bodyCopieCount > 0 && width < this.slotAvail[0]) {
            width = this.slotAvail[0];
        }
        return width;
    }

    public int getWeaponSlotAvailable() {
        int i;
        int weaponSlotCount = this.armorSet.weaponSlotCount;
        int width = 0;
        int n = i = this.armorSet.bodyCopieCount > 0 ? 1 : 0;
        while (i < this.slotCount.length) {
            if (this.slotCount[i] >= weaponSlotCount && width < this.slotAvail[i]) {
                width = this.slotAvail[i];
            }
            ++i;
        }
        return width;
    }

    public int getCharmSlotAvailable() {
        int i;
        int charmSlotCount = this.slotCount[5];
        int width = 0;
        int n = i = this.armorSet.bodyCopieCount > 0 ? 1 : 0;
        while (i < this.slotCount.length) {
            if (this.slotCount[i] >= charmSlotCount && width < this.slotAvail[i]) {
                width = this.slotAvail[i];
            }
            ++i;
        }
        return width;
    }

    public SkillSet getFullDecorationSkills() {
        int i;
        int count;
        PSItem deco;
        int x;
        SkillSet skills = new SkillSet();
        for (x = 0; x < this.mapDecoration.size(); ++x) {
            deco = this.mapDecoration.deco(x);
            count = this.mapDecoration.count(x);
            for (i = 0; i < count; ++i) {
                skills.sum_all(deco.skills);
            }
        }
        for (x = 0; x < this.mapBodyDecoration.size(); ++x) {
            deco = this.mapBodyDecoration.deco(x);
            count = this.mapBodyDecoration.count(x);
            for (i = 0; i < count; ++i) {
                for (int j = 0; j <= this.armorSet.bodyCopieCount; ++j) {
                    skills.sum_all(deco.skills);
                }
            }
        }
        return skills;
    }

    private int[] copyIntArray(int[] from) {
        int[] to = new int[from.length];
        for (int i = 0; i < from.length; ++i) {
            to[i] = from[i];
        }
        return to;
    }

    public String simpleToString(DecorationCount map) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < map.size(); ++i) {
            PSItem deco = map.deco(i);
            int count = map.count(i);
            if (count == 0) continue;
            if (str.length() > 0) {
                str.append("\u3001");
            }
            str.append(deco.name);
            str.append("\u00d7");
            str.append(PSFrame.Zenkaku(String.valueOf(count)));
        }
        return str.toString();
    }

    public String toDecorationString() {
        StringBuilder str = new StringBuilder();
        if (!this.mapBodyDecoration.isEmpty()) {
            str.append("\u3010\u80f4\uff1a" + this.simpleToString(this.mapBodyDecoration) + "\u3011");
        }
        str.append(this.simpleToString(this.mapDecoration));
        return str.toString();
    }

    public int countEmptyForDisp() {
        int count = 0;
        for (int i = 0; i < this.slotAvail.length; ++i) {
            if (this.slotAvail[i] < 1) continue;
            count += this.slotAvail[i];
        }
        return count;
    }

    public int compareTo(Object t) {
        DecorationSlot target = (DecorationSlot)t;
        int x = 0;
        if (x == 0) {
            for (int i = 0; i < this.slotCount.length && (x = this.slotAvail[i] - target.slotAvail[i]) == 0; ++i) {
            }
        }
        if (x == 0) {
            x = this.mapDecoration.compareTo(target.mapDecoration);
        }
        if (x == 0) {
            x = this.mapBodyDecoration.compareTo(target.mapBodyDecoration);
        }
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        int i;
        DecorationSlot target = (DecorationSlot)o;
        for (i = 0; i < this.slotCount.length; ++i) {
            int x = this.slotAvail[i] - target.slotAvail[i];
            if (x == 0) continue;
            return false;
        }
        if (this.diffSkills.listKind != target.diffSkills.listKind) {
            throw new Error("errro");
        }
        for (i = 0; i < this.diffSkills.size; ++i) {
            int n2;
            int n1 = target.diffSkills.point(i);
            if (n1 == (n2 = this.diffSkills.point(i))) continue;
            return false;
        }
        return true;
    }

    public void calculateHash() {
        long x = 0L;
        for (int i = 0; i < this.slotAvail.length; ++i) {
            x *= 7L;
            x += (long)this.slotAvail[i];
        }
        x += (long)(this.mapDecoration.hashCode() * 13);
        this.hash = (int)((x += (long)(this.mapBodyDecoration.hashCode() * 7)) & Integer.MAX_VALUE);
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.calculateHash();
        }
        return this.hash;
    }

    public String toString() {
        return "[" + this.totalAvailCount() + " avail, " + this.getFullDecorationSkills() + "\n" + this.toDecorationString() + "]";
    }

    public int getNeedPoint() {
        int x = 0;
        for (int i = 0; i < this.diffSkills.size(); ++i) {
            SkillKind kind = this.diffSkills.kind(i);
            boolean positive = this.diffSkills.positive(i);
            int point = this.diffSkills.point(i);
            if (positive) {
                if (point <= 0) continue;
                x += point;
                continue;
            }
            if (point >= 0) continue;
            x -= point;
        }
        return x;
    }

    boolean canRemoveFromNotBody() {
        for (int x = 0; x < this.mapDecoration.size(); ++x) {
            int count = this.mapDecoration.count(x);
            if (count == 0) continue;
            PSItem deco = this.mapBodyDecoration.deco(x);
            for (int i = 0; i < this.diffSkills.size(); ++i) {
                SkillKind kind = this.diffSkills.kind(i);
                boolean positive = this.diffSkills.positive(i);
                int point = this.diffSkills.point(i);
                int over = 0;
                if (positive) {
                    if (point > 0) {
                        over = point;
                    }
                } else if (point < 0) {
                    over = -point;
                }
                if (over <= 0) continue;
                for (int j = 0; j < deco.skills.size(); ++j) {
                    SkillKind kind2 = deco.skills.kind(j);
                    int point2 = deco.skills.point(j);
                    if (kind2 != kind) continue;
                    if (!deco.skills.positive(j)) {
                        point2 = -point2;
                    }
                    if (point2 > over) continue;
                    return true;
                }
            }
        }
        return false;
    }

    boolean canRemoveFromBody() {
        if (this.armorSet.bodyCopieCount == 0) {
            return false;
        }
        for (int x = 0; x < this.mapBodyDecoration.size(); ++x) {
            int count = this.mapBodyDecoration.count(x);
            if (count == 0) continue;
            PSItem deco = this.mapBodyDecoration.deco(x);
            for (int i = 0; i < this.diffSkills.size(); ++i) {
                SkillKind kind = this.diffSkills.kind(i);
                boolean positive = this.diffSkills.positive(i);
                int point = this.diffSkills.point(i);
                int over = 0;
                if (positive) {
                    if (point < 0) {
                        over = -point;
                    }
                } else if (point > 0) {
                    over = point;
                }
                if (over <= 0) continue;
                for (int j = 0; j < deco.skills.size(); ++j) {
                    SkillKind kind2 = deco.skills.kind(j);
                    if (kind2 != kind) continue;
                    int point2 = deco.skills.point(j);
                    if ((point2 = point2 * this.armorSet.bodyCopieCount + point2) > over) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

