/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator;

import java.util.ArrayList;
import java.util.List;
import portablesimulator.PSItemMaterial;
import portablesimulator.csv.PSBaseItems;
import portablesimulator.csv.Repository;
import portablesimulator.skillset.SkillSet;

public final class PSItem
implements Comparable {
    private static int staticSeq = 0;
    public final int itemSeq;
    public final int itemType;
    public String name = "--";
    public int genderType = 0;
    public int hunterType = 0;
    public int rareRank = 0;
    public int slotCount = 0;
    public int existHunterRank = 0;
    public int existTownRank = 0;
    public int defInitial = 0;
    public int defMax = 0;
    public int shellFire = 0;
    public int shellWater = 0;
    public int shellIce = 0;
    public int shellThunder = 0;
    public int shellDragon = 0;
    public ArrayList<PSItem> sameGroup = null;
    public ArrayList<PSItemMaterial> materialAList = new ArrayList();
    public ArrayList<PSItemMaterial> materialBList = new ArrayList();
    public SkillSet skills = new SkillSet(5);
    public boolean isCopieSkill = false;
    public boolean isVirtual = false;
    public boolean isVirtualNone = false;
    public boolean viewFound;
    public int viewCount;
    public int _hashCode = -1;
    static ArrayList<ArrayList<PSItem>> cachedVirtual = new ArrayList();
    public static final int VIRTUAL_NONE = -2;
    public static final int VIRTUAL_COPIE = -1;
    public static final int VIRTUAL_SLOT0 = 0;
    public static final int VIRTUAL_SLOT1 = 1;
    public static final int VIRTUAL_SLOT2 = 2;
    public static final int VIRTUAL_SLOT3 = 3;

    public PSItem(int itemType) {
        this.itemSeq = staticSeq++;
        this.itemType = itemType;
    }

    public PSItem(int itemType, String name) {
        this.itemSeq = staticSeq++;
        this.itemType = itemType;
        this.name = name;
    }

    public int hashCode() {
        if (this._hashCode < 0) {
            this._hashCode = this.name.hashCode() * (this.slotCount + 1);
            this._hashCode &= Integer.MAX_VALUE;
        }
        return this._hashCode;
    }

    public String formatGenderType() {
        switch (this.genderType) {
            case 0: {
                return "\u7537\u5973\u517c\u7528";
            }
            case 1: {
                return "\u7537";
            }
            case 2: {
                return "\u5973";
            }
        }
        return "\u4e0d\u660e";
    }

    public String formatHunterType() {
        switch (this.hunterType) {
            case 0: {
                return "\u5263\u58eb\u30ac\u30f3\u30ca\u30fc\u517c\u7528";
            }
            case 1: {
                return "\u5263\u58eb";
            }
            case 2: {
                return "\u30ac\u30f3\u30ca\u30fc";
            }
        }
        return "\u4e0d\u660e";
    }

    public String formatPartsName() {
        switch (this.itemType) {
            case 0: {
                return "\u982d\u9632\u5177";
            }
            case 1: {
                return "\u80f4\u9632\u5177";
            }
            case 2: {
                return "\u8155\u9632\u5177";
            }
            case 3: {
                return "\u8170\u9632\u5177";
            }
            case 4: {
                return "\u8db3\u9632\u5177";
            }
            case 5: {
                return "\u304a\u5b88\u308a";
            }
            case 6: {
                return "\u88c5\u98fe\u54c1";
            }
        }
        return "\u4e0d\u660e";
    }

    public String getArmorNameAndSlot() {
        PSItem item = this;
        if (item.isVirtualNone) {
            return item.name;
        }
        if (item.isCopieSkill) {
            return item.name + "[\u80f4\u7cfb\u7d71\u8907\u88fd]";
        }
        if (item.itemType == 5) {
            return item.name + item.skills.skillToString(null, true) + "[" + item.slotCount + "]";
        }
        return item.name + "[" + item.slotCount + "]";
    }

    public String getArmorName() {
        PSItem item = this;
        if (item.isVirtualNone) {
            return item.name;
        }
        if (item.isCopieSkill) {
            return item.name;
        }
        if (item.itemType == 5) {
            return item.name + item.skills.skillToString(null, true);
        }
        return item.name;
    }

    public String toString() {
        return this.getArmorNameAndSlot();
    }

    public String getFormatted() {
        StringBuilder str = new StringBuilder();
        String LF = "\n";
        str.append("HR[" + this.existHunterRank + "] / \u6751:[\u2606" + this.existTownRank + "]" + LF);
        str.append(this.name + " Rare[" + this.rareRank + "][" + this.formatGenderType() + " " + this.formatHunterType() + "]" + LF);
        if (this.itemType != 5 && this.itemType != 6) {
            str.append("\u9632[" + this.defMax + "(\u672a\u5f37\u5316" + this.defInitial + ")]" + LF);
        }
        str.append("\u30b9\u30ed[" + this.slotCount + "]" + LF);
        if (this.itemType != 5 && this.itemType != 6) {
            str.append("[\u706b" + this.shellFire + "]" + "[\u6c34" + this.shellWater + "]" + "[\u6c37" + this.shellIce + "]" + "[\u96f7" + this.shellThunder + "]" + "[\u9f8d" + this.shellDragon + "]" + LF);
        }
        if (this.isCopieSkill) {
            str.append("[\u80f4\u7cfb\u7d71\u8907\u88fd]" + LF);
        } else {
            str.append("\u30b9\u30ad\u30eb\u30dd\u30a4\u30f3\u30c8[");
            str.append(this.skills.skillToString(null, false));
            str.append("]" + LF);
        }
        if (this.itemType != 5) {
            str.append("\u7d20\u6750\u4e00\u89a7{" + LF);
            for (PSItemMaterial mt : this.materialAList) {
                str.append("\u3000");
                str.append(mt.name + "\u00d7" + mt.count + LF);
            }
            str.append("}" + LF);
            if (!this.materialBList.isEmpty()) {
                str.append("\u7d20\u6750\u4e00\u89a7\u3001\u305d\u306e\uff12{" + LF);
                for (PSItemMaterial mt : this.materialBList) {
                    str.append("\u3000");
                    str.append(mt.name + "\u00d7" + mt.count + LF);
                }
                str.append("}" + LF);
            }
        }
        return str.toString();
    }

    public boolean equals(Object t) {
        if (this == t) {
            return true;
        }
        return this.compareTo((PSItem)t) == 0;
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        PSItem item = (PSItem)o;
        int x = 0;
        if (x == 0) {
            x = this.itemSeq - item.itemSeq;
        }
        if (x == 0) {
            x = this.itemType - item.itemType;
        }
        if (x == 0 && !this.isVirtual && !item.isVirtual && this.itemType != 5) {
            x = this.itemSeq - item.itemSeq;
        }
        if (x == 0) {
            x = this.rareRank - item.rareRank;
        }
        if (x == 0) {
            x = this.genderType - item.genderType;
        }
        if (x == 0) {
            x = this.hunterType - item.hunterType;
        }
        if (x == 0) {
            x = this.name.compareTo(item.name);
        }
        if (x == 0) {
            x = this.slotCount - item.slotCount;
        }
        if (x == 0) {
            x = this.skills.compareTo(item.skills);
        }
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        return 0;
    }

    public static PSItem getVirtualItem(int itemType, int slotCount) {
        List list;
        block21: {
            while (cachedVirtual.size() <= itemType) {
                cachedVirtual.add(new ArrayList());
            }
            list = cachedVirtual.get(itemType);
            if (list.size() != 0) break block21;
            if (itemType == 5) {
                for (int i = -2; i <= 3; ++i) {
                    PSItem item = null;
                    switch (i) {
                        case -2: {
                            item = new PSItem(itemType, "\u306a\u3057");
                            item.isVirtual = true;
                            item.isVirtualNone = true;
                            break;
                        }
                        case -1: {
                            item = new PSItem(itemType, "Copie");
                            item.isVirtual = false;
                            item.isCopieSkill = true;
                            break;
                        }
                        case 0: {
                            item = new PSItem(itemType, "\u306a\u3057");
                            item.isVirtual = true;
                            item.slotCount = 0;
                            break;
                        }
                        case 1: {
                            item = new PSItem(itemType, "\u304a\u5b88\u308a");
                            item.isVirtual = true;
                            item.slotCount = 1;
                            break;
                        }
                        case 2: {
                            item = new PSItem(itemType, "\u304a\u5b88\u308a");
                            item.isVirtual = true;
                            item.slotCount = 2;
                            break;
                        }
                        case 3: {
                            item = new PSItem(itemType, "\u304a\u5b88\u308a");
                            item.isVirtual = true;
                            item.slotCount = 3;
                        }
                    }
                    list.add(item);
                }
            } else {
                for (int i = -2; i <= 3; ++i) {
                    PSItem item = null;
                    switch (i) {
                        case -2: {
                            item = new PSItem(itemType, "\u306a\u3057");
                            item.isVirtual = true;
                            item.isVirtualNone = true;
                            break;
                        }
                        case -1: {
                            item = new PSItem(itemType, "Copie");
                            item.isVirtual = false;
                            item.isCopieSkill = true;
                            break;
                        }
                        case 0: {
                            item = new PSItem(itemType, "\u306a\u3057");
                            item.isVirtual = true;
                            item.slotCount = 0;
                            break;
                        }
                        case 1: {
                            item = new PSItem(itemType, "\u30b9\u30ed\u30c3\u30c8\uff11");
                            item.isVirtual = true;
                            item.slotCount = 1;
                            break;
                        }
                        case 2: {
                            item = new PSItem(itemType, "\u30b9\u30ed\u30c3\u30c8\uff12");
                            item.isVirtual = true;
                            item.slotCount = 2;
                            break;
                        }
                        case 3: {
                            item = new PSItem(itemType, "\u30b9\u30ed\u30c3\u30c8\uff13");
                            item.isVirtual = true;
                            item.slotCount = 3;
                        }
                    }
                    list.add(item);
                }
            }
        }
        return (PSItem)list.get(slotCount + 2);
    }

    public static PSItem getInstanceByName(int itemType, String name) {
        PSItem found = null;
        ArrayList<PSItem> itemList = null;
        PSBaseItems datas = Repository.getBaseItems();
        switch (itemType) {
            case 0: {
                itemList = datas.listEquipHead;
                break;
            }
            case 1: {
                itemList = datas.listEquipBody;
                break;
            }
            case 2: {
                itemList = datas.listEquipArm;
                break;
            }
            case 3: {
                itemList = datas.listEquipWeist;
                break;
            }
            case 4: {
                itemList = datas.listEquipLeg;
                break;
            }
            case 5: {
                itemList = null;
                break;
            }
            case 6: {
                itemList = datas.listDecoration;
                break;
            }
            default: {
                return null;
            }
        }
        for (int slotCount = -2; slotCount <= 3; ++slotCount) {
            PSItem item = PSItem.getVirtualItem(itemType, slotCount);
            if (!item.name.equals(name)) continue;
            found = item;
            break;
        }
        if (found == null && itemType != 5) {
            for (PSItem item : itemList) {
                if (!item.name.equals(name)) continue;
                found = item;
                break;
            }
        }
        return found;
    }
}

