package portablesimulator.skillset;

public final class SkillPoint implements Comparable {
    public SkillPoint(SkillKind kind, int point, boolean positiveRange) {
        this.skillKind = kind;
        this.skillPoint = point;
        this.pointName = "";
        this.positiveRange = positiveRange;
        if (kind == null) {
            throw new NullPointerException("null");
        }
    }

    public SkillPoint(SkillKind kind, int point, boolean positiveRange, String name) {
        this.skillKind = kind;
        this.skillPoint = point;
        this.positiveRange = positiveRange;
        this.pointName = name;
        if (kind == null) {
            throw new NullPointerException("null(" + name + ")");
        }
    }

    public String toString() {
        if (pointName != null && pointName.length() > 0) {
            return pointName;
        }
        return toPointString();
    }

    public String toPointString() {
        return skillKind.name + "=" + skillPoint + (positiveRange ? "" : "-");
    }

    public int hashCode() {
        return skillKind.name.hashCode() + skillPoint + (positiveRange ? 10 : -10);
    }

    public boolean equals(Object o) {
        SkillPoint p = (SkillPoint)o;
        if (skillKind == p.skillKind) {
            if (skillPoint == p.skillPoint) {
                if (positiveRange == p.positiveRange) {
                    return true;
                }
            }
        }
        return false;
    }

    public final SkillKind skillKind;
    public int skillPoint;
    public final String pointName;
    public final boolean positiveRange;

    public int compareTo(Object o) {
        SkillPoint that = (SkillPoint)o;
        if (this == that) {
            return 0;
        }
        int x = skillKind.compareTo(that.skillKind);
        if (x == 0) {
            x = skillPoint - that.skillPoint;
        }
        if (x == 0) {
            x = (positiveRange ? 1 : 0) - (that.positiveRange ? 1 : 0);
        }
        if (x < 0) return -1;
        if (x > 0) return  1;
        return 0;
    }
}
