package portablesimulator.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import javax.swing.JPanel;

public class MyPanelForImage extends JPanel {

    Image image;
    ImageObserver observer = new ImageObserver() {

        public boolean imageUpdate(Image image, int i, int i1, int i2, int i3, int i4) {
            if (i == ALLBITS) {
                return false;
            }
            return true;
        }
    };

    public MyPanelForImage(Image image) {
        this.image = image;
        super.setPreferredSize(new Dimension(image.getWidth(observer), image.getHeight(observer)));
    }

    public void paint(Graphics g) {
        Dimension size = getSize();
        int width = size.width;
        int height = size.height;
        int imageWidth = image.getWidth(observer);
        int imageHeight = image.getHeight(observer);
        if (width < imageWidth) {
            imageHeight = imageHeight * width / imageWidth;
            imageWidth = width;
        }
        if (height < imageHeight) {
            imageWidth = imageWidth * height / imageHeight;
            imageHeight = height;
        }
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, size.width, size.height);
        g.drawImage(image, 0, 0, imageWidth, imageHeight, observer);
    }
}
