package portablesimulator.gui;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class MyComboBoxUtil {
    public static MyComboBoxElement getComboSelected(JComboBox box) {
        DefaultComboBoxModel model = (DefaultComboBoxModel) box.getModel();
        return (MyComboBoxElement) model.getSelectedItem();
    }

    public static Object getComboSelectedValue(JComboBox box) {
        MyComboBoxElement item = getComboSelected(box);
        if (item != null) {
            return item.getValue();
        }
        return null;
    }

    public static int getComboSelectedInt(JComboBox box, int defaultValue) {
        Object value = getComboSelectedValue(box);
        if (value == null) {
            return defaultValue;
        }
        return (Integer) value;
    }

    public static void setComboSelectedInt(JComboBox box, int value) {
        DefaultComboBoxModel model = (DefaultComboBoxModel) box.getModel();
        for(int i = 0; i < model.getSize(); ++ i) {
            MyComboBoxElement item = (MyComboBoxElement)model.getElementAt(i);
            Integer itemValue = (Integer)item.getValue();
            if (itemValue != null) {
                if (itemValue == value) {
                    model.setSelectedItem(item);
                    return;
                }
            }
        }
    }

    public static void setComboSelectedValue(JComboBox box, Object value) {
        DefaultComboBoxModel model = (DefaultComboBoxModel) box.getModel();
        for(int i = 0; i < model.getSize(); ++ i) {
            MyComboBoxElement item = (MyComboBoxElement)model.getElementAt(i);
            Object itemValue = item.getValue();
            if (itemValue != null) {
                if (itemValue == value) {
                    model.setSelectedItem(item);
                    return;
                }
            }
        }
    }
}
