package portablesimulator.decoration;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import portablesimulator.PSArmorSet;
import portablesimulator.PSItem;
import portablesimulator.PSItemType;
import portablesimulator.PSWrap;
import portablesimulator.csv.PSSession;
import portablesimulator.csv.Repository;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillSet;

public class DecorationMatcherFull {

    public ArrayList<PSItem> _listDeco;
    public ArrayList<PSItem> _listDecoMatome;
    public int[] _relationDeco;
    public boolean _quickScan = true;
    public PSSession _session;
    public SkillSet _targetSkills;
    public boolean _useAnotherCheck = false;
    public boolean _existAnotherSlot = false;
    public boolean _existAnotherSkill = false;
    public int[] decosScore;
    public boolean _debug = false;
    public DecorationMatcherFull _conflictMatcher = null;
    public int[] _existRelation = null;
    public boolean _existConflict = false;
    public boolean useFixed = false;
    
    DecorationSlot slot;

    public DecorationMatcherFull(PSSession session) {
        this(session, false);
    }

    public DecorationMatcherFull(PSSession session, boolean useFixed) {
        this.useFixed = false;//useFixed;
        this._session = session;
        this._targetSkills = _session.searchSkills;
        this._listDeco = new ArrayList<PSItem>();

        ArrayList<PSItem> deco0 = new ArrayList<PSItem>();
        ArrayList<PSItem> deco1 = new ArrayList<PSItem>();
        ArrayList<PSItem> deco2 = new ArrayList<PSItem>();
        ArrayList<PSItem> deco3 = new ArrayList<PSItem>();
        for (int i = 0; i < Repository.getBaseItems().listDecoration.size(); ++i) {
            PSItem deco = Repository.getBaseItems().listDecoration.get(i);
            if (decoIsForSkillKind(deco, _session.searchSkills)) {
                if (_session.searchWithUsableStatus && _session.items.searchUsableCount != null) {
                    int uc = _session.items.searchUsableCount.get(deco);
                    if (uc == 0) {
                        continue;
                    }
                    if (uc != Integer.MAX_VALUE) {
                        _quickScan = false;
                    }
                } else {
                    if (deco.existHunterRank > _session.searchHunterRank
                            && deco.existTownRank > _session.searchTownRank) {
                        continue;
                    }
                }
                switch(deco.slotCount) {
                    case 0:
                        deco0.add(deco);
                        break;
                    case 1:
                        deco1.add(deco);
                        break;
                    case 2:
                        deco2.add(deco);
                        break;
                    case 3:
                        deco3.add(deco);
                        break;
                }
            }
        }

        for (int x = 1; x <= 3; ++ x) {
            ArrayList<PSItem> list = null;
            switch(x) {
                case 0:
                    list = deco0;
                    break;
                case 1:
                    list = deco1;
                    break;
                case 2:
                    list = deco2;
                    break;
                case 3:
                    list = deco3;
                    break;
            }
            ArrayList<PSItem> dummyList = new ArrayList<PSItem>();
            for (int i = 0; i < list.size(); ++ i) {
                PSItem i1 = list.get(i);
                if (i1.isVirtual) {
                    continue;
                }
                SkillSet is = i1.skills.fixColumnBy(_targetSkills);
                
                PSItem dummy = null;
                for (int j = i + 1; j < list.size(); ++ j) {
                    PSItem j1 = list.get(j);
                    if (j1.isVirtual) {
                        continue;
                    }
                    SkillSet js = j1.skills.fixColumnBy(_targetSkills);
                    if (is.equals(js)) {
                        if (dummy == null) {
                            dummy = new PSItem(PSItemType.TYPE_CHARM, " [" + is.canonicalString()+ "]");
                            dummy.slotCount = x;
                            dummy.isVirtual = true;
                            dummyList.add(dummy);
                        }
                        if (dummy.sameGroup == null) {
                            dummy.sameGroup = new ArrayList<PSItem>();
                        }
                        dummy.sameGroup.add(j1);
                        list.remove(j);
                        j --;
                        continue;
                    }
                }
                if (dummy != null) {
                    if (dummy.sameGroup == null) {
                        dummy.sameGroup = new ArrayList<PSItem>();
                    }
                    dummy.sameGroup.add(i1);
                    list.remove(i);
                    i --;
                    continue;
                }
            }
            list.addAll(dummyList);
            _listDeco.addAll(list);
        }

        _existRelation = getPlusRelation(_session.searchSkills);
        if (_existRelation != null) {
            for (int i = 0; i < _existRelation.length; ++i) {
                if (_existRelation[i] != 0) {
                    _existConflict = true;
                }
            }
        }
        if (_existConflict) {
            SkillSet skill1 = _session.searchSkills;
            SkillSet skill2 = new SkillSet();
            //skill2.set_all(skill1);
            for (int x = 0; x < skill1.size(); ++x) {
                if (skill1.positive(x) == true) {
                    if (skill1.point(x) > 0) {
                        skill2.set(skill1.kind(x), skill1.point(x), skill1.positive(x));
                    }
                } else {
                    //skill2.set(skill1.kind(x), 0, skill1.positive(x));
                }
            }

            PSSession search2 = _session.makeCopy();
            search2.searchSkills.set_all(skill2);
            _conflictMatcher = new DecorationMatcherFull(search2);
        }else {
            _existRelation = null;
        }

        if (useFixed) {
            TreeSet<PSItem> matome = new TreeSet<PSItem>(new DecorationMatcherFixed.DecosComparator());

            createMatomeDeco(matome, 1, Repository.getBaseItems().listDecoration);
            createMatomeDeco(matome, 2, Repository.getBaseItems().listDecoration);
            createMatomeDeco(matome, 3, Repository.getBaseItems().listDecoration);

            ArrayList<PSItem> matomeDeco = new ArrayList<PSItem>(matome);
            _listDecoMatome = new ArrayList<PSItem>();
            Iterator<PSItem> it = matomeDeco.iterator();
            while (it.hasNext()) {
                PSItem item = it.next();
                item.name = item.skills.toString();
                for (int i = 0; i < matomeDeco.size(); ++ i) {
                    PSItem item2 = matomeDeco.get(i);

                    if (item == item2) {
                        continue;
                    }

                    if (item.slotCount == item2.slotCount) {
                        if (item2.skills.isOver(item.skills)) {
                            it.remove();
                            break;
                        }
                    }
                }
            }

            _listDecoMatome.addAll(matome);
        }
    }
    
    public void createMatomeDeco(TreeSet<PSItem> matomeDeco, int slotCount, ArrayList<PSItem> listDeco) {
        PSItem dummy1 = new PSItem(PSItemType.TYPE_DECORATION, "dummy1");
        dummy1.skills = new SkillSet().fixColumnBy(_targetSkills);
        dummy1.slotCount = slotCount;

        catDeco(matomeDeco, slotCount, dummy1, listDeco);
    }

    public void catDeco(TreeSet<PSItem> matomeDeco, int maxSlotCount, PSItem dummy, List<PSItem> listDeco) {
        if (maxSlotCount <= 0) {
            matomeDeco.add(dummy);
            return;
        }
        for(int i = 0; i < listDeco.size(); ++ i) {
            PSItem deco = listDeco.get(i);
            if (decoIsForSkillKind(deco, _targetSkills)) {                
                if (maxSlotCount >= deco.slotCount) {
                    SkillSet skills = new SkillSet().fixColumnBy(_targetSkills);
                    skills.add_only(dummy.skills);
                    skills.add_only(deco.skills);
                    skills = skills.fixColumnBy(_targetSkills);
                    PSItem next = new PSItem(PSItemType.TYPE_DECORATION, skills.toString());
                    next.slotCount = dummy.slotCount;
                    next.skills = skills;
                    catDeco(matomeDeco, maxSlotCount - deco.slotCount, next, listDeco);
                }
            }
        }
    }
   
    public static class DecosComparator implements Comparator<PSItem> {
        @Override
        public int compare(PSItem t1, PSItem t2) {
            if (t1.slotCount < t2.slotCount) return -1;
            if (t1.slotCount > t2.slotCount) return  1;
            return t1.skills.compareTo(t2.skills);
        }
    }
 
    HashMap<SkillKind, Double[]> weight = new HashMap<SkillKind, Double[]>();

    public double getDecorationWeight(SkillKind kind, boolean range, int slotMax) {
        Double[] x = this.weight.get(kind);
        if (x == null) {
            x = new Double[5];
            for (int width = 0; width <= 3; width++) {
                double savedWeight = 10;
                for (int i = 0; i < _listDeco.size(); ++i) {
                    SkillSet skills = _listDeco.get(i).skills;
                    int n = skills.indexOfKind(kind);
                    if (n < 0) {
                        continue;
                    }
                    if (_listDeco.get(i).slotCount > width) {
                        continue;
                    }
                    int point = skills.point(n);
                    if (!range) {
                        point = -point;
                    }
                    if (point >= 1) {
                        double weight = (double) point;
                        weight = _listDeco.get(i).slotCount / weight;

                        if (weight < savedWeight) {
                            savedWeight = weight;
                        }
                    }
                }
                x[width] = savedWeight;
            }
            weight.put(kind, x);
        }
        return x[slotMax];
    }

    public static class RelationKey {

        public RelationKey() {
        }

        public void set(SkillSet diffSkills) {
            if (key == null || key.length != diffSkills.size()) {
                key = new boolean[diffSkills.size()];
            }
            StringBuilder str = new StringBuilder();
            hashCode = 0;
            for (int i = 0; i < diffSkills.size(); ++i) {
                hashCode <<= 1;
                key[i] = false;
                SkillKind kind = diffSkills.kind(i);
                boolean range = diffSkills.positive(i);
                int point = diffSkills.point(i);
                if (range && point <= 0) {
                    continue;
                }
                if (!range && point >= 0) {
                    continue;
                }
                key[i] = true;
                hashCode += 1;
            }
        }

        public RelationKey makeCopy() {
            RelationKey another = new RelationKey();
            another.key = new boolean[key.length];
            another.hashCode = hashCode;
            for (int i = 0; i < key.length; ++i) {
                another.key[i] = key[i];
            }
            return another;
        }
        boolean[] key;
        int hashCode;

        @Override
        public int hashCode() {
            return hashCode;
        }

        @Override
        public boolean equals(Object t) {
            RelationKey target = (RelationKey) t;
            if (hashCode != target.hashCode) {
                return false;
            }
            if (key.length != target.key.length) {
                return false;
            }
            for (int i = 0; i < key.length; ++i) {
                if (key[i] != target.key[i]) {
                    return false;
                }
            }
            return true;
        }
    }
    HashMap<RelationKey, int[]> relationCache = new HashMap<RelationKey, int[]>();
    RelationKey pool1 = new RelationKey();

    public int[] getPlusRelationCached(SkillSet diffSkills) {
        pool1.set(diffSkills);

        if (relationCache.containsKey(pool1)) {
            return relationCache.get(pool1);
        }

        int[] ret = getPlusRelation(diffSkills);
        relationCache.put(pool1.makeCopy(), ret);
        return ret;
    }

    public int[] getPlusRelation(SkillSet diffSkills) {
        int[] relation = new int[diffSkills.size()];
        boolean found = false;
        int counter = 1;
        for (int i = 0; i < relation.length; ++i) {
            relation[i] = 0;
        }
        for (int i = 0; i < diffSkills.size(); ++i) {
            SkillKind kind = diffSkills.kind(i);
            boolean range = diffSkills.positive(i);
            int point = diffSkills.point(i);
            if (range && point <= 0) {
                continue;
            }
            if (!range && point >= 0) {
                continue;
            }
            for (int k = 0; k < _listDeco.size(); ++k) {
                PSItem deco = _listDeco.get(k);
                int x = deco.skills.indexOfKind(kind);
                if (x < 0) {
                    continue;
                }
                int decoPoint = deco.skills.point(x);
                if (range && decoPoint <= 0) {
                    continue;
                }
                if (!range && decoPoint >= 0) {
                    continue;
                }
                //now, found decoration
                //check another plus
                SkillKind anotherDecoSkill = deco.skills.kind(1 - x);
                int anotherDecoPoint = deco.skills.point(1 - x);

                for (int j = 0; j < diffSkills.size(); ++j) {
                    if (i == j) {
                        continue;
                    }
                    SkillKind kind2 = diffSkills.kind(j);
                    if (kind2 != anotherDecoSkill) {
                        continue;
                    }
                    boolean range2 = diffSkills.positive(j);
                    int point2 = diffSkills.point(j);
                    if (range2 && point2 <= 0) {
                        continue;
                    }
                    if (!range2 && point2 >= 0) {
                        continue;
                    }
                    if (range2 && anotherDecoPoint <= 0) {
                        continue;
                    }
                    if (!range2 && anotherDecoPoint >= 0) {
                        continue;
                    }
                    //now, found another plus
                    found = true;
                    if (relation[i] >= 1) {
                        if (relation[i] == relation[j]) {
                            continue;
                        } else if (relation[j] >= 1) {
                            int org = relation[j];
                            for (int m = 0; m < relation.length; ++m) {
                                if (relation[m] == org) {
                                    relation[m] = relation[i];
                                }
                            }
                        } else {
                            relation[j] = relation[i];
                        }
                    } else if (relation[j] >= 1) {
                        if (relation[i] == relation[j]) {
                            continue;
                        } else if (relation[i] >= 1) {
                            int org = relation[i];
                            for (int m = 0; m < relation.length; ++m) {
                                if (relation[m] == org) {
                                    relation[m] = relation[j];
                                }
                            }
                        } else {
                            relation[i] = relation[j];
                        }
                    } else {
                        relation[i] = counter;
                        relation[j] = counter;
                        counter++;
                    }
                }
            }
        }
        if (found) {
            return relation;
        }
        return null;
    }
    int[] step_cache = null;

    public int getNeedSlotCount(DecorationSlot slot) {
        int width = slot.getSlotMaxCount();
        int width2 = slot.getBodyAvailable();
        if (width2 > width) {
            width = width2;
        }
        if (step_cache == null || step_cache.length != slot.diffSkills.size()) {
            step_cache = new int[slot.diffSkills.size()];
        }
        int[] stepCount = step_cache;
        for (int i = 0; i < stepCount.length; ++i) {
            stepCount[i] = 0;
        }
        int needSlotCount = 0;
        for (int i = 0; i < slot.diffSkills.size(); ++i) {
            SkillKind kind = slot.diffSkills.kind(i);
            boolean range = slot.diffSkills.positive(i);
            int point = slot.diffSkills.point(i);
            if (!range) {
                point = -point;
            }
            if (point >= 1) {
                double weight = getDecorationWeight(kind, range, width);
                stepCount[i] = (int) Math.ceil(weight * point - 0.1);
            }
        }

        needSlotCount = 0;
        for (int i = 0; i < slot.diffSkills.size(); ++i) {
            needSlotCount += stepCount[i];
        }

        if (needSlotCount == 0) {
            return 0;
        }
        //another have minus
        //-> nothing

        //another have plus
        //-> only_max(that, another)
        if (_existRelation != null) {
            int[] relation = getPlusRelationCached(slot.diffSkills);
            if (relation != null) {
                int[] sumPositive = new int[slot.diffSkills.size()];
                int[] sumNegative = new int[slot.diffSkills.size()];
                for (int x = 0; x < relation.length; ++x) {
                    int pos = relation[x];

                    if (pos == 0 || slot.diffSkills.positive(x)) {
                        sumPositive[pos] += stepCount[x];
                    } else {
                        sumNegative[pos] += stepCount[x];
                    }
                }
                needSlotCount = 0;
                for (int i = 0; i < sumPositive.length; ++i) {
                    if (i == 0) {
                        needSlotCount += sumPositive[i] + sumNegative[i];
                    } else if (sumPositive[i] > sumNegative[i]) {
                        needSlotCount += sumPositive[i];
                    } else {
                        needSlotCount += sumNegative[i];
                    }
                }
                return needSlotCount;
            } else {
                return needSlotCount;
            }
        } else {
            return needSlotCount;
        }
    }
    //TreeSet<DecorationSlot> queue = new TreeSet<DecorationSlot>();
    SkillSet cache1 = new SkillSet();
    static int maxQueue = 0;
    
    class QueueComparator implements Comparator {
        boolean _fullScan = false;
        
        public QueueComparator(boolean fullScan) {
            _fullScan = fullScan;
        }

        @Override
        public int compare(Object t, Object t1) {
            DecorationSlot slot1 = (DecorationSlot)t;
            DecorationSlot slot2 = (DecorationSlot)t1;
            
            for (int i = 0; i < slot1.slotAvail.length; ++ i) {
                int x = slot1.slotAvail[i] - slot2.slotAvail[i];
                if (x < 0) return -1;
                if (x > 0) return +1;
            }
            
            for (int i = 0; i < slot1.diffSkills.size; ++ i) {
                int x = slot1.diffSkills.listPoint[i] - slot2.diffSkills.listPoint[i];
                if (x < 0) return -1;
                if (x > 0) return +1;
            }

            if (_fullScan) {
                for (int i = 0; i < slot1.listDeco.size(); ++ i) {
                    int x = slot1.mapDecoration.count(i) - slot1.mapDecoration.count(i);
                    if (x < 0) return -1;
                    if (x > 0) return +1;

                    x = slot1.mapBodyDecoration.count(i) - slot1.mapBodyDecoration.count(i);
                    if (x < 0) return -1;
                    if (x > 0) return +1;
                }
            }
            
            return 0;
        }
    }

    public boolean canHaveEnoughDecoration(PSArmorSet set, boolean fullScan, List<DecorationSlot> result) {
        int cntCheck = 0, cntSkip = 0;
        
        if (_useAnotherCheck) {
            _existAnotherSlot = false;
            _existAnotherSkill = false;
        }

        if (_conflictMatcher != null) {
            if (_conflictMatcher.canHaveEnoughDecoration(set, fullScan, null) == false) {
                return false;
            }
        }

        boolean isCached = false;

        TreeSet<DecorationSlot> queue = new TreeSet<DecorationSlot>(new QueueComparator(fullScan));
        HashSet<DecorationSlot> already = new HashSet<DecorationSlot>();

        boolean found = false;

        set.calculateUseList(_targetSkills);

        SkillSet masked = set.setSkills;
        SkillSet diffSkill = cache1;
        diffSkill.set_all(_session.searchSkills);
        diffSkill.minus_fixed(masked);

        DecorationSlot slot;
        if (useFixed) {
            slot = new DecorationSlot(_listDecoMatome);
        }else {
            slot = new DecorationSlot(_listDeco);
        }
        int slotCount = set.weaponSlotCount;
        if (slotCount < 0) {
            slotCount = 0;
        }
        slot.construct(diffSkill, set, slotCount);

        int needSlotCount = getNeedSlotCount(slot);

        if (set.weaponSlotCount < 0) {
            if (needSlotCount == 0) {
                if (result != null) {
                    result.add(slot);
                }
                return true;
            } else {
                return false;
            }
        }
        if (needSlotCount > slot.totalAvailCount()) {
            return false;
        }
        if (_debug) {
            System.out.println("enter       " + set);

            System.out.println("searchSkill " + _session.searchSkills);
            System.out.println("setSkill    " + set.setSkills);
            System.out.println("diffSkill   " + slot.diffSkills);
            System.out.println("test        " + needSlotCount + " <= " + slot.totalAvailCount());
        }

        queue.add(slot);

        while (queue.isEmpty() == false) {
            slot = queue.pollLast();
            
            if (!useFixed) {
                if (already.contains(slot)) {
                    cntSkip ++;
                    continue;
                }
                cntCheck ++;
                already.add(slot);
            }
            
            //boolean hit = slot.diffSkills.totalDiffPoint() == 0;
            needSlotCount = getNeedSlotCount(slot);
            boolean hit = (needSlotCount <= 0);

            if (hit && _session.searchWithUsableStatus && _session.items != null) {
                if (checkUsableCount(slot) == false) {
                    continue;
                }
            }

            if (needSlotCount > slot.totalAvailCount()) {
                continue;
            }

            if (hit) {
                found = true;
                if (result != null) {
                    result.add(slot);
                }
                if (!fullScan) {
                    //System.out.println("check " + cntCheck + " / skip " + cntSkip);
                    return found;
                }
                continue;
            } else if (_debug) {
                System.out.println("diffSkill   " + slot.diffSkills);
                System.out.println("test        " + needSlotCount + " <= " + slot.totalAvailCount());
            }

            int bodyWidth = slot.getBodyAvailable();
            int maxWidth = slot.getSlotMaxCount();

            if (useFixed) {
                for (int i = 0; i < _listDecoMatome.size(); ++i) {
                    PSItem deco = _listDecoMatome.get(i);
                    if (decoIsForDiffSkillFixed(deco, slot.diffSkills, _quickScan && result != null)) {
                         if (bodyWidth == deco.slotCount) {
                             DecorationSlot next = slot.applyToBody(deco);
                             if (next != null) {
                                 queue.add(next);
                             }
                         }
                         if (maxWidth == deco.slotCount) {
                             DecorationSlot next = slot.applyAutoFixed(deco);
                             if (next != null) {
                                 queue.add(next);
                             }
                         }
                     }
                }
            }else {
                for (int i = 0; i < _listDeco.size(); ++i) {
                    PSItem deco = _listDeco.get(i);
                    if (decoIsForDiffSkill(deco, slot.diffSkills, _quickScan && result != null)) {
                        if (bodyWidth >= deco.slotCount) {
                            DecorationSlot next = slot.applyToBody(deco);
                            if (next != null) {
                                queue.add(next);
                            }
                        }
                        if (maxWidth >= deco.slotCount) {
                            DecorationSlot next = slot.applyAuto(deco);
                            if (next != null) {
                                queue.add(next);
                            }
                        }
                    }
                }
            }
        }
        
        /*
        if (found) {
            System.out.println("check  " + cntCheck + " / skip " + cntSkip);
        }else {
            System.out.println("check ~ " + cntCheck + " / skip " + cntSkip);
        }*/
        return found;
    }

    public boolean checkUsableCount(DecorationSlot set) {
        if (_session.items.searchUsableCount == null) {
            return true;
        }

        DecorationCount map = new DecorationCount(_listDeco);
        for (int i = 0; i < set.mapDecoration.size(); ++ i) {
            map.add(set.mapDecoration.deco(i), set.mapDecoration.count(i));
        }
        for (int i = 0; i < set.mapBodyDecoration.size(); ++ i) {
            map.add(set.mapDecoration.deco(i), set.mapDecoration.count(i));
        }
        for (int i = 0; i < map.size(); ++i) {
            PSItem item = map.deco(i);
            int count = map.count(i);

            Integer x =  _session.items.searchUsableCount.get(item);
            if (x != null && x != Integer.MAX_VALUE) {
                if (count > x) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean decoIsForDiffSkill(PSItem item, SkillSet skills, boolean quickScan) {
        for (int i = 0; i < skills.size(); ++i) {
            SkillKind kind = skills.kind(i);
            boolean range = skills.positive(i);
            int point1 = skills.point(i);

            if ((range && point1 >= 1) || (!range & point1 <= -1)) {
                int x = item.skills.indexOfKind(kind);
                if (x >= 0) {
                    if (_existRelation != null && _existRelation[i] != 0) {
                        return true;
                    }
                    int point2 = item.skills.point(x);
                    if (range) {
                        if (point2 >= 1) {
                            return true;
                        }
                    } else {
                        if (point2 <= -1) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean decoIsForDiffSkillFixed(PSItem item, SkillSet diffSkill, boolean quickScan) {
        for (int i = 0; i < diffSkill.size(); ++i) {
            SkillKind kind = diffSkill.kind(i);
            boolean range = diffSkill.positive(i);
            int point1 = diffSkill.point(i);
            
            if (range) {
                if (point1 >= 0) {
                    //safe
                    continue;
                }
            }else {
                if (point1 <= 0) {
                    //safe
                    continue;
                }
            }

            for (int x = 0; x < item.skills.size; ++ x) {
                SkillKind kind2 = item.skills.kind(x);
                boolean range2 = item.skills.positive(x);
                int point2 = item.skills.point(x);
                
                if (kind == kind2) {
                    if (range) {
                        if (point2 > 0) { 
                            return false;
                        }
                    }else {
                        if (point2 < 0) {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }
    public boolean decoIsForSkillKind(PSItem item, SkillSet skills) {
        for (int i = 0; i < skills.size(); ++i) {
            SkillKind kind = skills.kind(i);
            boolean range = skills.positive(i);
            int point1 = skills.point(i);

            int x = item.skills.indexOfKind(kind);
            if (x >= 0) {
                int point2 = item.skills.point(x);
                if (range) {
                    if (point2 >= 1) {
                        return true;
                    }
                } else {
                    if (point2 <= -1) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean existMoreSlot(List<DecorationSlot> prevResult) {
        for (DecorationSlot slot : prevResult) {
            int x = slot.totalAvailCount();
            if (x >= 1) {
                return true;
            }
        }
        return false;
    }

    public int fixRealWeaponSlot(PSArmorSet set, List<DecorationSlot> prevResult) {
        if (set.weaponSlotCount <= 0) {
            return set.weaponSlotCount;
        }

        int maxAvailable = 0;
        for (DecorationSlot slot : prevResult) {
            int x = slot.getWeaponSlotAvailable();
            if (x >= maxAvailable) {
                maxAvailable = x;
                ;
            }
        }
        return set.weaponSlotCount - maxAvailable;
    }

    public boolean isCharmHaveReplacement(PSArmorSet set, PSWrap noneItem) {
        PSWrap charm = set.listItems.get(PSItemType.TYPE_CHARM);
        boolean found = false;
        if (charm == null) {
            return false;
        }

        if (charm != noneItem) {
            set.listItems.set(PSItemType.TYPE_CHARM, noneItem);
            set.calculateUseList(_targetSkills);
            if (canHaveEnoughDecoration(set, false, null)) {
                found = true;
            }
        }

        if (!found) {
            for (PSWrap replace : charm.childArmors) {
                if (replace.item == charm.item) {
                    continue;
                }

                set.listItems.set(PSItemType.TYPE_CHARM, replace);
                set.calculateUseList(_targetSkills);
                if (canHaveEnoughDecoration(set, false, null)) {
                    found = true;
                    break;
                }
            }
        }

        set.listItems.set(PSItemType.TYPE_CHARM, charm);
        set.calculateUseList(_targetSkills);
        return found;
    }
}
