package data.data_mhp3;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import portablesimulator.PSItem;
import portablesimulator.PSItemType;
import portablesimulator.csv.GameResource;

public class MHP3Resource implements GameResource {
    private MHP3DataIO reader = new MHP3DataIO();
    private boolean monoArmor = false;

    public String nameOfGame() {
        return "MHP3";
    }

    public boolean existCharm() {
        return true;
    }

    public boolean existCharmG() {
        return false;
    }

    public void readCSV() throws IOException {
        reader.readAll();
    }

    public Color getArmorColor(PSItem item) {
        if (monoArmor) {
            return Color.black;
        }
        if (item.itemType == PSItemType.TYPE_DECORATION) {
            return Color.white;
        }
        if (item.itemType == PSItemType.TYPE_CHARM) {
            if (item.name.startsWith("")) {
                return Color.red;
            }
            if (item.name.startsWith("")) {
                return Color.green;
            }
            if (item.name.startsWith("")) {
                return Color.cyan;
            }
            if (item.name.startsWith("")) {
                return Color.pink;
            }
            if (item.name.startsWith("Rm")) {
                return Color.yellow;
            }
            if (item.name.startsWith("m")) {
                return Color.magenta;
            }
            return Color.white;
        }
        switch (item.rareRank) {
            case 1:
                return Color.white;
            case 2:
                return Color.magenta;
            case 3:
                return Color.yellow;
            case 4:
                return Color.pink;
            case 5:
                return Color.green;
            case 6:
                return Color.cyan;
            case 7:
                return Color.red;
        }
        return Color.white;
    }

    public String getConfigFile() {
        return "PSConfig.ini";
    }

    public String getMysetFile() {
        return "PSMySet.ini";
    }

    public List<PSItem> readCharmCSV(String fileName) throws IOException {
        ArrayList<PSItem> listCharm = new ArrayList<PSItem>();
        reader.readCharmCSVFile(PSItemType.TYPE_CHARM, fileName, listCharm);
        return listCharm;
    }

    public boolean existFukugo() {
        return false;
    }
}
