package portablesimulator.csv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import portablesimulator.PSArmorSet;
import portablesimulator.PSItem;
import portablesimulator.PSItemType;
import portablesimulator.PSWrap;
import portablesimulator.decoration.DecorationMatcherFull;
import portablesimulator.decoration.DecorationSlot;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillSet;

public class PSMySet {

    public List<PSArmorSet> listMyset = new ArrayList<PSArmorSet>();
    File file;

    public PSMySet(String mysetFile) {
        file = new File(mysetFile);
    }

    public void readProperties() throws IOException {
        if (file.isFile() == false) {
            return;
        }
        InputStream in = new FileInputStream(file);
        Map<String, String> properties = new LinkedHashMap<String, String>();
        try {
            InputStreamReader reader = new InputStreamReader(in);
            BufferedReader buff = new BufferedReader(reader);
            String line;
            while ((line = buff.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) == '#') {
                    continue;
                }
                int x = line.indexOf('=');
                if (x < 0) {
                    continue;
                }
                String key = line.substring(0, x);
                String value = line.substring(x + 1);
                properties.put(key, value);
            }
        } finally {
            in.close();
        }
        //parse map

        LinkedHashSet<String> prefixes = new LinkedHashSet<String>();
        for (String key : properties.keySet()) {
            if (key.startsWith("myset.")) {
                int startIndex = 6;
                int x = key.indexOf('.', startIndex);
                int num = -1;
                if (x < 0) {
                    continue;
                }

                try {
                    num = Integer.parseInt(key.substring(startIndex, x));
                } catch (Throwable e) {
                    continue;
                }
                prefixes.add("myset." + num + ".");
            }
        }
        this.listMyset.clear();
        int counter = 1;
        List<String> strCache1 = new ArrayList<String>();
        for (String prefix : prefixes) {
            try {
                String name = properties.get(prefix + "name");
                String picturePath = properties.get(prefix + "picture");
                SkillSet skill = StringToSkillSet(properties.get(prefix + "skill"));
                List<String> armorList = strCache1;
                CSVReader.bunkatu(properties.get(prefix + "armor"), ',',  strCache1);
                SkillSet charmSkill = null;
                int charmSlot = 0;

                if (Repository.getResource().existCharm()) {
                    charmSkill = StringToSkillSet(properties.get(prefix + "charmSkill"));
                    charmSlot = Integer.parseInt(properties.get(prefix + "charmSlot"));
                }

                PSArmorSet set = new PSArmorSet();
                set.mysetNumber = counter++;
                set.mysetName = name;
                set.mysetPicturePath = picturePath;
                set.targetSkills = skill;

                PSBaseItems datas = Repository.getBaseItems();

                for (int itemType = 0; itemType < armorList.size(); ++itemType) {
                    PSItem found = null;
                    if (itemType != PSItemType.TYPE_CHARM) {
                        found = PSItem.getInstanceByName(itemType, armorList.get(itemType));
                    }
                    if (found == null && itemType == PSItemType.TYPE_CHARM) {
                        found = new PSItem(PSItemType.TYPE_CHARM, armorList.get(itemType));
                        found.skills = charmSkill;
                        found.slotCount = charmSlot;
                    }
                    if (found == null) {
                        throw new Exception("not found " + armorList.get(itemType));

                    }
                    set.listItems.add(new PSWrap(found));
                }
                set.calculateUseList(null);
                try {
                    set.session.searchHunterType = Integer.parseInt(properties.get(prefix + "hunterType"));
                    set.session.searchGenderType = Integer.parseInt(properties.get(prefix + "genderType"));
                    set.session.searchHunterRank = Integer.parseInt(properties.get(prefix + "hunterRank"));
                    set.session.searchTownRank = Integer.parseInt(properties.get(prefix + "townRank"));
                    set.session.searchWeaponSlotCount = Integer.parseInt(properties.get(prefix + "weaponSlotCount"));
                    set.weaponSlotCount = set.session.searchWeaponSlotCount;
                } catch (Throwable e) {
                    fixArmorSetRank(set);
                }
                fixArmorSetVirtual(set);

                listMyset.add(set);
            } catch (Throwable e) {
                e.printStackTrace();
            }
        }


        prefixes.clear();
        for (String key : properties.keySet()) {
            if (key.startsWith("charm.")) {
                int startIndex = 6;
                int x = key.indexOf('.', startIndex);
                int num = -1;
                if (x < 0) {
                    continue;
                }

                try {
                    num = Integer.parseInt(key.substring(startIndex, x));
                } catch (Throwable e) {
                    continue;
                }
                prefixes.add("charm." + num + ".");
            }
        }
        List<PSItem> listCharm = Repository.getBaseItems().listBaseCharm;

        for (String prefix : prefixes) {
            try {
                String name = properties.get(prefix + "name");
                String skills = properties.get(prefix + "skill");
                int slotCount = Integer.parseInt(properties.get(prefix + "slotCount"));

                PSItem item = new PSItem(PSItemType.TYPE_CHARM, name);
                item.skills = StringToSkillSet(skills);
                item.slotCount = slotCount;
                if (listCharm.contains(item) == false) {
                    listCharm.add(item);
                }
            } catch (Throwable e) {
                e.printStackTrace();
            }
        }

        Collections.<PSItem>sort(listCharm);
    }

    public static void fixArmorSetRank(PSArmorSet set) {
        set.session = new PSSession();
        set.session.searchHunterType = 0;
        set.session.searchGenderType = 0;
        set.session.searchHunterRank = 0;
        set.session.searchTownRank = 0;
        set.session.searchWeaponSlotCount = 0;
        set.weaponSlotCount = set.session.searchWeaponSlotCount;

        for (int i = 0; i < set.listItems.size(); ++i) {
            PSWrap wrap = set.listItems.get(i);
            PSItem item = wrap.item;
            if (set.session.searchHunterType == 0 && item.hunterType != 0) {
                set.session.searchHunterType = item.hunterType;
            }
            if (set.session.searchGenderType == 0 && item.genderType != 0) {
                set.session.searchGenderType = item.genderType;
            }
            if (set.session.searchHunterRank < item.existHunterRank) {
                set.session.searchHunterRank = item.existHunterRank;
            }
            if (set.session.searchTownRank < item.existTownRank) {
                set.session.searchTownRank = item.existTownRank;
            }
        }

        for (int width = -1; width <= 3; ++width) {
            set.session.searchWeaponSlotCount = width;
            set.weaponSlotCount = width;
            set.session.searchSkills = set.targetSkills;
            DecorationMatcherFull matcher = new DecorationMatcherFull(set.session);
            if (matcher.canHaveEnoughDecoration(set, false, null)) {
                break;
            }
        }
    }

    public static void fixArmorSetVirtual(PSArmorSet set) {
        for (PSWrap item : set.listItems) {
            if (item.item.isVirtual && item.item.isVirtualNone == false) {
                List<PSItem> base = null;
                switch (item.item.itemType) {
                    case PSItemType.TYPE_HEAD:
                        base = Repository.getBaseItems().listEquipHead;
                        break;
                    case PSItemType.TYPE_BODY:
                        base = Repository.getBaseItems().listEquipBody;
                        break;
                    case PSItemType.TYPE_ARM:
                        base = Repository.getBaseItems().listEquipArm;
                        break;
                    case PSItemType.TYPE_WEIST:
                        base = Repository.getBaseItems().listEquipWeist;
                        break;
                    case PSItemType.TYPE_LEG:
                        base = Repository.getBaseItems().listEquipLeg;
                        break;
                }
                if (base == null) {
                    continue;
                }
                item.virtualList = new ArrayList<PSWrap>();
                for (PSItem seek : base) {
                    if (set.session.isExistForThisHunter(seek)) {
                        if (item.item.isCopieSkill) {
                            if (seek.isCopieSkill) {
                                item.virtualList.add(new PSWrap(seek));
                            }
                            continue;
                        }
                        if (set.session.isExistForSkill(seek)
                         || set.session.isExistForNegativeSkill(seek)) {
                            continue;
                        }
                        if (item.item.slotCount == seek.slotCount) {
                            item.virtualList.add(new PSWrap(seek));
                            continue;
                        }
                    }
                }
            }
        }
        set.calculateUseList(null);
    }

    public static void readMySetTXTFile(String path, List<PSArmorSet> listArmorSet) throws IOException {
        CSVReader reader = new CSVReader(path);
        try {
            ArrayList<String> line = new ArrayList<String>();
            while (reader.readLine(line)) {
                if (line.size() < 5) {
                    continue;
                }
                if (line.get(0).startsWith("#")) {
                    continue;
                }
                int x = 0;
                int genderType = Integer.parseInt(line.get(x ++));
                int hunterType = Integer.parseInt(line.get(x ++));
                int weaponSlot = Integer.parseInt(line.get(x ++));
                String setName = line.get(x++);

                String strHead = line.get(x++);
                String strBody = line.get(x++);
                String strArm  = line.get(x++);
                String strWeist = line.get(x++);
                String strLeg = line.get(x++);

                String charm = line.get(x++);
                String decorationBody = line.get(x++);
                String decoration = line.get(x++);

                PSItem itemHead  = PSItem.getInstanceByName(PSItemType.TYPE_HEAD, renameImport(strHead));
                PSItem itemBody  = PSItem.getInstanceByName(PSItemType.TYPE_BODY, renameImport(strBody));
                PSItem itemArm   = PSItem.getInstanceByName(PSItemType.TYPE_ARM, renameImport(strArm));
                PSItem itemWeist = PSItem.getInstanceByName(PSItemType.TYPE_WEIST, renameImport(strWeist));
                PSItem itemLeg   = PSItem.getInstanceByName(PSItemType.TYPE_LEG, renameImport(strLeg));

                if (itemHead == null) throw new IllegalArgumentException("Invalid Head: " + strHead);
                if (itemBody == null) throw new IllegalArgumentException("Invalid Head: " + strBody);
                if (itemArm == null) throw new IllegalArgumentException("Invalid Head: " + strArm);
                if (itemWeist == null) throw new IllegalArgumentException("Invalid Head: " + strWeist);
                if (itemLeg == null) throw new IllegalArgumentException("Invalid Head: " + strLeg);

                ArrayList<String> charmSplit = new ArrayList<String>();
                CSVReader.bunkatu(charm, ';', charmSplit);
                x = 0;
                String charmName = charmSplit.get(x ++);
                int charmSlot = 0;
                String skill1Name = "";
                String skill1Point = "";
                String skill2Name = "";
                String skill2Point = "";

                try {
                    charmSlot = Integer.parseInt(charmSplit.get(x ++));
                    skill1Name = charmSplit.get(x ++);
                    skill1Point = charmSplit.get(x ++);
                    skill2Name = charmSplit.get(x ++);
                    skill2Point = charmSplit.get(x ++);
                }catch(IndexOutOfBoundsException e) {

                }

                PSItem itemCharm = null;

                if (charmName.equals("Ȃ")) {
                    itemCharm = PSItem.getVirtualItem(PSItemType.TYPE_CHARM, PSItem.VIRTUAL_NONE);
                }else {
                    PSItem item = new PSItem(PSItemType.TYPE_CHARM, charmName);
                    item.slotCount = charmSlot;
                    item.skills = new SkillSet();
                    if (skill1Name.length() > 0) {
                        SkillKind kind = Repository.getSkillCategories().findKindByName(skill1Name);
                        int point = Integer.parseInt(skill1Point);
                        item.skills.set(kind, point, true);
                    }
                    if (skill2Name.length() > 0) {
                        SkillKind kind = Repository.getSkillCategories().findKindByName(skill2Name);
                        int point = Integer.parseInt(skill2Point);
                        item.skills.set(kind, point, true);
                    }
                    itemCharm = item;
                }

                PSArmorSet set = new PSArmorSet();
                set.listItems.add(new PSWrap(itemHead));
                set.listItems.add(new PSWrap(itemBody));
                set.listItems.add(new PSWrap(itemArm));
                set.listItems.add(new PSWrap(itemWeist));
                set.listItems.add(new PSWrap(itemLeg));
                set.listItems.add(new PSWrap(itemCharm));

                List<PSItem> decoBody = importSubDecoration(decorationBody);
                List<PSItem> decoNormal = importSubDecoration(decoration);

                DecorationSlot slot = new DecorationSlot(Repository.getBaseItems().listDecoration);
                slot.construct(new SkillSet(), set, weaponSlot);

                for(PSItem item : decoBody) {
                    slot.mapBodyDecoration.increment(item);
                }
                for(PSItem item : decoNormal) {
                    slot.mapDecoration.increment(item);
                }

                SkillSet skills = new SkillSet();

                set.calculateUseList(null);

                skills.set_all(set.setSkills);
                skills.sum_all(slot.getFullDecorationSkills());

                fixArmorSetRank(set);
                fixArmorSetVirtual(set);

                set.calculateUseList(null);

                listArmorSet.add(set);
            }
        }catch(Throwable e) {
            e.printStackTrace();
        }finally {
            reader.close();
        }
    }

    public static List<PSItem> importSubDecoration(String text) {
        ArrayList<PSItem> ret = new ArrayList<PSItem>();
        ArrayList<String> line = new ArrayList<String>();

        CSVReader.bunkatu(text, ';', line);
        for (int i = 0; i < line.size(); ++ i) {
            PSItem item = PSItem.getInstanceByName(PSItemType.TYPE_DECORATION, line.get(i));
            if (item == null) {
                throw new IllegalArgumentException("Unknow deco [" + text + "]");
            }
            ret.add(item);
        }
        
        return ret;
    }

    public static String renameImport(String equip) {
        if (equip.equals("Ȃ")) {
            return PSItem.getVirtualItem(PSItemType.TYPE_HEAD, PSItem.VIRTUAL_NONE).name;
        }
        if (equip.equals("yPXz")) {
            return PSItem.getVirtualItem(PSItemType.TYPE_HEAD, PSItem.VIRTUAL_SLOT1).name;
        }
        if (equip.equals("yQXz")) {
            return PSItem.getVirtualItem(PSItemType.TYPE_HEAD, PSItem.VIRTUAL_SLOT2).name;
        }
        if (equip.equals("yRXz")) {
            return PSItem.getVirtualItem(PSItemType.TYPE_HEAD, PSItem.VIRTUAL_SLOT3).name;
        }
        if (equip.equals("ynz")) {
            return PSItem.getVirtualItem(PSItemType.TYPE_HEAD, PSItem.VIRTUAL_COPIE).name;
        }
        return equip;
    }

    public void writeProperties() throws IOException {
        //generate map
        Map<String, String> properties = new LinkedHashMap<String, String>();
        //build map

        int number = 1;
        for (PSArmorSet set : listMyset) {
            String prefix = "myset." + number + ".";
            number++;
            String[] armorStr = new String[set.listItems.size()];
            for (int i = 0; i < set.listItems.size(); ++i) {
                armorStr[i] = set.listItems.get(i).item.name;
            }

            properties.put(prefix + "name", set.mysetName);
            properties.put(prefix + "picture", set.mysetPicturePath);

            properties.put(prefix + "hunterType", String.valueOf(set.session.searchHunterType));
            properties.put(prefix + "genderType", String.valueOf(set.session.searchGenderType));
            properties.put(prefix + "hunterRank", String.valueOf(set.session.searchHunterRank));
            properties.put(prefix + "townRank", String.valueOf(set.session.searchTownRank));
            properties.put(prefix + "weaponSlotCount", String.valueOf(set.weaponSlotCount));

            properties.put(prefix + "skill", SkillSetToString(set.targetSkills));
            properties.put(prefix + "armor", renketu(armorStr));

            if (Repository.getResource().existCharm()) {
                properties.put(prefix + "charmSkill", SkillSetToString(set.listItems.get(PSItemType.TYPE_CHARM).item.skills));
                properties.put(prefix + "charmSlot", String.valueOf(set.listItems.get(PSItemType.TYPE_CHARM).item.slotCount));
            }
        }

        number = 1;
        for (PSItem item : Repository.getBaseItems().listCharm) {
            String prefix = "charm." + number + ".";
            number++;

            properties.put(prefix + "name", item.name);
            properties.put(prefix + "skill", SkillSetToString(item.skills));
            properties.put(prefix + "slotCount", String.valueOf(item.slotCount));
        }

        //write to stream
        OutputStream out = new FileOutputStream(file);
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            BufferedWriter buff = new BufferedWriter(writer);
            for (String key : properties.keySet()) {
                String value = properties.get(key);
                buff.write(key);
                buff.write("=");
                if (value == null) {
                    value = "";
                }
                buff.write(value);
                buff.write("\n");
            }
            buff.flush();
        } finally {
            out.close();
        }
    }

    public String renketu(Collection<String> list) {
        String[] array = new String[list.size()];
        list.toArray(array);
        return renketu(array);
    }

    public String renketu(String[] values) {
        StringBuilder str = new StringBuilder();
        for (String elem : values) {
            if (str.length() != 0) {
                str.append(",");
            }
            if (elem.indexOf(',') > 0) {
                str.append('"');
                str.append(elem);
                str.append('"');
            } else {
                str.append(elem);
            }
        }
        return str.toString();
    }

    public String SkillSetToString(SkillSet set) {
        List<String> list = new ArrayList<String>();
        for (int i = 0; i < set.size(); ++i) {
            list.add(set.kind(i).name + "=" + set.point(i) + (set.positive(i) ? "+" : "-"));
        }
        return renketu(list);
    }
    List<String> cache1 = new ArrayList<String>();

    public SkillSet StringToSkillSet(String str) {
        SkillSet set = new SkillSet();
        CSVReader.bunkatu(str, ',', cache1);
        for (String value : cache1) {
            int x = value.indexOf("=");
            String kind = value.substring(0, x);
            value = value.substring(x + 1);
            boolean positiveRange = false;
            if (value.endsWith("+")) {
                positiveRange = true;
                value = value.substring(0, value.length() - 1);
            } else if (value.endsWith("-")) {
                positiveRange = false;
                value = value.substring(0, value.length() - 1);
            }
            SkillKind kindObj = Repository.getSkillCategories().findKindByName(kind);
            set.set(kindObj, Integer.valueOf(value), positiveRange);
        }
        return set;
    }
}
