package portablesimulator.csv;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillSet;

public class PSConfig {
    public int themeNumber = 0;
    public boolean themeLabelColorful = false;
    public PSSession lastSession = new PSSession();

    public String fontName = "Dialog";
    public int fontSize = 12;
    public int fontStyle = Font.PLAIN;

    File file;

    public PSConfig(String configFile) {
        this.file = new File(configFile);
    }

    public void readProperties() throws IOException {
        if (file.isFile() == false) {
            return;
        }
        InputStream in = new FileInputStream(file);
        Map<String, String> properties = new LinkedHashMap<String, String>();
        try {
            InputStreamReader reader = new InputStreamReader(in);
            BufferedReader buff = new BufferedReader(reader);
            String line;
            while ((line = buff.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) == '#') {
                    continue;
                }
                int x = line.indexOf('=');
                if (x < 0) {
                    continue;
                }
                String key = line.substring(0, x);
                String value = line.substring(x + 1);
                properties.put(key, value);
            }
        } finally {
            in.close();
        }
        //parse map
        try {
            themeNumber = Integer.parseInt(properties.get("themeNumber"));
        }catch(Throwable e) {
            e.printStackTrace();;
        }
        try {
            fontName = properties.get("fontName");
        }catch(Throwable e) {
            e.printStackTrace();;
        }
        try {
            fontStyle = Integer.parseInt(properties.get("fontStyle"));
        }catch(Throwable e) {
            e.printStackTrace();;
        }
        try {
            fontSize = Integer.parseInt(properties.get("fontSize"));
        }catch(Throwable e) {
            e.printStackTrace();;
        }
        try {
            lastSession.searchHunterRank = Integer.parseInt(properties.get("searchHunterRank"));
        } catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            lastSession.searchTownRank = Integer.parseInt(properties.get("searchTownRank"));
        } catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            lastSession.searchGenderType = Integer.parseInt(properties.get("searchGenderType"));
        } catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            lastSession.searchHunterType = Integer.parseInt(properties.get("searchHunterType"));
        } catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            lastSession.searchWeaponSlotCount = Integer.parseInt(properties.get("searchWeaponSlotCount"));
        } catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            lastSession.searchMaxCount = Long.parseLong(properties.get("searchMaxCount"));
        } catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            lastSession.searchSkills = StringToSkillSet(properties.get("searchSkills"));
        } catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            lastSession.searchMatome = Boolean.parseBoolean(properties.get("searchMatome"));
        } catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            lastSession.searchPlusOneFast = Boolean.parseBoolean(properties.get("searchPlusOneFast"));
        } catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            lastSession.searchFukugo = Boolean.parseBoolean(properties.get("searchFukugo"));
        } catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            lastSession.searchPlusAlpha = Boolean.parseBoolean(properties.get("searchPlusAlpha"));
        } catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            lastSession.searchCharmCSVLevel = Integer.parseInt(properties.get("searchCharmCSVLevel"));
        } catch(Throwable e) {
            e.printStackTrace();
        }
        try {
            lastSession.searchCharmMatome = Boolean.parseBoolean(properties.get("searchCharmMatome"));
        } catch(Throwable e) {
            e.printStackTrace();
        }
        try {
            lastSession.searchOrderByDeffence = Boolean.parseBoolean(properties.get("searchOrderByDeffence"));
        } catch(Throwable e) {
            e.printStackTrace();
        }
        List<String> str = new ArrayList<String>();
        for (int i = 0; i < 8; ++i) {
            String key = "candidateUnchecked." + i;
            lastSession.items.candidateUnchecked[i].clear();
            String value = properties.get(key);
            if (value != null) {
                CSVReader.bunkatu(value, ',', str);
                lastSession.items.candidateUnchecked[i].addAll(str);
            }
        }
        for (int i = 0; i < 8; ++i) {
            String key = "viewUnchecked." + i;
            lastSession.items.viewUnchecked[i].clear();
            String value = properties.get(key);
            if (value != null) {
                CSVReader.bunkatu(value, ',', str);
                lastSession.items.viewUnchecked[i].addAll(str);
            }
        }
    }

    public void writeProperties() throws IOException {
        //generate map
        Map<String, String> properties = new LinkedHashMap<String, String>();
        //build map
        properties.put("themeNumber", Integer.toString(themeNumber));
        properties.put("fontName", fontName);
        properties.put("fontStyle", Integer.toString(fontStyle));
        properties.put("fontSize", Integer.toString(fontSize));
        properties.put("searchHunterRank", Integer.toString(lastSession.searchHunterRank));
        properties.put("searchTownRank", Integer.toString(lastSession.searchTownRank));
        properties.put("searchGenderType", Integer.toString(lastSession.searchGenderType));
        properties.put("searchHunterType", Integer.toString(lastSession.searchHunterType));
        properties.put("searchWeaponSlotCount", Integer.toString(lastSession.searchWeaponSlotCount));
        properties.put("searchSkills", SkillSetToString(lastSession.searchSkills));
        properties.put("searchMaxCount", Long.toString(lastSession.searchMaxCount));
        properties.put("searchMatome", Boolean.toString(lastSession.searchMatome));
        properties.put("searchFukugo", Boolean.toString(lastSession.searchFukugo));
        properties.put("searchPlusFast", Boolean.toString(lastSession.searchPlusOneFast));
        properties.put("searchPlusAlpha", Boolean.toString(lastSession.searchPlusAlpha));
        properties.put("searchCharmCSVLevel", Integer.toString(lastSession.searchCharmCSVLevel));
        properties.put("searchCharmMatome", Boolean.toString(lastSession.searchCharmMatome));
        properties.put("searchOrderByDeffence", Boolean.toString(lastSession.searchOrderByDeffence));

        for (int i = 0; i < 8; ++i) {
            String key = "candidateUnchecked." + i;
            String value = renketu(lastSession.items.candidateUnchecked[i]);
            properties.put(key, value);
        }
        for (int i = 0; i < 8; ++i) {
            String key = "viewUnchecked." + i;
            String value = renketu(lastSession.items.viewUnchecked[i]);
            properties.put(key, value);
        }

        //write to stream
        OutputStream out = new FileOutputStream(file);
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            BufferedWriter buff = new BufferedWriter(writer);
            for (String key : properties.keySet()) {
                String value = properties.get(key);
                buff.write(key);
                buff.write("=");
                if (value == null) {
                    value = "";
                }
                buff.write(value);
                buff.write("\n");
            }
            buff.flush();
        } finally {
            out.close();
        }
    }

    public String renketu(Collection<String> list) {
        String[] array = new String[list.size()];
        list.toArray(array);
        return renketu(array);
    }

    public String renketu(String[] values) {
        StringBuilder str = new StringBuilder();
        for (String elem : values) {
            if (str.length() != 0) {
                str.append(",");
            }
            if (elem.indexOf(',') > 0) {
                str.append('"');
                str.append(elem);
                str.append('"');
            }else {
                str.append(elem);
            }
        }
        return str.toString();
    }

    public String SkillSetToString(SkillSet set) {
        List<String> list = new ArrayList<String>();
        for (int i = 0; i < set.size(); ++ i) {
            list.add(set.kind(i).name + "=" + set.point(i) + (set.positive(i) ? "+" : "-"));
        }
        return renketu(list);
    }

    List<String> cache1 = new ArrayList<String>();

    public SkillSet StringToSkillSet(String str) {
        SkillSet set = new SkillSet();
        CSVReader.bunkatu(str, ',', cache1);
        for(String value : cache1) {
            int x = value.indexOf("=");
            String kind = value.substring(0, x);
            value = value.substring(x + 1);
            boolean positiveRange = false;
            if (value.endsWith("+")) {
                positiveRange = true;
                value = value.substring(0, value.length() - 1);
            }else if (value.endsWith("-")) {
                positiveRange = false;
                value = value.substring(0, value.length() - 1);
            }
            SkillKind kindObj = Repository.getSkillCategories().findKindByName(kind);
            set.set(kindObj, Integer.valueOf(value), positiveRange);
        }
        return set;
    }
}
