package portablesimulator.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class CSVReader {
    BufferedReader input;

    public CSVReader(String path) throws IOException {
        InputStream fin = null;
        try {
            File file = new File(path);
            if (file.isFile()) {
                fin = new FileInputStream(path);
            }else {
                fin = CSVReader.class.getResourceAsStream(path);
                if (fin == null) {
                    throw new IOException("Read Error " + file);
                }
            }
            Reader sin = new InputStreamReader(fin, "Windows-31J");
            input = new BufferedReader(sin);
        }finally {
            if (input == null && fin != null) {
                fin.close();
            }
        }
    }

    public CSVReader(Reader in) throws IOException {
        input = null;
        input = new BufferedReader(in);
    }

    public CSVReader(InputStream in) throws IOException {
        Reader sin = null;
        input = null;
        try {
            sin = new InputStreamReader(in, "Windows-31J");
            input = new BufferedReader(sin);
        }finally {
            if (input == null && sin != null) {
                try {
                    sin.close();
                }catch(IOException e) {
                }
            }
        }
    }

    public static void bunkatu(String line, char ch, List<String> result) {
        int fromIndex = 0;
        int x;
        int dx;

        result.clear();

        while(fromIndex < line.length()) {
            if (line.charAt(fromIndex) == '"') {
                x = line.indexOf('"', fromIndex + 1);
                if (x >= 0) x ++;
            }else {
                x = line.indexOf(ch, fromIndex);
            }
            if (x < 0) {
                x = line.length();
            }
            String str = line.substring(fromIndex, x);
            if (str.startsWith("\"")) {
                str = str.substring(1, str.length());
                if (str.endsWith("\"")) {
                    str = str.substring(0, str.length() - 1);
                }
            }
            result.add(str);
            fromIndex = x + 1;
        }
    }

    public boolean readLine(List<String> result) throws IOException {
        if (input == null) {
            return false;
        }
        String str = input.readLine();
        if (str == null) {
            close();
            return false;
        }
        if (str.startsWith("#")) {
            return readLine(result);
        }

        bunkatu(str, ',', result);

        return true;
    }

    public void close() {
        if (input != null) {
            try {
                input.close();
            }catch(IOException e) {

            }
            input = null;
        }
    }
}
