package portablesimulator;

import java.util.ArrayList;
import java.util.List;

public class MatrixBuilder implements IMatrixBuilder {

    ArrayList<ArrayList> listColumn;
    int[] counter;
    boolean endOfMatrix = false;

    public MatrixBuilder() {
        listColumn = new ArrayList<ArrayList>();
    }

    public void addColumn(ArrayList column) {
        listColumn.add(column);
        //System.out.println("addColumn@matrixbuilder " + column.size() +" == " + this.iteratorCount() + "---" + column);
    }

    public long iteratorCount() {
        long x = 1;
        for (int i = 0; i < listColumn.size(); ++i) {
            x *= listColumn.get(i).size() == 0 ? 1 : listColumn.get(i).size();
        }
        return x;
    }

    public long skipCount() {
        return 0;
    }

    public void start() {
        this.counter = new int[listColumn.size()];
    }

    public boolean next(ArrayList result) {
        if (endOfMatrix) {
            return false;
        }
        result.clear();
        for (int i = 0; i < counter.length; ++i) {
            result.add(listColumn.get(i).get(counter[i]));
        }
        increment();
        return true;
    }

    public boolean increment() {
        int x = 0;
        counter[x]++;
        while (counter[x] >= listColumn.get(x).size()) {
            if (x + 1 >= counter.length) {
                endOfMatrix = true;
                return false;
            }
            counter[x] = 0;
            x++;
            counter[x]++;
        }
        return true;
    }
}
