/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.decoration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import portablesimulator.PSArmorSet;
import portablesimulator.csv.PSSearchItems;
import portablesimulator.csv.PSSession;
import portablesimulator.csv.Repository;
import portablesimulator.decoration.DecorationMatcherFixed;
import portablesimulator.decoration.DecorationSlot;
import portablesimulator.gui.progress.IProgress;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillPoint;
import portablesimulator.skillset.SkillSet;

public class PlusOneFinder {
    private final PSSession session;
    private final SkillSet searchSkill;
    private final TreeSet<SkillSet> listSearchSkills;
    private final PSSearchItems items;
    private final Map<SkillSet, DecorationMatcherFixed> matcherCache;
    private final Map<SkillSet, Set<PSArmorSet>> matchedResult;
    private final TreeMap<PSArmorSet, Boolean> baseScanned;
    private final List<SkillPoint> seekList;
    public static final TreeSet<PSArmorSet> CONFLICT = new TreeSet();
    public static final TreeSet<PSArmorSet> NOTHING = new TreeSet();
    public boolean useNestedFind = false;
    public boolean wasTimeout = false;
    public boolean onlySkillScan = false;
    public boolean debug = false;

    public PlusOneFinder(PSSession session, SkillSet skills, PSSearchItems items) {
        this.session = session;
        this.searchSkill = skills;
        this.listSearchSkills = Repository.getFukugo().searchFilter(session, skills);
        this.items = items;
        this.matcherCache = new TreeMap<SkillSet, DecorationMatcherFixed>();
        this.matchedResult = new TreeMap<SkillSet, Set<PSArmorSet>>();
        this.seekList = new ArrayList<SkillPoint>();
        this.baseScanned = new TreeMap();
        ArrayList<SkillPoint> listSkills = Repository.getSkillCategories().listPoints();
        for (SkillPoint p : listSkills) {
            if (p.skillPoint <= 0) continue;
            this.seekList.add(p);
        }
    }

    public void addToResult(PSArmorSet set, SkillSet skills) {
        Set<PSArmorSet> pool = this.matchedResult.get(skills);
        if (this.onlySkillScan) {
            if (pool != NOTHING) {
                this.matchedResult.put(skills, NOTHING);
            }
            return;
        }
        if (pool == null) {
            pool = new TreeSet<PSArmorSet>();
            this.matchedResult.put(skills, pool);
        }
        pool.add(set);
    }

    public Set<SkillSet> quickFindPlusSkills(PSArmorSet set, SkillSet searchSkills, List<DecorationSlot> prevResult) {
        SkillSet searchMasked = searchSkills.getNamedSkillSetForDisplay();
        TreeSet<SkillSet> ret = new TreeSet<SkillSet>();
        block0: for (DecorationSlot slot : prevResult) {
            set.calculateUseList(null);
            SkillSet skills = set.setSkills;
            skills.sum_all(slot.getFullDecorationSkills());
            skills = skills.getNamedSkillSetForDisplay();
            for (int i = 0; i < skills.size(); ++i) {
                int point2;
                SkillKind kind = skills.kind(i);
                int point1 = skills.point(i);
                if (point1 == (point2 = searchMasked.pointOfKind(kind))) continue;
                ret.add(skills);
                continue block0;
            }
        }
        if (ret.isEmpty()) {
            return null;
        }
        boolean existToPositive = false;
        for (int i = 0; i < searchSkills.size(); ++i) {
            int p = searchSkills.point(i);
            if (p >= 0 || !searchSkills.positive(i) || p % 5 == 0) continue;
            existToPositive = true;
        }
        if (existToPositive) {
            TreeSet<SkillSet> tempSet = new TreeSet<SkillSet>();
            for (SkillSet skill2 : ret) {
                SkillSet skill3 = new SkillSet();
                skill3.set_all(skill2);
                for (int i = 0; i < searchSkills.size(); ++i) {
                    int p = searchSkills.point(i);
                    if (p >= 0 || !searchSkills.positive(i) || p % 5 == 0 || skill3.indexOfKind(searchSkills.kind(i)) >= 0) continue;
                    skill3.set(searchSkills.kind(i), p, true);
                }
                tempSet.add(skill3);
            }
            ret = tempSet;
        }
        return ret;
    }

    private DecorationMatcherFixed getMatcher(SkillSet skills) {
        DecorationMatcherFixed matcher = this.matcherCache.get(skills);
        if (matcher == null) {
            PSSession search2 = this.session.makeCopy();
            search2.searchSkills = skills;
            matcher = new DecorationMatcherFixed(search2);
            this.matcherCache.put(skills, matcher);
            if (this.useNestedFind && this.matcherCache.size() >= 500) {
                this.matcherCache.clear();
            }
        }
        return matcher;
    }

    private PSArmorSet findPlusOne(PSArmorSet set, SkillSet skills, List<DecorationSlot> result, boolean isBase) {
        DecorationMatcherFixed matcher = this.getMatcher(skills);
        boolean check = false;
        ArrayList<DecorationSlot> tempList = new ArrayList<DecorationSlot>();
        if (matcher.canHaveEnoughDecoration(set, true, tempList)) {
            Set<SkillSet> plusSet;
            if (result != null) {
                result.addAll(tempList);
            }
            if ((plusSet = this.quickFindPlusSkills(set, skills, tempList)) == null) {
                this.addToResult(set, skills);
            } else {
                for (SkillSet skill2 : plusSet) {
                    this.addToResult(set, skill2);
                }
            }
            return set;
        }
        if (check) {
            // empty if block
        }
        return null;
    }

    public boolean findAnyPlusOne(PSArmorSet set, List<DecorationSlot> result, long timeout, List<DecorationSlot> prevResult, IProgress progress) {
        boolean match = false;
        this.wasTimeout = false;
        long startTick = System.currentTimeMillis();
        Boolean x = this.baseScanned.get(set);
        if (x != null) {
            return x;
        }
        ArrayList<SkillSet> queue = new ArrayList<SkillSet>();
        HashSet<SkillSet> passed0 = new HashSet<SkillSet>();
        HashSet<SkillSet> already = new HashSet<SkillSet>();
        queue.addAll(this.listSearchSkills);
        block0: while (!(queue.isEmpty() || progress != null && progress.isCanceled())) {
            Set<SkillSet> quick;
            if (timeout > 0L && System.currentTimeMillis() >= startTick + timeout) {
                this.wasTimeout = true;
                break;
            }
            SkillSet baseSkill = (SkillSet)queue.remove(queue.size() - 1);
            if (passed0.contains(baseSkill)) continue;
            passed0.add(baseSkill);
            DecorationMatcherFixed matcher = this.getMatcher(baseSkill);
            if (prevResult == null) {
                ArrayList<DecorationSlot> tempList = new ArrayList<DecorationSlot>();
                if (matcher.canHaveEnoughDecoration(set, true, tempList)) {
                    prevResult = tempList;
                } else {
                    if (!this.onlySkillScan) continue;
                    continue;
                }
            }
            if ((quick = this.quickFindPlusSkills(set, baseSkill, prevResult)) != null) {
                for (SkillSet skill2 : quick) {
                    this.addToResult(set, skill2);
                    if (!this.onlySkillScan || !this.useNestedFind) {
                        queue.add(skill2);
                    }
                    match = true;
                }
            } else if (!DecorationMatcherFixed.existMoreSlot(prevResult)) {
                if (!this.onlySkillScan) continue;
                continue;
            }
            for (SkillPoint seek : this.seekList) {
                int sx = baseSkill.indexOfKind(seek.skillKind);
                if (sx >= 0 && (baseSkill.positive(sx) ? baseSkill.point(sx) >= seek.skillPoint : baseSkill.point(sx) <= seek.skillPoint)) continue;
                SkillSet skills = new SkillSet();
                skills.set_all(baseSkill);
                skills.set(seek.skillKind, seek.skillPoint, seek.positiveRange);
                if (already.contains(skills)) continue;
                already.add(skills);
                if (this.onlySkillScan && this.matchedResult.containsKey(skills) || this.findPlusOne(set, skills, result, false) == null) continue;
                match = true;
                if (this.onlySkillScan) continue;
                if (!this.useNestedFind) continue block0;
                queue.add(skills);
            }
        }
        return match;
    }

    public void tryFixMinus(List<PSArmorSet> listArmorSet, List<DecorationSlot> slotList) {
        TreeSet<SkillSet> needRetest = new TreeSet<SkillSet>();
        for (SkillSet test : this.matchedResult.keySet()) {
            for (int i = 0; i < test.size(); ++i) {
                if (test.point(i) >= 0 || test.positive(i)) continue;
                SkillSet newTest = new SkillSet();
                newTest.set_all(test);
                newTest.set(test.kind(i), test.point(i) + 1, true);
                needRetest.add(newTest);
            }
        }
        ArrayList<PSArmorSet> scan = new ArrayList<PSArmorSet>();
        for (PSArmorSet set : listArmorSet) {
            if (!this.baseScanned.containsKey(set)) continue;
            scan.add(set);
        }
        for (SkillSet test : needRetest) {
            for (PSArmorSet set : scan) {
                this.findPlusOne(set, test, slotList, false);
            }
        }
    }

    public Map<SkillSet, Set<PSArmorSet>> getResultMap(List<PSArmorSet> listArmorSet) {
        TreeMap<SkillSet, Set<PSArmorSet>> result = new TreeMap<SkillSet, Set<PSArmorSet>>();
        TreeSet<PSArmorSet> scan = new TreeSet<PSArmorSet>();
        if (listArmorSet == null) {
            scan.addAll(this.baseScanned.keySet());
        } else {
            for (PSArmorSet set : listArmorSet) {
                if (!this.baseScanned.containsKey(set)) continue;
                scan.add(set);
            }
        }
        for (SkillSet skills : this.matchedResult.keySet()) {
            Set<PSArmorSet> set2;
            Set<PSArmorSet> set1;
            Set<PSArmorSet> listHit = this.matchedResult.get(skills);
            TreeSet<PSArmorSet> listFound = (TreeSet<PSArmorSet>)result.get(skills);
            if (listHit == NOTHING) {
                result.put(skills, NOTHING);
                continue;
            }
            if (listHit.size() > scan.size()) {
                set1 = listHit;
                set2 = scan;
            } else {
                set1 = scan;
                set2 = listHit;
            }
            for (PSArmorSet set : set2) {
                if (!set1.contains(set)) continue;
                if (listFound == null) {
                    listFound = new TreeSet<PSArmorSet>();
                    result.put(skills, listFound);
                }
                listFound.add(set);
            }
        }
        result.remove(this.searchSkill);
        return result;
    }

    public String getResultAsText(List<PSArmorSet> listArmorSet, boolean longFormat) {
        Map<SkillSet, Set<PSArmorSet>> map = this.getResultMap(listArmorSet);
        StringBuilder str = new StringBuilder();
        boolean firstElement = true;
        if (longFormat) {
            str.append(this.getResultAsText(listArmorSet, false));
            str.append("\n");
        }
        str.append(map.size() + " Types Found:");
        str.append("[");
        for (SkillSet skill : map.keySet()) {
            if (longFormat) {
                str.append("\n");
            } else if (firstElement) {
                firstElement = false;
            } else {
                str.append(", ");
            }
            String skillName = this.getShortFormat(skill);
            int count = map.get(skill).size();
            if (this.onlySkillScan) {
                str.append(skillName);
                continue;
            }
            str.append(skillName);
            if (longFormat) {
                for (PSArmorSet set : map.get(skill)) {
                    str.append("\n");
                    str.append(" -");
                    str.append(set);
                }
                continue;
            }
            str.append("(");
            str.append(count);
            str.append(")");
        }
        if (longFormat) {
            str.append("\n");
        }
        str.append("]");
        return str.toString();
    }

    public String getShortFormat(SkillSet skills) {
        SkillSet newSet = new SkillSet();
        SkillSet base = this.searchSkill;
        for (int i = 0; i < skills.size(); ++i) {
            int point2;
            SkillKind kind = skills.kind(i);
            int point1 = skills.point(i);
            if (point1 == (point2 = base.pointOfKind(kind))) continue;
            newSet.set(kind, point1, point1 > 0);
        }
        return newSet.getNamedSkillNameForSearch().toString();
    }

    public void trashGarbage() {
        if (this.onlySkillScan) {
            for (SkillSet skill : this.matchedResult.keySet()) {
                this.matchedResult.put(skill, NOTHING);
            }
            this.baseScanned.clear();
        }
    }
}

