/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator.decoration;

import java.util.ArrayList;
import java.util.List;
import portablesimulator.PSItem;

public class DecorationCount
implements Comparable {
    private List<PSItem> deco;
    private boolean decoIsRef;
    private int[] count;

    public int hashCode() {
        int x = 0;
        for (int i = 0; i < this.deco.size(); ++i) {
            if (this.count[i] <= 0) continue;
            x += this.deco.get(i).hashCode() * this.count[i];
        }
        return x & Integer.MAX_VALUE;
    }

    public boolean equals(Object o) {
        DecorationCount c = (DecorationCount)o;
        for (int i = 0; i < this.deco.size(); ++i) {
            PSItem d = this.deco.get(i);
            String nm = d.name;
            int sl = d.slotCount;
            int cnt = this.count[i];
            boolean hit = false;
            for (int j = 0; j < c.deco.size(); ++j) {
                PSItem e = this.deco.get(i);
                String enm = d.name;
                int esl = d.slotCount;
                int ecnt = this.count[i];
                if (nm != enm || sl != esl) continue;
                hit = true;
                if (cnt == ecnt) continue;
                return false;
            }
            if (hit || cnt <= 0) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.deco.size();
    }

    public PSItem deco(int x) {
        return this.deco.get(x);
    }

    public int count(int x) {
        return this.count[x];
    }

    public DecorationCount(List<PSItem> decorations) {
        this.deco = decorations;
        this.count = new int[decorations.size()];
        this.decoIsRef = true;
    }

    public DecorationCount makeCopy() {
        DecorationCount obj = new DecorationCount(this.deco);
        for (int i = 0; i < this.count.length; ++i) {
            obj.count[i] = this.count[i];
        }
        return obj;
    }

    public void ensure(int ensize) {
        if (ensize < 20) {
            ensize = 20;
        }
        if (this.count == null || this.count.length < ensize) {
            int[] newCount = new int[ensize];
            if (this.count != null) {
                for (int i = 0; i < this.count.length; ++i) {
                    newCount[i] = this.count[i];
                }
            }
            this.count = newCount;
        }
    }

    public void increment(PSItem item) {
        for (int x = 0; x < this.deco.size(); ++x) {
            PSItem item2 = this.deco.get(x);
            if (item != item2) continue;
            int n = x;
            this.count[n] = this.count[n] + 1;
            return;
        }
        throw new Error("error");
    }

    public void add(PSItem item, int n) {
        for (int x = 0; x < this.deco.size(); ++x) {
            PSItem item2 = this.deco.get(x);
            if (item != item2) continue;
            int n2 = x;
            this.count[n2] = this.count[n2] + n;
            return;
        }
        throw new Error("error");
    }

    public void set(PSItem e, int x) {
        for (int i = 0; i < this.deco.size(); ++i) {
            if (this.deco.get(i) != e) continue;
            this.count[i] = x;
            return;
        }
        if (this.decoIsRef) {
            this.decoIsRef = false;
            this.deco = new ArrayList<PSItem>(this.deco);
        }
        this.deco.add(e);
        this.ensure(this.deco.size());
        this.count[this.deco.size() - 1] = x;
    }

    public void putAll(DecorationCount set) {
        this.ensure(set.deco.size());
        this.deco = set.deco;
        this.decoIsRef = true;
        for (int i = 0; i < set.deco.size(); ++i) {
            this.count[i] = set.count[i];
        }
    }

    public void addAll(DecorationCount set) {
        for (int i = 0; i < set.deco.size(); ++i) {
            PSItem e = set.deco.get(i);
            int n = set.count[i];
            boolean found = false;
            for (int x = 0; x < this.deco.size(); ++x) {
                if (this.deco.get(x) != e) continue;
                int n2 = x;
                this.count[n2] = this.count[n2] + n;
                found = true;
                break;
            }
            if (found) continue;
            if (this.decoIsRef) {
                this.decoIsRef = false;
                this.deco = new ArrayList<PSItem>(this.deco);
            }
            this.deco.add(e);
            this.ensure(this.deco.size());
            this.count[this.deco.size() - 1] = n;
        }
    }

    public void minusAll(DecorationCount set) {
        for (int i = 0; i < set.deco.size(); ++i) {
            PSItem e = set.deco.get(i);
            int n = set.count[i];
            boolean found = false;
            for (int x = 0; x < this.deco.size(); ++x) {
                if (this.deco.get(x) != e) continue;
                int n2 = x;
                this.count[n2] = this.count[n2] - n;
                found = true;
                break;
            }
            if (found) continue;
            if (this.decoIsRef) {
                this.decoIsRef = false;
                this.deco = new ArrayList<PSItem>(this.deco);
            }
            this.deco.add(e);
            this.ensure(this.deco.size());
            this.count[this.deco.size() - 1] = -n;
        }
    }

    public void clear() {
        for (int i = 0; i < this.count.length; ++i) {
            this.count[i] = 0;
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.deco.size(); ++i) {
            if (this.count[i] == 0) continue;
            return false;
        }
        return true;
    }

    public Integer get(PSItem e) {
        for (int i = 0; i < this.deco.size(); ++i) {
            if (this.deco.get(i) != e) continue;
            return this.count[i];
        }
        return null;
    }

    public int compareTo(Object t) {
        DecorationCount target = (DecorationCount)t;
        if (target.deco == this.deco) {
            for (int i = 0; i < this.deco.size(); ++i) {
                int x = this.count[i] - target.count[i];
                if (x < 0) {
                    return -1;
                }
                if (x <= 0) continue;
                return 1;
            }
            return 0;
        }
        DecorationCount compareItem = new DecorationCount(new ArrayList<PSItem>());
        compareItem.addAll(this);
        compareItem.minusAll(target);
        for (int i = 0; i < compareItem.deco.size(); ++i) {
            if (compareItem.count[i] < 0) {
                return -1;
            }
            if (compareItem.count[i] <= 0) continue;
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.deco.size(); ++i) {
            str.append(this.deco.get((int)i).name);
            str.append("=");
            str.append(this.count[i]);
            if (i == this.deco.size() - 1) continue;
            str.append(",");
        }
        return str.toString();
    }
}

