/*
 * Decompiled with CFR 0.152.
 */
package portablesimulator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import portablesimulator.MatrixBuilderSkilled;
import portablesimulator.PSArmorSet;
import portablesimulator.PSItem;
import portablesimulator.PSItemList;
import portablesimulator.PSWrap;
import portablesimulator.csv.PSBaseItems;
import portablesimulator.csv.PSSearchItems;
import portablesimulator.csv.PSSession;
import portablesimulator.csv.Repository;
import portablesimulator.decoration.DecorationMatcherFull;
import portablesimulator.decoration.DecorationSlot;
import portablesimulator.decoration.PlusOneFinder;
import portablesimulator.gui.PSFrame;
import portablesimulator.gui.progress.IProgress;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillPoint;
import portablesimulator.skillset.SkillSet;

public class Engine {
    public static final String VERSION = "PortableSimulator V3";
    public boolean debug = false;
    public PSSession session;
    private PSSearchItems items;
    private PSItemList listForScanAll = new PSItemList();
    public PSItemList listForCheck = new PSItemList();
    public ArrayList<PSArmorSet> listResultSearch = new ArrayList();
    public ArrayList<PSArmorSet> listResultChecked = new ArrayList();
    public PlusOneFinder plusOneFinder = null;
    public boolean useAnotherCheck = false;
    ArrayList<PSWrap> viewCountTouch = new ArrayList();

    public Engine(PSSession session, PSSearchItems items) {
        this.session = session;
        this.items = items;
    }

    public ArrayList<PSWrap> prepareScan(int itemType, ArrayList<PSItem> source) {
        ArrayList<PSWrap> dest = new ArrayList<PSWrap>(source.size() + 5);
        ArrayList<PSWrap> listSlot0 = new ArrayList<PSWrap>();
        ArrayList<PSWrap> listSlot1 = new ArrayList<PSWrap>();
        ArrayList<PSWrap> listSlot2 = new ArrayList<PSWrap>();
        ArrayList<PSWrap> listSlot3 = new ArrayList<PSWrap>();
        ArrayList<PSWrap> listCopie = new ArrayList<PSWrap>();
        for (PSItem item : source) {
            PSWrap wrap = new PSWrap(item);
            if (!this.session.isExistForThisHunter(item) || this.session.searchWithUsableStatus && !this.items.isCandidateChecked(item)) continue;
            if (itemType == 6) {
                if (!this.session.isExistForSkill(item)) continue;
                dest.add(wrap);
                continue;
            }
            if (item.isCopieSkill) {
                listCopie.add(wrap);
                continue;
            }
            if (this.session.isExistForSkill(item) || this.session.isExistForNegativeSkill(item)) {
                dest.add(wrap);
                continue;
            }
            if (item.slotCount == 0) {
                listSlot0.add(wrap);
                continue;
            }
            if (item.slotCount == 1) {
                listSlot1.add(wrap);
                continue;
            }
            if (item.slotCount == 2) {
                listSlot2.add(wrap);
                continue;
            }
            if (item.slotCount != 3) continue;
            listSlot3.add(wrap);
        }
        if (itemType != 6) {
            PSWrap item = PSWrap.getVirtualWrap(itemType, 0);
            item.virtualList = listSlot0;
            dest.add(item);
            item = PSWrap.getVirtualWrap(itemType, 1);
            item.virtualList = listSlot1;
            if (!item.virtualList.isEmpty()) {
                dest.add(item);
            } else if (itemType == 5) {
                // empty if block
            }
            item = PSWrap.getVirtualWrap(itemType, 2);
            item.virtualList = listSlot2;
            if (!item.virtualList.isEmpty()) {
                dest.add(item);
            } else if (itemType == 5) {
                // empty if block
            }
            item = PSWrap.getVirtualWrap(itemType, 3);
            item.virtualList = listSlot3;
            if (!item.virtualList.isEmpty()) {
                dest.add(item);
            } else if (itemType == 5) {
                // empty if block
            }
            item = PSWrap.getVirtualWrap(itemType, -1);
            item.virtualList = listCopie;
            if (!item.virtualList.isEmpty()) {
                dest.add(item);
            }
        }
        return dest;
    }

    public int listToChild(int itemType, SkillSet searchSkills, ArrayList<PSWrap> listTops) {
        int proceed = 0;
        for (int i = 0; i < listTops.size(); ++i) {
            PSWrap objI = listTops.get(i);
            TreeSet<PSWrap> child = new TreeSet<PSWrap>();
            if (objI.childArmors.size() > 0) continue;
            for (int j = 0; j < listTops.size(); ++j) {
                PSWrap objJ;
                if (i == j || !Engine.isTargetWeakChildren(objI, this.session.searchSkills, objJ = listTops.get(j))) continue;
                ++proceed;
                child.add(objJ);
            }
            if (child.size() <= 0) continue;
            objI.childArmors = new ArrayList(child);
            System.out.println("" + listTops.size() + " - " + child.size());
            listTops.removeAll(child);
            System.out.println(" = " + listTops.size());
            i = -1;
        }
        return proceed;
    }

    public void buildSearchTree(int itemType, ArrayList<PSWrap> source, ArrayList<PSWrap> listTops, List<PSWrap> listAll) {
        listAll.clear();
        listTops.clear();
        for (PSWrap wrap : source) {
            if (!this.session.searchMatome && wrap.virtualList != null && wrap.item.itemType != 5) {
                for (PSWrap e : wrap.virtualList) {
                    e.maskedSkills = e.item.skills.fixColumnBy(this.session.searchSkills);
                    e.childArmors = new ArrayList();
                    e.sameArmors = new ArrayList();
                    listAll.add(e);
                }
                continue;
            }
            wrap.maskedSkills = wrap.item.skills.fixColumnBy(this.session.searchSkills);
            wrap.childArmors = new ArrayList();
            wrap.sameArmors = new ArrayList();
            listAll.add(wrap);
        }
        listTops.addAll(listAll);
        for (int i = 0; i < listTops.size(); ++i) {
            PSWrap objI = listTops.get(i);
            ArrayList<PSWrap> listRemove = new ArrayList<PSWrap>();
            for (int j = i + 1; j < listTops.size(); ++j) {
                PSWrap objJ = listTops.get(j);
                if (!Engine.isTargetSameSkillsAndSlot(objI, objJ)) continue;
                listRemove.add(objJ);
            }
            if (listRemove.size() <= 0) continue;
            objI.sameArmors.addAll(listRemove);
            listTops.removeAll(listRemove);
            i = -1;
        }
        LinkedList<ArrayList<PSWrap>> queue = new LinkedList<ArrayList<PSWrap>>();
        queue.add(listTops);
        while (!queue.isEmpty()) {
            ArrayList tops = (ArrayList)queue.removeFirst();
            if (this.listToChild(itemType, this.session.searchSkills, tops) <= 0) continue;
            for (int i = 0; i < tops.size(); ++i) {
                if (((PSWrap)tops.get((int)i)).childArmors.size() < 2) continue;
                queue.add(((PSWrap)tops.get((int)i)).childArmors);
            }
        }
    }

    public List<PSWrap> loadExtraCharms() {
        ArrayList<PSWrap> dictionary = new ArrayList<PSWrap>();
        if (this.session.searchCharmCSVLevel >= 1) {
            List<PSItem> extraItem = Repository.getCharmDB().readExtraCharm(this.session.searchSkills);
            ArrayList<PSItem> prevItem = Repository.getBaseItems().listCharm;
            for (PSItem item : extraItem) {
                PSWrap wrap = new PSWrap(item);
                wrap.maskedSkills = item.skills.fixColumnBy(this.session.searchSkills);
                dictionary.add(wrap);
            }
        }
        return dictionary;
    }

    public ArrayList<PSWrap> getVirtualCharmList(List<PSWrap> listCharms, PSWrap none) {
        TreeMap<SkillSet, PSWrap> compact0 = new TreeMap<SkillSet, PSWrap>();
        TreeMap compact1 = new TreeMap();
        TreeMap compact2 = new TreeMap();
        TreeMap compact3 = new TreeMap();
        none.charmGroup = new ArrayList();
        none.charmGroupSeek = new ArrayList();
        for (PSWrap item : listCharms) {
            SkillSet masked = item.item.skills.fixColumnBy(this.session.searchSkills);
            TreeMap<SkillSet, PSWrap> map = null;
            switch (item.item.slotCount) {
                case 0: {
                    map = compact0;
                    break;
                }
                case 1: {
                    map = compact1;
                    break;
                }
                case 2: {
                    map = compact2;
                    break;
                }
                case 3: {
                    map = compact3;
                }
            }
            PSWrap virtual = (PSWrap)map.get(masked);
            if (virtual == null) {
                PSItem v = masked.isZero() ? PSItem.getVirtualItem(5, item.item.slotCount) : new PSItem(5, "\u304a\u5b88\u308a");
                v.isVirtual = true;
                v.slotCount = item.item.slotCount;
                v.skills = masked;
                virtual = new PSWrap(v);
                virtual.maskedSkills = masked;
                map.put(masked, virtual);
                if (virtual.charmGroup == null) {
                    virtual.charmGroup = new ArrayList();
                    virtual.charmGroupSeek = new ArrayList();
                }
            }
            none.charmGroup.add(item);
            none.charmGroupSeek.add(virtual);
            virtual.charmGroup.add(item);
            virtual.charmGroupSeek.add(virtual);
        }
        ArrayList<PSWrap> ret = new ArrayList<PSWrap>();
        ret.addAll(compact0.values());
        ret.addAll(compact1.values());
        ret.addAll(compact2.values());
        ret.addAll(compact3.values());
        return ret;
    }

    public boolean pageActionScan(PSFrame frame, IProgress progress) {
        PSItemList listForScanTop = new PSItemList();
        HashSet prevResult = null;
        this.listForScanAll = new PSItemList();
        this.listForCheck = new PSItemList();
        if (this.debug) {
            System.out.println("Check " + this.session.searchSkills);
        }
        PSBaseItems dataItems = Repository.getBaseItems();
        PSItemList listForCandidate = new PSItemList();
        listForCandidate.listEquipHead = this.prepareScan(0, dataItems.listEquipHead);
        listForCandidate.listEquipBody = this.prepareScan(1, dataItems.listEquipBody);
        listForCandidate.listEquipArm = this.prepareScan(2, dataItems.listEquipArm);
        listForCandidate.listEquipWeist = this.prepareScan(3, dataItems.listEquipWeist);
        listForCandidate.listEquipLeg = this.prepareScan(4, dataItems.listEquipLeg);
        if (Repository.getResource().existCharm()) {
            listForCandidate.listCharm = this.prepareScan(5, dataItems.listCharm);
            listForCandidate.listCharm.addAll(this.loadExtraCharms());
            this.viewCountTouch.clear();
            if (this.session.searchCharmMatome) {
                listForCandidate.listCharm = this.getVirtualCharmList(listForCandidate.listCharm, PSWrap.getVirtualWrap(5, -2));
                this.viewCountTouch.addAll(listForCandidate.listCharm);
            }
        } else {
            listForCandidate.listCharm = new ArrayList();
        }
        listForCandidate.listDecoration = this.prepareScan(6, dataItems.listDecoration);
        if (this.debug) {
            System.out.println("head = " + listForCandidate.listEquipHead.size());
            System.out.println("body = " + listForCandidate.listEquipBody.size());
            System.out.println("arm = " + listForCandidate.listEquipArm.size());
            System.out.println("weist = " + listForCandidate.listEquipWeist.size());
            System.out.println("leg = " + listForCandidate.listEquipLeg.size());
            System.out.println("charm = " + listForCandidate.listCharm.size());
            System.out.println("decoration = " + listForCandidate.listDecoration.size());
        }
        ArrayList<PSArmorSet> listArmorSet = null;
        listArmorSet = new ArrayList<PSArmorSet>();
        listForScanTop.listDecoration = listForCandidate.listDecoration;
        this.listForScanAll.listDecoration = listForCandidate.listDecoration;
        this.session.items = this.items;
        DecorationMatcherFull matcher = new DecorationMatcherFull(this.session, true);
        matcher._debug = this.debug;
        this.buildSearchTree(0, listForCandidate.listEquipHead, listForScanTop.listEquipHead, this.listForScanAll.listEquipHead);
        this.buildSearchTree(1, listForCandidate.listEquipBody, listForScanTop.listEquipBody, this.listForScanAll.listEquipBody);
        this.buildSearchTree(2, listForCandidate.listEquipArm, listForScanTop.listEquipArm, this.listForScanAll.listEquipArm);
        this.buildSearchTree(3, listForCandidate.listEquipWeist, listForScanTop.listEquipWeist, this.listForScanAll.listEquipWeist);
        this.buildSearchTree(4, listForCandidate.listEquipLeg, listForScanTop.listEquipLeg, this.listForScanAll.listEquipLeg);
        this.buildSearchTree(5, listForCandidate.listCharm, listForScanTop.listCharm, this.listForScanAll.listCharm);
        long cntor = 0L;
        long lastTick = 0L;
        boolean disp = true;
        ArrayList<PSArmorSet> childQue = new ArrayList<PSArmorSet>();
        TreeSet<PSArmorSet> childAlready = new TreeSet<PSArmorSet>();
        long childAlreadyPurgeCount = 0L;
        long finderCancel = 0L;
        if (this.session.searchPlusOneFast) {
            this.plusOneFinder = new PlusOneFinder(this.session, this.session.searchSkills, this.items);
            this.plusOneFinder.useNestedFind = false;
            this.plusOneFinder.onlySkillScan = true;
        }
        ArrayList<PSArmorSet> setList = new ArrayList<PSArmorSet>();
        ArrayList<DecorationSlot> tempResult = new ArrayList<DecorationSlot>();
        MatrixBuilderSkilled topMatrix = new MatrixBuilderSkilled(this.session.searchSkills, this.session.searchWeaponSlotCount);
        topMatrix.addColumn(listForScanTop.listEquipHead);
        topMatrix.addColumn(listForScanTop.listEquipBody);
        topMatrix.addColumn(listForScanTop.listEquipArm);
        topMatrix.addColumn(listForScanTop.listEquipWeist);
        topMatrix.addColumn(listForScanTop.listEquipLeg);
        if (Repository.getResource().existCharm()) {
            topMatrix.addColumn(listForScanTop.listCharm);
        }
        topMatrix.start();
        long cntorMax = topMatrix.iteratorCount();
        progress.startProgress();
        lastTick = System.currentTimeMillis();
        while (!progress.isCanceled()) {
            if (disp || (cntor & 0x3FFL) == 0L) {
                long curTick = System.currentTimeMillis();
                if (curTick - lastTick >= 1000L) {
                    double percent = (double)cntor * 100.0 / (double)cntorMax;
                    progress.progress(percent);
                    progress.resetTextLine();
                    progress.appendTextLine("Search: " + this.session.searchSkills.getNamedSkillNameForSearch() + "\n" + "Hit: " + listArmorSet.size() + " (Thru: " + finderCancel + ")\n" + "Count: " + cntor + "/" + cntorMax + " (Blank: " + topMatrix.skipCount() + ")\n" + "Percent: " + percent + "%" + "\n" + (this.session.searchPlusOneFast ? "+1: " + this.plusOneFinder.getResultAsText(null, false) + "\n" : ""));
                    lastTick = curTick;
                }
                disp = false;
            }
            PSArmorSet armorSet = null;
            boolean fromQueue = false;
            if (!childQue.isEmpty()) {
                armorSet = (PSArmorSet)childQue.remove(childQue.size() - 1);
                fromQueue = true;
            } else {
                armorSet = new PSArmorSet();
                if (!topMatrix.next(armorSet.listItems)) break;
                armorSet.targetSkills = this.session.searchSkills;
            }
            ++cntor;
            if (prevResult != null && !prevResult.contains(armorSet)) continue;
            armorSet.weaponSlotCount = this.session.searchWeaponSlotCount;
            if (fromQueue && childAlreadyPurgeCount > 0L && listArmorSet.contains(armorSet)) continue;
            matcher._useAnotherCheck = this.useAnotherCheck;
            if (this.useAnotherCheck) {
                tempResult.clear();
                if (!matcher.canHaveEnoughDecoration(armorSet, true, tempResult)) {
                    continue;
                }
            } else if (this.session.searchPlusOneFast) {
                tempResult.clear();
                if (!matcher.canHaveEnoughDecoration(armorSet, true, tempResult)) {
                    continue;
                }
            } else if (armorSet.weaponSlotCount <= 0) {
                if (!matcher.canHaveEnoughDecoration(armorSet, false, null)) {
                    continue;
                }
            } else {
                if (this.session.searchMaxCount <= 1L) {
                    if (!matcher.canHaveEnoughDecoration(armorSet, false, null)) continue;
                    return true;
                }
                tempResult.clear();
                if (!matcher.canHaveEnoughDecoration(armorSet, true, tempResult)) continue;
                int realWeaponSlotCount = matcher.fixRealWeaponSlot(armorSet, tempResult);
                if (realWeaponSlotCount != armorSet.weaponSlotCount) {
                    armorSet.weaponSlotCount = realWeaponSlotCount;
                }
            }
            if (!this.session.searchPlusOneFast && this.session.searchMatome) {
                boolean haveSkip = false;
                int max = Repository.getResource().existCharm() ? 5 : 4;
                for (int type = 0; type <= max; ++type) {
                    PSItem item = armorSet.listItems.get((int)type).item;
                    if (item.slotCount == 0 && !item.isCopieSkill && item.skills.isZero()) continue;
                    if (item.slotCount > 0 && item.isVirtual) {
                        PSArmorSet newSet2 = armorSet.makeSetCopy();
                        newSet2.listItems.set(type, PSWrap.getVirtualWrap(type, item.slotCount - 1));
                        if (!matcher.canHaveEnoughDecoration(newSet2, false, null)) continue;
                        childQue.add(newSet2);
                        ++cntorMax;
                        haveSkip = true;
                        continue;
                    }
                    PSArmorSet newSet = armorSet.makeSetCopy();
                    newSet.listItems.set(type, PSWrap.getVirtualWrap(type, 0));
                    if (!matcher.canHaveEnoughDecoration(newSet, false, null)) continue;
                    childQue.add(newSet);
                    ++cntorMax;
                    haveSkip = true;
                }
                if (haveSkip) continue;
            }
            if (Repository.getResource().existCharm() && !this.session.searchPlusOneFast && this.session.searchMatome && this.isCharmHaveReplaceMent(matcher, armorSet)) {
                cntorMax += (long)armorSet.createChildSet(false, childQue, childAlready);
                continue;
            }
            armorSet.session = this.session;
            setList.clear();
            armorSet.drawArmorSets(setList, this.session.searchMatome, this.session.searchCharmMatome);
            disp = true;
            cntorMax += (long)setList.size();
            for (PSArmorSet set : setList) {
                if (progress.isCanceled()) break;
                if (disp || (cntor & 0x3FFL) == 0L) {
                    long curTick = System.currentTimeMillis();
                    if (curTick - lastTick >= 1000L) {
                        double percent = (double)cntor * 100.0 / (double)cntorMax;
                        progress.progress(percent);
                        progress.resetTextLine();
                        progress.appendTextLine("Search: " + this.session.searchSkills.getNamedSkillNameForSearch() + "\n" + "Hit: " + listArmorSet.size() + " (Thru: " + finderCancel + ")\n" + "Count: " + cntor + "/" + cntorMax + " (Blank: " + topMatrix.skipCount() + ")\n" + "Percent: " + percent + "%" + "\n" + (this.session.searchPlusOneFast ? "+1: " + this.plusOneFinder.getResultAsText(null, false) + "\n" : ""));
                        lastTick = curTick;
                    }
                    disp = false;
                }
                ++cntor;
                if (this.session.searchPlusOneFast) {
                    if (!this.plusOneFinder.findAnyPlusOne(set, null, 60000L, tempResult, null)) {
                        ++finderCancel;
                        continue;
                    }
                    if (this.plusOneFinder.onlySkillScan) {
                        ++finderCancel;
                        continue;
                    }
                }
                listArmorSet.add(set);
                if ((long)listArmorSet.size() < this.session.searchMaxCount || this.session.searchOrderByDeffence) continue;
                break;
            }
            disp = true;
            if ((long)listArmorSet.size() >= this.session.searchMaxCount) {
                if (this.session.searchOrderByDeffence) {
                    while ((long)listArmorSet.size() > this.session.searchMaxCount) {
                        ((TreeSet)((Object)listArmorSet)).pollLast();
                    }
                } else {
                    if (!this.session.searchPlusOneFast) break;
                    listArmorSet.clear();
                    this.plusOneFinder.trashGarbage();
                }
            }
            cntorMax += (long)armorSet.createChildSet(false, childQue, childAlready);
        }
        this.listResultSearch.addAll(listArmorSet);
        progress.resetTextLine();
        progress.appendTextLine("Search: " + this.session.searchSkills.getNamedSkillNameForSearch() + "\n" + "Hit: " + listArmorSet.size() + " (Thru: " + finderCancel + ")\n" + "Count: " + cntor + "/" + cntorMax + " (Blank: " + topMatrix.skipCount() + ")\n" + "Percent: 100%" + "\n" + (this.session.searchPlusOneFast ? "+1: " + this.plusOneFinder.getResultAsText(null, false) + "\n" : ""));
        if (this.session.searchPlusOneFast) {
            Map<SkillSet, Set<PSArmorSet>> mapPlusOne = this.plusOneFinder.getResultMap(null);
            ButtonGroup buttonGroup = new ButtonGroup();
            for (SkillSet skills : mapPlusOne.keySet()) {
                frame.addSkillButtonToPlusOne(buttonGroup, skills, 1, "");
            }
        }
        if (this.session.searchPlusOneFast && this.plusOneFinder.onlySkillScan) {
            this.plusOneFinder = null;
        }
        return this.listResultSearch.size() > 0;
    }

    public ArrayList<PSWrap> filterByViewFound(List<PSWrap> armors) {
        ArrayList<PSWrap> result = new ArrayList<PSWrap>(armors.size() + 5);
        for (PSWrap armor : armors) {
            if (!armor.item.viewFound) continue;
            result.add(armor);
        }
        Collections.sort(result);
        return result;
    }

    public void pagePrepareCheck() {
        for (PSArmorSet myset : this.listResultSearch) {
            for (PSWrap wrap : myset.listItems) {
                if (wrap.item.itemType == 5) {
                    // empty if block
                }
                wrap.item.viewFound = true;
                ++wrap.item.viewCount;
            }
        }
        this.listResultChecked.clear();
        this.listResultChecked.addAll(this.listResultSearch);
        this.listForCheck = new PSItemList();
        this.listForCheck.listEquipHead = this.filterByViewFound(this.listForScanAll.listEquipHead);
        this.listForCheck.listEquipBody = this.filterByViewFound(this.listForScanAll.listEquipBody);
        this.listForCheck.listEquipArm = this.filterByViewFound(this.listForScanAll.listEquipArm);
        this.listForCheck.listEquipWeist = this.filterByViewFound(this.listForScanAll.listEquipWeist);
        this.listForCheck.listEquipLeg = this.filterByViewFound(this.listForScanAll.listEquipLeg);
        this.listForCheck.listCharm = this.filterByViewFound(this.listForScanAll.listCharm);
        this.listForCheck.listDecoration = null;
    }

    public void clearViewCount(boolean doClearFoundFlag) {
        ArrayList[] listList;
        PSBaseItems items = Repository.getBaseItems();
        for (ArrayList list : listList = new ArrayList[]{items.listEquipHead, items.listEquipBody, items.listEquipArm, items.listEquipWeist, items.listEquipLeg, items.listDecoration, items.listCharm}) {
            for (PSItem item : list) {
                item.viewCount = 0;
                if (!doClearFoundFlag) continue;
                item.viewFound = false;
            }
        }
        for (int type = 0; type <= 5; ++type) {
            for (int slot = -1; slot <= 3; ++slot) {
                PSWrap wrap = PSWrap.getVirtualWrap(type, slot);
                wrap.item.viewCount = 0;
                if (!doClearFoundFlag) continue;
                wrap.item.viewFound = false;
            }
        }
        for (PSWrap wrap : this.viewCountTouch) {
            wrap.item.viewCount = 0;
            if (!doClearFoundFlag) continue;
            wrap.item.viewFound = false;
        }
    }

    public void findPlusOne(final PSFrame frame, final IProgress progress) {
        final ArrayList<PSArmorSet> setList = this.listResultChecked;
        if (this.plusOneFinder == null || this.plusOneFinder.useNestedFind) {
            this.plusOneFinder = new PlusOneFinder(this.session, this.session.searchSkills, this.items);
            this.plusOneFinder.useNestedFind = false;
            this.plusOneFinder.onlySkillScan = true;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    progress.startProgress();
                    long count = 0L;
                    ArrayList<SkillPoint> pointList = Repository.getSkillCategories().listPoints();
                    long maxCount = setList.size();
                    boolean armorCount = false;
                    long prevTick = 0L;
                    for (PSArmorSet set : setList) {
                        if (progress.isCanceled()) break;
                        long tick = System.currentTimeMillis();
                        if (tick - prevTick >= 1000L) {
                            StringBuilder str = new StringBuilder();
                            String text = Engine.this.plusOneFinder.getResultAsText(setList, false);
                            str.append("\nSearching " + count);
                            str.append("\n" + text);
                            progress.resetTextLine();
                            progress.appendTextLine(str.toString());
                            progress.progress((double)count * 100.0 / (double)maxCount);
                            prevTick = tick;
                        }
                        ++count;
                        Engine.this.plusOneFinder.findAnyPlusOne(set, null, 60000L, null, null);
                    }
                    StringBuilder str = new StringBuilder();
                    String text = Engine.this.plusOneFinder.getResultAsText(setList, false);
                    str.append("\nSearching " + count);
                    str.append("\n" + text);
                    progress.resetTextLine();
                    progress.appendTextLine(str.toString());
                    progress.progress((double)count * 100.0 / (double)maxCount);
                    Engine.this.plusOneFinder.tryFixMinus(setList, null);
                    str = new StringBuilder();
                    text = Engine.this.plusOneFinder.getResultAsText(setList, false);
                    str.append("\nSearching " + count);
                    str.append("\n" + text);
                    progress.resetTextLine();
                    progress.appendTextLine(str.toString());
                    progress.progress((double)count * 100.0 / (double)maxCount);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                finally {
                    progress.finishProgress();
                    Map<SkillSet, Set<PSArmorSet>> mapPlusOne = Engine.this.plusOneFinder.getResultMap(null);
                    ButtonGroup buttonGroup = new ButtonGroup();
                    for (SkillSet skills : mapPlusOne.keySet()) {
                        Set<PSArmorSet> set = mapPlusOne.get(skills);
                        frame.addSkillButtonToPlusOne(buttonGroup, skills, set.size(), "");
                    }
                }
            }
        };
        thread.start();
    }

    public static boolean isTargetSameSkillsAndSlot(PSWrap base, PSWrap target) {
        if (base.item.isCopieSkill) {
            return target.item.isCopieSkill;
        }
        if (target.item.isCopieSkill) {
            return false;
        }
        if (base.item.slotCount != target.item.slotCount) {
            return false;
        }
        if (base.maskedSkills.listKind == target.maskedSkills.listKind) {
            for (int i = 0; i < base.maskedSkills.listKind.length; ++i) {
                int p2;
                int p1 = base.maskedSkills.point(i);
                if (p1 == (p2 = target.maskedSkills.point(i))) continue;
                return false;
            }
        } else {
            throw new Error("uncaught");
        }
        return true;
    }

    public static boolean isTargetWeakChildren(PSWrap base, SkillSet searchSkills, PSWrap grp) {
        if (base.item.isCopieSkill || grp.item.isCopieSkill) {
            return false;
        }
        if (base.item.slotCount < grp.item.slotCount) {
            return false;
        }
        if (Engine.isTargetSameSkillsAndSlot(base, grp)) {
            return false;
        }
        SkillSet skill1 = base.maskedSkills;
        SkillSet skill2 = grp.maskedSkills;
        for (int i = 0; i < searchSkills.size(); ++i) {
            SkillKind kind = searchSkills.kind(i);
            int x1 = skill1.indexOfKind(kind);
            int x2 = skill2.indexOfKind(kind);
            if (x1 < 0 && x2 < 0) continue;
            if (x1 < 0) {
                return false;
            }
            if (x2 < 0 || !(searchSkills.positive(i) ? skill1.point(x1) < skill2.point(x2) : skill1.point(x1) > skill2.point(x2))) continue;
            return false;
        }
        return true;
    }

    public boolean isCharmHaveReplaceMent(DecorationMatcherFull matcher, PSArmorSet set) {
        boolean found = false;
        int type = 5;
        PSWrap noneItem = PSWrap.getVirtualWrap(type, 0);
        PSWrap original = set.listItems.get(type);
        if (original == null) {
            return false;
        }
        if (original.item.slotCount == 0) {
            if (original.item.isVirtual) {
                return false;
            }
            if (original.item.skills.isZero()) {
                return false;
            }
        }
        set.listItems.set(type, noneItem);
        if (matcher.canHaveEnoughDecoration(set, false, null)) {
            found = true;
        }
        if (type == 5) {
            for (PSWrap replace : original.childArmors) {
                if (replace.item == original.item) continue;
                set.listItems.set(5, replace);
                if (!matcher.canHaveEnoughDecoration(set, false, null)) continue;
                found = true;
            }
        }
        set.listItems.set(type, original);
        set.targetSkills = matcher._targetSkills;
        set.calculateUseList(set.targetSkills);
        return found;
    }
}

