;Japanese Support Patch for POPFile
;Written by Junya Ishihara(jishiha@users.sourceforge.net)

!define MUI_PRODUCT "POPFile {ꉻpb`" ;Define your own software name here
!define MUI_VERSION "0.20.1.1" ;Define your own software version here

!include "MUI.nsh"

;--------------------------------
;Configuration

  ;General
  OutFile "popfile_jpn.exe"

  ;Folder selection page
  InstallDir $PROGRAMFILES\POPFile

  ;Remember install folder
  InstallDirRegKey HKLM SOFTWARE\POPFile "InstallLocation"

;--------------------------------
;Modern UI Configuration

  !define MUI_LICENSEPAGE
  !define MUI_COMPONENTSPAGE
  !define MUI_DIRECTORYPAGE
  
  !define MUI_ABORTWARNING
  
  !define MUI_UNINSTALLER
  !define MUI_UNCONFIRMPAGE
  
;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "Japanese"
  
;--------------------------------
;Language Strings

  ;Description
  LangString DESC_SecCopyUI ${LANG_JAPANESE} "POPFile {ꉻpb` CXg[܂B"

;--------------------------------
;Data
  
  LicenseData "license"

;--------------------------------
;Installer Sections

!define VER $2

Section "popfile_jpn.exe" SecCopyUI
  ; Check if POPFile has already installed or not
  IfFileExists "$INSTDIR" NoErrorMsg 0
    MessageBox MB_OK "$INSTDIR ɂ POPFile CXg[Ă܂BfāA܂ POPFile CXg[ĉB"
    Quit
  NoErrorMsg:

  ClearErrors
  FileOpen $0 "$INSTDIR\popfile.pl" "r"
  loop:
    FileRead $0 $1
    IfErrors error
    StrCmp $1 "$$POPFile->CORE_version(0, 20, 1);$\n" 0 +2
      Goto done0201
    StrCmp $1 "$$POPFile->CORE_version(0, 20, 1);$\r$\n" 0 +2
      Goto done0201
    StrCmp $1 "$$POPFile->CORE_version(0, 20, 1);$\r" 0 +2
      Goto done0201
    StrCmp $1 "$$POPFile->CORE_version(0, 20, 1);" 0 +2
      Goto done0201
    StrCmp $1 "$$POPFile->CORE_version(0, 20, 0);$\n" 0 +2
      Goto done0200
    StrCmp $1 "$$POPFile->CORE_version(0, 20, 0);$\r$\n" 0 +2
      Goto done0200
    StrCmp $1 "$$POPFile->CORE_version(0, 20, 0);$\r" 0 +2
      Goto done0200
    StrCmp $1 "$$POPFile->CORE_version(0, 20, 0);" 0 +2
      Goto done0200
    Goto loop

    error:
    MessageBox MB_YESNO "$INSTDIR ɂ POPFile CXg[ĂȂ\܂Bpopfile.pl t@C܂Błpb`̃CXg[𑱂܂H" IDYES done0201
    FileClose $0
    Quit

  done0201:
    MessageBox MB_YESNO "POPFile 0.20.1 CXg[Ă̂o܂B0.20.1 p̓{ꉻpb`CXg[܂HiNo NbN 0.20.0 p̓{ꉻpb`CXg[܂j" IDYES 0 IDNO +3
      StrCpy ${VER} "0.20.1"
      Goto done
    MessageBox MB_YESNO "POPFile 0.20.0 p̓{ꉻpb`CXg[܂HiNo NbNƃCXg[Ƃ𒆎~܂j" IDYES 0 IDNO +3
      StrCpy ${VER} "0.20.0"
      Goto done
    FileClose $0
    Quit

  done0200:
    MessageBox MB_YESNO "POPFile 0.20.0 CXg[Ă̂o܂B0.20.0 p̓{ꉻpb`CXg[܂HiNo NbN 0.20.1 p̓{ꉻpb`CXg[܂j" IDYES 0 IDNO +3
      StrCpy ${VER} "0.20.0"
      Goto done
    MessageBox MB_YESNO "POPFile 0.20.1 p̓{ꉻpb`CXg[܂HiNo NbNƃCXg[Ƃ𒆎~܂j" IDYES 0 IDNO +3
      StrCpy ${VER} "0.20.1"
      Goto done
    FileClose $0
    Quit

  done:
    FileClose $0

  SetOutPath "$INSTDIR"
  WriteUninstaller "popfile_jpn-uninst.exe"

  ; Backup files that are to be updated
  Rename $INSTDIR\Classifier\Bayes.pm $INSTDIR\Classifier\Bayes.pm_original
  
  ; Copy(Overwrite) directories
  StrCmp ${VER} "0.20.1" 0 next
      File /r POPFile\0.20.1\Classifier
      Goto CopyEnd
  next: 
  StrCmp ${VER} "0.20.0" 0 CopyError
      File /r POPFile\0.20.0\Classifier
      Goto CopyEnd

  CopyError:
    Quit

  CopyEnd:

  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\popfile_jpn "Install_Dir" "$INSTDIR"

  ; Write the registry information related to uninstall
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\popfile_jpn" "DisplayName" '"POPFile {ꉻpb`"'
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\popfile_jpn" "UninstallString" '"$INSTDIR\popfile_jpn-uninst.exe"'

SectionEnd

;Display the Finish header
;Insert this macro after the sections if you are not using a finish page
!insertmacro MUI_SECTIONS_FINISHHEADER

;--------------------------------
;Descriptions

!insertmacro MUI_FUNCTIONS_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SecCopyUI} $(DESC_SecCopyUI)
!insertmacro MUI_FUNCTIONS_DESCRIPTION_END
 
;--------------------------------
;Uninstaller Section

Section "Uninstall"

  ; remove registry keys
  DeleteRegKey HKLM SOFTWARE\popfile_jpn
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\popfile_jpn"

  ; Delete files
  Delete "$INSTDIR\Classifier\Bayes.pm"

  ; Resume backup files
  Rename $INSTDIR\Classifier\Bayes.pm_original $INSTDIR\Classifier\Bayes.pm

  ;Display the Finish header
  !insertmacro MUI_UNFINISHHEADER

SectionEnd