;Japanese Support Patch for POPFile
;Written by Junya Ishihara(jishiha@users.sourceforge.net)

!define MUI_PRODUCT "POPFile {ꉻpb`" ;Define your own software name here
!define MUI_VERSION "0.19.1.3" ;Define your own software version here

!include "MUI.nsh"
!include "WriteEnvStr.nsh"

;--------------------------------
;Configuration

  ;General
  OutFile "popfile_jpn.exe"

  ;Folder selection page
  ;InstallDir "$PROGRAMFILES\${MUI_PRODUCT}"
  InstallDir $PROGRAMFILES\POPFile

  ;Remember install folder
  ;InstallDirRegKey HKCU "Software\${MUI_PRODUCT}" ""
  InstallDirRegKey HKLM SOFTWARE\POPFile "InstallLocation"

;--------------------------------
;Modern UI Configuration

  !define MUI_LICENSEPAGE
  !define MUI_COMPONENTSPAGE
  !define MUI_DIRECTORYPAGE
  
  !define MUI_ABORTWARNING
  
  !define MUI_UNINSTALLER
  !define MUI_UNCONFIRMPAGE
  
;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "Japanese"
  
;--------------------------------
;Language Strings

  ;Description
  LangString DESC_SecCopyUI ${LANG_JAPANESE} "POPFile {ꉻpb` CXg[܂B"

;--------------------------------
;Data
  
  LicenseData "license"

;--------------------------------
;Installer Sections

Section "popfile_jpn.exe" SecCopyUI

  ; Check if POPFile has already installed or not
  IfFileExists "$INSTDIR" NoErrorMsg 0
    MessageBox MB_OK "$INSTDIR ɂ POPFile CXg[Ă܂BfāA܂ POPFile CXg[ĉB"
    Quit
  NoErrorMsg:

  SetOutPath "$INSTDIR"
  WriteUninstaller "popfile_jpn-uninst.exe"

  ; Backup files that are to be updated
  Rename $INSTDIR\Classifier\Bayes.pm $INSTDIR\Classifier\Bayes.pm_original
  Rename $INSTDIR\Classifier\MailParse.pm $INSTDIR\Classifier\MailParse.pm_original
  Rename $INSTDIR\UI\HTML.pm $INSTDIR\UI\HTML.pm_original
  Rename $INSTDIR\stopwords $INSTDIR\stopwords_original

  ; Copy(Overwrite) directories
  File /r POPFile\languages
  File /r POPFile\auto
  File /r POPFile\Encode
  File /r POPFile\Text
  File /r POPFile\manual
  File /r POPFile\Classifier
  File /r POPFile\UI

  ; Copy(Overwrite) files
  File POPFile\base.pm
  File POPFile\Encode.pm
  File POPFile\stopwords

  ; Install Kakasi
  File /r kakasi

  ; Add Environment Variables related to Kakasi
  Push ITAIJIDICTPATH
  Push $INSTDIR\kakasi\share\kakasi\itaijidict
  Call WriteEnvStr
  Push KANWADICTPATH
  Push $INSTDIR\kakasi\share\kakasi\kanwadict
  Call WriteEnvStr

  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\popfile_jpn "Install_Dir" "$INSTDIR"

  ; Write the registry information related to uninstall
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\popfile_jpn" "DisplayName" '"POPFile {ꉻpb`"'
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\popfile_jpn" "UninstallString" '"$INSTDIR\popfile_jpn-uninst.exe"'

  ; Update popfile.cfg
  ClearErrors
  FileOpen $0 "$INSTDIR\popfile.cfg" "r"
  GetTempFileName $R0
  FileOpen $1 $R0 "w"
  loop:
    FileRead $0 $2
    IfErrors done
    FileWrite $1 $2
  Goto loop
  
  done:
    FileWrite $1 "html_language Nihongo$\r$\n"
    FileWrite $1 "html_skin tinydefault$\r$\n"
    FileClose $0
    FileClose $1
    Delete "$INSTDIR\popfile.cfg"
    CopyFiles /SILENT $R0 "$INSTDIR\popfile.cfg"
    Delete $R0

SectionEnd

;Display the Finish header
;Insert this macro after the sections if you are not using a finish page
!insertmacro MUI_SECTIONS_FINISHHEADER

;--------------------------------
;Descriptions

!insertmacro MUI_FUNCTIONS_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SecCopyUI} $(DESC_SecCopyUI)
!insertmacro MUI_FUNCTIONS_DESCRIPTION_END
 
;--------------------------------
;Uninstaller Section

Section "Uninstall"

  ; remove registry keys
  DeleteRegKey HKLM SOFTWARE\popfile_jpn
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\popfile_jpn"

  ;Delete Environment Variables
  Push KANWADICTPATH
  Call un.DeleteEnvStr
  Push ITAIJIDICTPATH
  Call un.DeleteEnvStr

  ; Delete directories
  RMDir /r "$INSTDIR\auto\Encode"
  RMDir /r "$INSTDIR\auto\Text"
  RMDir /r "$INSTDIR\Encode"
  RMDir /r "$INSTDIR\Text"
  RMDir /r "$INSTDIR\manual\jp"

  ; Delete files
  Delete "$INSTDIR\languages\Nihongo.msg"
  Delete "$INSTDIR\base.pm"
  Delete "$INSTDIR\Encode.pm"
  Delete "$INSTDIR\Classifier\Bayes.pm"
  Delete "$INSTDIR\Classifier\MailParse.pm"
  Delete "$INSTDIR\UI\HTML.pm"
  Delete "$INSTDIR\stopwords"

  ; Resume backup files
  Rename $INSTDIR\Classifier\Bayes.pm_original $INSTDIR\Classifier\Bayes.pm
  Rename $INSTDIR\Classifier\MailParse.pm_original $INSTDIR\Classifier\MailParse.pm
  Rename $INSTDIR\UI\HTML.pm_original $INSTDIR\UI\HTML.pm
  Rename $INSTDIR\stopwords_original $INSTDIR\stopwords

  ; Delete Kakasi
  RMDir /r "$INSTDIR\kakasi"

  ; Restore popfile.cfg
  ClearErrors
  FileOpen $0 "$INSTDIR\popfile.cfg" "r"
  GetTempFileName $R0
  FileOpen $1 $R0 "w"
  loop:
    FileRead $0 $2
    IfErrors done
    FileWrite $1 $2
  Goto loop
  
  done:
    FileWrite $1 "html_language English$\r$\n"
    FileWrite $1 "html_skin SimplyBlue$\r$\n"
    FileClose $0
    FileClose $1
    Delete "$INSTDIR\popfile.cfg"
    CopyFiles /SILENT $R0 "$INSTDIR\popfile.cfg"
    Delete $R0

  ;Display the Finish header
  !insertmacro MUI_UNFINISHHEADER

SectionEnd