﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Management;
using System.Collections;
using PomeraAccesser;

namespace PM_Text
{
    public class PM_Text
    {
        static void Main(string[] args)
        {
            //
            //プログラム開始
            //
            Console.Title = "PomeraMirror-Text";
            Console.WriteLine("---------------------------PomeraMirror-Text Start.");

            //
            //出力先ディレクトリのチェック
            //
            Console.WriteLine("Checking Destination Directories...");                           //出力ディレクトリ確認中
            string myDocDir = Environment.GetFolderPath(Environment.SpecialFolder.Personal);    //My Documents取得
            const string POMERA_DIR = "pomera";                                                 //pomera
            string dstDir = System.IO.Path.Combine(myDocDir, POMERA_DIR);                       //My Documents + \ + pomera
            DateTime dt = System.DateTime.Now;                                                  //日付を取得
            string dateStr = dt.ToString("yyyyMMdd");                                           //日付yyyymmdd
            dstDir = System.IO.Path.Combine(dstDir, dateStr);                                   //My Documents + \ + pomera + \ + yyyymmdd

            if (System.IO.Directory.Exists(dstDir)) //出力ディレクトリが既に存在していれば
            {
                Console.ForegroundColor = ConsoleColor.Yellow;                                  //文字を注意色にする。
                Console.WriteLine("Warning:");                                                  //ワーニングメッセージ
                Console.WriteLine("    出力先ディレクトリが既に存在しています {0}", dstDir);    //メッセージを出力する。
                Console.WriteLine("    ディレクトリを削除してから再実行してください。");
                Console.ForegroundColor = ConsoleColor.Gray;                                    //文字色を通常色に戻す。
                goto Finish;                                                                    //終了処理へ

            }
            else
            {
                System.IO.Directory.CreateDirectory(dstDir);
            }

            //
            //ポメラドライブの取得
            //
            Console.WriteLine("Serching Pomera Drives...");                 //ポメラドライブ検出中
            PomeraAccesser.PAccess.PomeraDriveStatus ret;
            ArrayList pomeraDrives = new ArrayList();                       //ポメラドライブ格納先

            System.IO.DriveInfo[] drives = System.IO.DriveInfo.GetDrives(); //全ドライブを取得
            foreach (System.IO.DriveInfo d in drives)  //全てのドライブに対して
            {
                string driveName = d.Name;
                driveName = driveName.Remove(2);                    //"c:\"->"c:"
                Console.WriteLine("  drive　{0}", driveName);       //チェック中のドライブを表示。
                ret = PAccess.IsPomeraDrive(driveName);             //ポメラドライブか?
                if (ret == PAccess.PomeraDriveStatus.PomeraDrive)   //ポメラドライブであれば
                {
                    pomeraDrives.Add(driveName);                    //ポメラドライブを格納。
                }
            }

            //
            //ポメラが接続されていなければワーニングを出して終了
            //
            if (pomeraDrives.Count == 0)
            {
                Console.ForegroundColor = ConsoleColor.Yellow;                  //文字を注意色にする。
                Console.WriteLine("Warning: ポメラが接続されていません");       //ワーニングメッセージ
                Console.ForegroundColor = ConsoleColor.Gray;                    //文字色を通常色に戻す。
                goto Finish;                                                    //終了処理へ
            }

            //
            //ポメラよりテキストファイルをコピー
            //
            try
            {
                Console.WriteLine("Mirroring Files...");
                foreach (string srcDrive in pomeraDrives)                       //ポメラドライブ全てに対して
                {
                    Console.WriteLine(" {0}", srcDrive);                        //処理ドライブを表示
                    MirrorTextFiles(srcDrive, dstDir);                          //テキストファイルをコピー
                }
                
            }
            catch (System.Exception ex)
            {
                Console.ForegroundColor = ConsoleColor.Red;                     //文字をエラー色にする。
                Console.WriteLine("Error:テキストファイルコピー中に例外が発生しました");
                Console.WriteLine(ex.ToString());                               //例外を表示
                goto Finish;                                                    //終了処理へ
            }

            //
            //終了処理
            //
            Finish:
            Console.ForegroundColor = ConsoleColor.Gray;                   //文字色を通常色に戻す。
            Console.WriteLine("--------------PomeraMirror-Text End. Press any key.");
            ConsoleKeyInfo ki = Console.ReadKey();                          //ユーザ入力待ち

        }
        
        //
        //ポメラのテキストファイルをバックアップする。
        //
        private static void MirrorTextFiles(string pomeraDrive, string dstDir)
        {
            //テキストファイル取得
            string[] textFiles = System.IO.Directory.GetFiles(pomeraDrive, "*.txt", System.IO.SearchOption.AllDirectories);

            foreach (string srcFile in textFiles)
            {
                //ファイル名の取得
                string fileName = System.IO.Path.GetFileName(srcFile);

                //出力先ファイル名
                string dstFile = System.IO.Path.Combine(dstDir, fileName);  //出力先ディレクトリ+テキストファイル名

                //出力先に同名のファイルが既に存在しているか？
                if (System.IO.File.Exists(dstFile)) //出力先ファイルが存在していれば
                {
                    DateTime srcTime = System.IO.File.GetLastWriteTime(srcFile);
                    DateTime dstTime = System.IO.File.GetLastWriteTime(dstFile);

                    //ワーニングメッセージ出力
                    Console.ForegroundColor = ConsoleColor.Yellow;                              //文字を注意色にする。
                    Console.WriteLine("Warning: 同名のファイルが存在します。{0}",fileName);     //ワーニングメッセージ
                    Console.ForegroundColor = ConsoleColor.Gray;                                //文字色を通常色に戻す。
 

                    int compareResult = DateTime.Compare(srcTime, dstTime);
                    if (compareResult < 0) // 出力先のファイルが新しい
                    {
                        continue;          //コピーしない。 
                    }
                    else if (compareResult > 0) // 出力先のファイルが古い
                    {
                        System.IO.File.Copy(srcFile, dstFile, true);    //上書きする。
                    }
                    else //同時刻
                    {
                        //エラーメッセージ出力
                        Console.ForegroundColor = ConsoleColor.Red;                                 //文字をエラー色にする。
                        string errMsg = "Error:同名・同時刻のファイルが存在します。" + fileName;    //エラーメッセージ作成
                        Console.WriteLine(errMsg);
                        throw new System.Exception(errMsg);                                         //例外スロー
                    }

                }
                else //出力先ファイルが存在していなければ
                {
                    Console.WriteLine("   {0}", fileName);
                    System.IO.File.Copy(srcFile, dstFile);

                }

            }


        }
    }
}
