﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Management;
using System.Collections;
using PomeraAccesser;


namespace PM_Files
{
    public class PM_Files
    {
        static void Main(string[] args)
        {
            //
            //プログラム開始
            //
            Console.Title = "PomeraMirror-Files";
            Console.WriteLine("---------------------------PomeraMirror-Files Start.");

            //
            //ポメラドライブの取得
            //
            Console.WriteLine("Serching Pomera Drives...");                 //ポメラドライブ検出中
            PomeraAccesser.PAccess.PomeraDriveStatus ret;
            ArrayList pomeraDrives = new ArrayList();                       //ポメラドライブ格納先

            System.IO.DriveInfo[] drives = System.IO.DriveInfo.GetDrives(); //全ドライブを取得
            foreach (System.IO.DriveInfo d in drives)  //全てのドライブに対して
            {
                string driveName = d.Name;
                driveName = driveName.Remove(2);                    //"c:\"->"c:"
                Console.WriteLine("  drive　{0}", driveName);       //チェック中のドライブを表示。
                ret = PAccess.IsPomeraDrive(driveName);             //ポメラドライブか?
                if (ret == PAccess.PomeraDriveStatus.PomeraDrive)   //ポメラドライブであれば
                {
                    pomeraDrives.Add(driveName);                    //ポメラドライブを格納。
                }
            }

            //
            //ポメラが接続されていなければワーニングを出して終了
            //
            if (pomeraDrives.Count == 0)
            {
                Console.ForegroundColor = ConsoleColor.Yellow;                  //文字を注意色にする。
                Console.WriteLine("Warning: ポメラが接続されていません");       //ワーニングメッセージ
                Console.ForegroundColor = ConsoleColor.Gray;                    //文字色を通常色に戻す。
                goto Finish;                                                    //終了処理へ
            }

            //
            //出力先ディレクトリのチェック
            //
            Console.WriteLine("Checking Destination Directories...");                           //出力ディレクトリ確認中
            string myDocDir = Environment.GetFolderPath(Environment.SpecialFolder.Personal);    //My Documents取得
            const string POMERA_DIR = "pomera";                                                 //pomera
            string dstDirBase = System.IO.Path.Combine(myDocDir, POMERA_DIR);                   //My Documents + \ + pomera
            DateTime dt = System.DateTime.Now;                                                  //日付を取得
            string dateStr = dt.ToString("yyyyMMdd");                                           //日付yyyymmdd
            dstDirBase = System.IO.Path.Combine(dstDirBase, dateStr);                           //My Documents + \ + pomera + \ + yyyymmdd
            foreach (string pDrv in pomeraDrives) //全てのポメラドライブに対して
            {
                string srcDirChar = pDrv.Remove(1);         //D: →　D
                string chkDir = dstDirBase + srcDirChar;    //チェックディレクトリ(My Documents\pomera\yyyymmdd+?)
                if (System.IO.Directory.Exists(chkDir))     //出力先ディレクトリが存在すれば
                {
                    Console.ForegroundColor = ConsoleColor.Yellow;                                      //文字を注意色にする。
                    Console.WriteLine("Warning:");                                                      //ワーニングメッセージ
                    Console.WriteLine("    出力先ディレクトリが既に存在しています {0}", dstDirBase);    //メッセージを出力する。
                    Console.WriteLine("    ディレクトリを削除してから再実行してください。");
                    Console.ForegroundColor = ConsoleColor.Gray;                                        //文字色を通常色に戻す。

                    goto Finish;    //終了する。

                }

            }

            //
            //ファイルコピー
            //
            Console.WriteLine("Mirroring Files...");
            foreach (string srcDir in pomeraDrives) //全てのポメラドライブに対して
            {
                string srcDirChar = srcDir.Remove(1);           //D: → D
                string dstDir = dstDirBase + srcDirChar;        //出力先ディレクトリ(My Documents\pomera\yyyymmdd+?)
                Console.WriteLine("processing: {0}", srcDir);   //処理実行中

                try
                {
                    DirectoryCopy(srcDir, dstDir, true);        //ディレクトリをコピーする。
                    //ミラー作成結果を表示
                    Console.WriteLine("   mirroring done.");
                    Console.WriteLine("    src: {0}", srcDir);
                    Console.WriteLine("    dst: {0}", dstDir);
                }
                catch (Exception ex)
                {
                    Console.ForegroundColor = ConsoleColor.Red;                     //文字をエラー色にする。
                    Console.WriteLine("Error:ファイルコピー中に例外が発生しました");
                    Console.WriteLine(ex.ToString());                               //例外を表示
                    goto Finish;                                                    //終了処理へ
                }
            }

            //
            //終了処理
            //
            Finish:
            Console.ForegroundColor = ConsoleColor.Gray;                   //文字色を通常色に戻す。
            Console.WriteLine("--------------PomeraMirror-Files End. Press any key.");
            ConsoleKeyInfo ki = Console.ReadKey();                          //ユーザ入力待ち

        }
        //
        //ディレクトリをコピーする
        //ms-help://MS.VSCC.v90/MS.MSDNQTR.v90.ja/dv_fxfund/html/5a969765-e5f8-4b4e-977e-90e2b0a1fe3c.htm
        //
        private static void DirectoryCopy(string sourceDirName, string destDirName, bool copySubDirs)
        {
            DirectoryInfo dir = new DirectoryInfo(sourceDirName);
            DirectoryInfo[] dirs = dir.GetDirectories();

            // If the source directory does not exist, throw an exception.
            if (!dir.Exists)
            {
                throw new DirectoryNotFoundException(
                    "Source directory does not exist or could not be found: "
                    + sourceDirName);
            }

            // If the destination directory does not exist, create it.
            if (!Directory.Exists(destDirName))
            {
                Directory.CreateDirectory(destDirName);
            }


            // Get the file contents of the directory to copy.
            FileInfo[] files = dir.GetFiles();

            foreach (FileInfo file in files)
            {
                // Create the path to the new copy of the file.
                string temppath = Path.Combine(destDirName, file.Name);

                // Copy the file.
                file.CopyTo(temppath, false);
            }

            // If copySubDirs is true, copy the subdirectories.
            if (copySubDirs)
            {

                foreach (DirectoryInfo subdir in dirs)
                {
                    // Create the subdirectory.
                    string temppath = Path.Combine(destDirName, subdir.Name);

                    // Copy the subdirectories.
                    DirectoryCopy(subdir.FullName, temppath, copySubDirs);
                }
            }
        }
    }
}
