﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Management;

namespace PomeraAccesser
{
    public class PAccess
    {
        public enum PomeraDriveStatus
        {
            PomeraDrive,            //ポメラのドライブ。
            NotPomeraDrive,         //ポメラのドライブではない。
            NotDriveFound,          //指定されたドライブが存在しない/Readyでない。
            ExceptionOccured,       //例外が発生した。
            DriveNameFormatError    //ドライブ名のフォーマット"?:"でない
        }
        public static PomeraDriveStatus IsPomeraDrive(string drvName)
        {

            //入力文字列の妥当性判定 
            //"C:"形式であるかチェック
            if (!System.Text.RegularExpressions.Regex.IsMatch(
                drvName
                , "^[A-Z]:$"))
            {
                return (PomeraDriveStatus.DriveNameFormatError);
            }
            //対象ドライブが存在するか?
            if (!System.IO.Directory.Exists(drvName))
            {
                return (PomeraDriveStatus.NotDriveFound);
            }



            bool bDrvFound = false;                 //対象ドライブ未検出とする。

            //LogicalDiskToPartitionオブジェクトの取得
            ManagementObjectSearcher searcher = new ManagementObjectSearcher("SELECT * FROM Win32_LogicalDiskToPartition");
            foreach (ManagementObject mo in searcher.Get())  //LogicalDiskToPartitionオブジェクト全て
            {
                //論理ドライブを取得
                string logicakDiskPartitionInfo = mo["Dependent"].ToString();
                ManagementObject dm = new ManagementObject(logicakDiskPartitionInfo);
                string driveLetter = dm["DeviceID"].ToString(); //論理ドライブ名　ex."C:"

                if (driveLetter.Equals(drvName))                //対象のドライブであれば
                {

                    //物理ドライブを取得
                    string physicalDiskPartitionInfo = mo["Antecedent"].ToString();

                    // Win32_DiskPartitionオブジェクトの取得
                    ManagementObject pd = new ManagementObject(physicalDiskPartitionInfo);
                    string driveNumber = "0";		//物理ドライブ番号仮に0 ex."0"

                    try //Xpのバグよけ　http://support.microsoft.com/kb/916191/ja 参照
                    {
                        driveNumber = pd["DiskIndex"].ToString();		 //物理ドライブ番号 ex."0"

                        //Win32_DiskDriveオブジェクトの取得 
                        ManagementObjectSearcher disks = new ManagementObjectSearcher("SELECT * FROM Win32_DiskDrive");
                        foreach (ManagementObject disk in disks.Get())			//全ての物理ドライブに対して
                        {
                            string diskName = disk["Name"].ToString();          //物理ドライブ名 ex."\\\\.\\PHYSICALDRIVE1"
                            string diskModel = disk["Model"].ToString();        //ハードウェア名 ex."Hitachi HDT721010SLA360 ATA Device"

                            if (diskName == "\\\\.\\PHYSICALDRIVE" + driveNumber) //検査対象のドライブであった
                            {
                                bDrvFound = true;   //検査対象のドライブが見つかった

                                if ((diskModel == "DM10 USB Device")　　　　//ポメラDM10
                                    || (diskModel == "DM20 USB Device") 	//ポメラDM20
                                    || (diskModel == "DM5 USB Device")) 	//ポメラDM5 未デバッグ
                                {
                                    return (PomeraDriveStatus.PomeraDrive);
                                 
                                }
                                else //検査対象のドライブがポメラドライブでなかった
                                {
                                    return (PomeraDriveStatus.NotPomeraDrive);
                                }

                            }
                            else //検査対象のドライブでなかった
                            {
                                continue; //次のドライブを調査する。
                            }
                        }
                    }
                    catch (System.Exception ex) //クエリ取得でエラーが発生した。
                    {
                        return (PomeraDriveStatus.ExceptionOccured);
                    }
                }
                else　//対象のドライブでなければ
                {
                    continue;   //次のドライブに移動
                }
            }
            if (bDrvFound != true) //ドライブ検出されず
            {
                return (PomeraDriveStatus.NotDriveFound);

            }
            return (PomeraDriveStatus.NotDriveFound);
        }
    }
}
