/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.poi.hwpf.model.BookmarksTables;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PropertyNode;
import org.apache.poi.hwpf.usermodel.Bookmark;
import org.apache.poi.hwpf.usermodel.Bookmarks;

public class BookmarksImpl
implements Bookmarks {
    private final BookmarksTables bookmarksTables;
    private Map sortedDescriptors = null;
    private int[] sortedStartPositions = null;

    public BookmarksImpl(BookmarksTables bookmarksTables) {
        this.bookmarksTables = bookmarksTables;
        this.reset();
    }

    void afterDelete(int startCp, int length) {
        this.bookmarksTables.afterDelete(startCp, length);
        this.reset();
    }

    void afterInsert(int startCp, int length) {
        this.bookmarksTables.afterInsert(startCp, length);
        this.reset();
    }

    private Bookmark getBookmark(GenericPropertyNode first) {
        return new BookmarkImpl(first);
    }

    public Bookmark getBookmark(int index) {
        GenericPropertyNode first = this.bookmarksTables.getDescriptorFirst(index);
        return this.getBookmark(first);
    }

    public List getBookmarksAt(int startCp) {
        this.updateSortedDescriptors();
        List nodes = (List)this.sortedDescriptors.get(new Integer(startCp));
        if (nodes == null || nodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Bookmark> result = new ArrayList<Bookmark>(nodes.size());
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            GenericPropertyNode node = (GenericPropertyNode)iterator.next();
            result.add(this.getBookmark(node));
        }
        return Collections.unmodifiableList(result);
    }

    public int getBookmarksCount() {
        return this.bookmarksTables.getDescriptorsFirstCount();
    }

    public Map getBookmarksStartedBetween(int startInclusive, int endExclusive) {
        int endLookupIndex;
        this.updateSortedDescriptors();
        int startLookupIndex = Arrays.binarySearch(this.sortedStartPositions, startInclusive);
        if (startLookupIndex < 0) {
            startLookupIndex = -(startLookupIndex + 1);
        }
        if ((endLookupIndex = Arrays.binarySearch(this.sortedStartPositions, endExclusive)) < 0) {
            endLookupIndex = -(endLookupIndex + 1);
        }
        LinkedHashMap<Integer, List> result = new LinkedHashMap<Integer, List>();
        int lookupIndex = startLookupIndex;
        while (lookupIndex < endLookupIndex) {
            int s = this.sortedStartPositions[lookupIndex];
            if (s >= startInclusive) {
                if (s >= endExclusive) break;
                List startedAt = this.getBookmarksAt(s);
                if (startedAt != null) {
                    result.put(new Integer(s), startedAt);
                }
            }
            ++lookupIndex;
        }
        return Collections.unmodifiableMap(result);
    }

    public void remove(int index) {
        this.bookmarksTables.remove(index);
    }

    private void reset() {
        this.sortedDescriptors = null;
        this.sortedStartPositions = null;
    }

    private void updateSortedDescriptors() {
        if (this.sortedDescriptors != null) {
            return;
        }
        HashMap<Integer, LinkedList<GenericPropertyNode>> result = new HashMap<Integer, LinkedList<GenericPropertyNode>>();
        int b = 0;
        while (b < this.bookmarksTables.getDescriptorsFirstCount()) {
            GenericPropertyNode property = this.bookmarksTables.getDescriptorFirst(b);
            Integer positionKey = new Integer(property.getStart());
            LinkedList<GenericPropertyNode> atPositionList = (LinkedList<GenericPropertyNode>)result.get(positionKey);
            if (atPositionList == null) {
                atPositionList = new LinkedList<GenericPropertyNode>();
                result.put(positionKey, atPositionList);
            }
            atPositionList.add(property);
            ++b;
        }
        int counter = 0;
        int[] indices = new int[result.size()];
        Iterator iterator = result.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            indices[counter++] = (Integer)entry.getKey();
            ArrayList updated = new ArrayList((Collection)entry.getValue());
            Collections.sort(updated, PropertyNode.EndComparator.instance);
            entry.setValue(updated);
        }
        Arrays.sort(indices);
        this.sortedDescriptors = result;
        this.sortedStartPositions = indices;
    }

    private final class BookmarkImpl
    implements Bookmark {
        private final GenericPropertyNode first;

        private BookmarkImpl(GenericPropertyNode first) {
            this.first = first;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BookmarkImpl other = (BookmarkImpl)obj;
            return !(this.first == null ? other.first != null : !this.first.equals(other.first));
        }

        public int getEnd() {
            int currentIndex = BookmarksImpl.this.bookmarksTables.getDescriptorFirstIndex(this.first);
            try {
                GenericPropertyNode descriptorLim = BookmarksImpl.this.bookmarksTables.getDescriptorLim(currentIndex);
                return descriptorLim.getStart();
            }
            catch (IndexOutOfBoundsException exc) {
                return this.first.getEnd();
            }
        }

        public String getName() {
            int currentIndex = BookmarksImpl.this.bookmarksTables.getDescriptorFirstIndex(this.first);
            try {
                return BookmarksImpl.this.bookmarksTables.getName(currentIndex);
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                return "";
            }
        }

        public int getStart() {
            return this.first.getStart();
        }

        public int hashCode() {
            return 31 + (this.first == null ? 0 : this.first.hashCode());
        }

        public void setName(String name) {
            int currentIndex = BookmarksImpl.this.bookmarksTables.getDescriptorFirstIndex(this.first);
            BookmarksImpl.this.bookmarksTables.setName(currentIndex, name);
        }

        public String toString() {
            return "Bookmark [" + this.getStart() + "; " + this.getEnd() + "): name: " + this.getName();
        }
    }
}

