/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model.types;

import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public abstract class FibBaseAbstractType {
    protected int field_1_wIdent;
    protected int field_2_nFib;
    protected int field_3_unused;
    protected int field_4_lid;
    protected int field_5_pnNext;
    protected short field_6_flags1;
    private static final BitField fDot = new BitField(1);
    private static final BitField fGlsy = new BitField(2);
    private static final BitField fComplex = new BitField(4);
    private static final BitField fHasPic = new BitField(8);
    private static final BitField cQuickSaves = new BitField(240);
    private static final BitField fEncrypted = new BitField(256);
    private static final BitField fWhichTblStm = new BitField(512);
    private static final BitField fReadOnlyRecommended = new BitField(1024);
    private static final BitField fWriteReservation = new BitField(2048);
    private static final BitField fExtChar = new BitField(4096);
    private static final BitField fLoadOverride = new BitField(8192);
    private static final BitField fFarEast = new BitField(16384);
    private static final BitField fObfuscated = new BitField(32768);
    protected int field_7_nFibBack;
    protected int field_8_lKey;
    protected byte field_9_envr;
    protected byte field_10_flags2;
    private static final BitField fMac = new BitField(1);
    private static final BitField fEmptySpecial = new BitField(2);
    private static final BitField fLoadOverridePage = new BitField(4);
    private static final BitField reserved1 = new BitField(8);
    private static final BitField reserved2 = new BitField(16);
    private static final BitField fSpare0 = new BitField(254);
    protected short field_11_Chs;
    protected short field_12_chsTables;
    protected int field_13_fcMin;
    protected int field_14_fcMac;

    protected FibBaseAbstractType() {
    }

    protected void fillFields(byte[] data, int offset) {
        this.field_1_wIdent = LittleEndian.getShort((byte[])data, (int)(0 + offset));
        this.field_2_nFib = LittleEndian.getShort((byte[])data, (int)(2 + offset));
        this.field_3_unused = LittleEndian.getShort((byte[])data, (int)(4 + offset));
        this.field_4_lid = LittleEndian.getShort((byte[])data, (int)(6 + offset));
        this.field_5_pnNext = LittleEndian.getShort((byte[])data, (int)(8 + offset));
        this.field_6_flags1 = LittleEndian.getShort((byte[])data, (int)(10 + offset));
        this.field_7_nFibBack = LittleEndian.getShort((byte[])data, (int)(12 + offset));
        this.field_8_lKey = LittleEndian.getInt((byte[])data, (int)(14 + offset));
        this.field_9_envr = data[18 + offset];
        this.field_10_flags2 = data[19 + offset];
        this.field_11_Chs = LittleEndian.getShort((byte[])data, (int)(20 + offset));
        this.field_12_chsTables = LittleEndian.getShort((byte[])data, (int)(22 + offset));
        this.field_13_fcMin = LittleEndian.getInt((byte[])data, (int)(24 + offset));
        this.field_14_fcMac = LittleEndian.getInt((byte[])data, (int)(28 + offset));
    }

    public void serialize(byte[] data, int offset) {
        LittleEndian.putUShort((byte[])data, (int)(0 + offset), (int)this.field_1_wIdent);
        LittleEndian.putUShort((byte[])data, (int)(2 + offset), (int)this.field_2_nFib);
        LittleEndian.putUShort((byte[])data, (int)(4 + offset), (int)this.field_3_unused);
        LittleEndian.putUShort((byte[])data, (int)(6 + offset), (int)this.field_4_lid);
        LittleEndian.putUShort((byte[])data, (int)(8 + offset), (int)this.field_5_pnNext);
        LittleEndian.putShort((byte[])data, (int)(10 + offset), (short)this.field_6_flags1);
        LittleEndian.putUShort((byte[])data, (int)(12 + offset), (int)this.field_7_nFibBack);
        LittleEndian.putInt((byte[])data, (int)(14 + offset), (int)this.field_8_lKey);
        data[18 + offset] = this.field_9_envr;
        data[19 + offset] = this.field_10_flags2;
        LittleEndian.putShort((byte[])data, (int)(20 + offset), (short)this.field_11_Chs);
        LittleEndian.putShort((byte[])data, (int)(22 + offset), (short)this.field_12_chsTables);
        LittleEndian.putInt((byte[])data, (int)(24 + offset), (int)this.field_13_fcMin);
        LittleEndian.putInt((byte[])data, (int)(28 + offset), (int)this.field_14_fcMac);
    }

    public byte[] serialize() {
        byte[] result = new byte[FibBaseAbstractType.getSize()];
        this.serialize(result, 0);
        return result;
    }

    public static int getSize() {
        return 32;
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("[FibBase]\n");
        builder.append("    .wIdent               = ");
        builder.append(" (").append(this.getWIdent()).append(" )\n");
        builder.append("    .nFib                 = ");
        builder.append(" (").append(this.getNFib()).append(" )\n");
        builder.append("    .unused               = ");
        builder.append(" (").append(this.getUnused()).append(" )\n");
        builder.append("    .lid                  = ");
        builder.append(" (").append(this.getLid()).append(" )\n");
        builder.append("    .pnNext               = ");
        builder.append(" (").append(this.getPnNext()).append(" )\n");
        builder.append("    .flags1               = ");
        builder.append(" (").append(this.getFlags1()).append(" )\n");
        builder.append("         .fDot                     = ").append(this.isFDot()).append('\n');
        builder.append("         .fGlsy                    = ").append(this.isFGlsy()).append('\n');
        builder.append("         .fComplex                 = ").append(this.isFComplex()).append('\n');
        builder.append("         .fHasPic                  = ").append(this.isFHasPic()).append('\n');
        builder.append("         .cQuickSaves              = ").append(this.getCQuickSaves()).append('\n');
        builder.append("         .fEncrypted               = ").append(this.isFEncrypted()).append('\n');
        builder.append("         .fWhichTblStm             = ").append(this.isFWhichTblStm()).append('\n');
        builder.append("         .fReadOnlyRecommended     = ").append(this.isFReadOnlyRecommended()).append('\n');
        builder.append("         .fWriteReservation        = ").append(this.isFWriteReservation()).append('\n');
        builder.append("         .fExtChar                 = ").append(this.isFExtChar()).append('\n');
        builder.append("         .fLoadOverride            = ").append(this.isFLoadOverride()).append('\n');
        builder.append("         .fFarEast                 = ").append(this.isFFarEast()).append('\n');
        builder.append("         .fObfuscated              = ").append(this.isFObfuscated()).append('\n');
        builder.append("    .nFibBack             = ");
        builder.append(" (").append(this.getNFibBack()).append(" )\n");
        builder.append("    .lKey                 = ");
        builder.append(" (").append(this.getLKey()).append(" )\n");
        builder.append("    .envr                 = ");
        builder.append(" (").append(this.getEnvr()).append(" )\n");
        builder.append("    .flags2               = ");
        builder.append(" (").append(this.getFlags2()).append(" )\n");
        builder.append("         .fMac                     = ").append(this.isFMac()).append('\n');
        builder.append("         .fEmptySpecial            = ").append(this.isFEmptySpecial()).append('\n');
        builder.append("         .fLoadOverridePage        = ").append(this.isFLoadOverridePage()).append('\n');
        builder.append("         .reserved1                = ").append(this.isReserved1()).append('\n');
        builder.append("         .reserved2                = ").append(this.isReserved2()).append('\n');
        builder.append("         .fSpare0                  = ").append(this.getFSpare0()).append('\n');
        builder.append("    .Chs                  = ");
        builder.append(" (").append(this.getChs()).append(" )\n");
        builder.append("    .chsTables            = ");
        builder.append(" (").append(this.getChsTables()).append(" )\n");
        builder.append("    .fcMin                = ");
        builder.append(" (").append(this.getFcMin()).append(" )\n");
        builder.append("    .fcMac                = ");
        builder.append(" (").append(this.getFcMac()).append(" )\n");
        builder.append("[/FibBase]\n");
        return builder.toString();
    }

    public int getWIdent() {
        return this.field_1_wIdent;
    }

    public void setWIdent(int field_1_wIdent) {
        this.field_1_wIdent = field_1_wIdent;
    }

    public int getNFib() {
        return this.field_2_nFib;
    }

    public void setNFib(int field_2_nFib) {
        this.field_2_nFib = field_2_nFib;
    }

    public int getUnused() {
        return this.field_3_unused;
    }

    public void setUnused(int field_3_unused) {
        this.field_3_unused = field_3_unused;
    }

    public int getLid() {
        return this.field_4_lid;
    }

    public void setLid(int field_4_lid) {
        this.field_4_lid = field_4_lid;
    }

    public int getPnNext() {
        return this.field_5_pnNext;
    }

    public void setPnNext(int field_5_pnNext) {
        this.field_5_pnNext = field_5_pnNext;
    }

    public short getFlags1() {
        return this.field_6_flags1;
    }

    public void setFlags1(short field_6_flags1) {
        this.field_6_flags1 = field_6_flags1;
    }

    public int getNFibBack() {
        return this.field_7_nFibBack;
    }

    public void setNFibBack(int field_7_nFibBack) {
        this.field_7_nFibBack = field_7_nFibBack;
    }

    public int getLKey() {
        return this.field_8_lKey;
    }

    public void setLKey(int field_8_lKey) {
        this.field_8_lKey = field_8_lKey;
    }

    public byte getEnvr() {
        return this.field_9_envr;
    }

    public void setEnvr(byte field_9_envr) {
        this.field_9_envr = field_9_envr;
    }

    public byte getFlags2() {
        return this.field_10_flags2;
    }

    public void setFlags2(byte field_10_flags2) {
        this.field_10_flags2 = field_10_flags2;
    }

    public short getChs() {
        return this.field_11_Chs;
    }

    public void setChs(short field_11_Chs) {
        this.field_11_Chs = field_11_Chs;
    }

    public short getChsTables() {
        return this.field_12_chsTables;
    }

    public void setChsTables(short field_12_chsTables) {
        this.field_12_chsTables = field_12_chsTables;
    }

    public int getFcMin() {
        return this.field_13_fcMin;
    }

    public void setFcMin(int field_13_fcMin) {
        this.field_13_fcMin = field_13_fcMin;
    }

    public int getFcMac() {
        return this.field_14_fcMac;
    }

    public void setFcMac(int field_14_fcMac) {
        this.field_14_fcMac = field_14_fcMac;
    }

    public void setFDot(boolean value) {
        this.field_6_flags1 = (short)fDot.setBoolean((int)this.field_6_flags1, value);
    }

    public boolean isFDot() {
        return fDot.isSet((int)this.field_6_flags1);
    }

    public void setFGlsy(boolean value) {
        this.field_6_flags1 = (short)fGlsy.setBoolean((int)this.field_6_flags1, value);
    }

    public boolean isFGlsy() {
        return fGlsy.isSet((int)this.field_6_flags1);
    }

    public void setFComplex(boolean value) {
        this.field_6_flags1 = (short)fComplex.setBoolean((int)this.field_6_flags1, value);
    }

    public boolean isFComplex() {
        return fComplex.isSet((int)this.field_6_flags1);
    }

    public void setFHasPic(boolean value) {
        this.field_6_flags1 = (short)fHasPic.setBoolean((int)this.field_6_flags1, value);
    }

    public boolean isFHasPic() {
        return fHasPic.isSet((int)this.field_6_flags1);
    }

    public void setCQuickSaves(byte value) {
        this.field_6_flags1 = (short)cQuickSaves.setValue((int)this.field_6_flags1, (int)value);
    }

    public byte getCQuickSaves() {
        return (byte)cQuickSaves.getValue((int)this.field_6_flags1);
    }

    public void setFEncrypted(boolean value) {
        this.field_6_flags1 = (short)fEncrypted.setBoolean((int)this.field_6_flags1, value);
    }

    public boolean isFEncrypted() {
        return fEncrypted.isSet((int)this.field_6_flags1);
    }

    public void setFWhichTblStm(boolean value) {
        this.field_6_flags1 = (short)fWhichTblStm.setBoolean((int)this.field_6_flags1, value);
    }

    public boolean isFWhichTblStm() {
        return fWhichTblStm.isSet((int)this.field_6_flags1);
    }

    public void setFReadOnlyRecommended(boolean value) {
        this.field_6_flags1 = (short)fReadOnlyRecommended.setBoolean((int)this.field_6_flags1, value);
    }

    public boolean isFReadOnlyRecommended() {
        return fReadOnlyRecommended.isSet((int)this.field_6_flags1);
    }

    public void setFWriteReservation(boolean value) {
        this.field_6_flags1 = (short)fWriteReservation.setBoolean((int)this.field_6_flags1, value);
    }

    public boolean isFWriteReservation() {
        return fWriteReservation.isSet((int)this.field_6_flags1);
    }

    public void setFExtChar(boolean value) {
        this.field_6_flags1 = (short)fExtChar.setBoolean((int)this.field_6_flags1, value);
    }

    public boolean isFExtChar() {
        return fExtChar.isSet((int)this.field_6_flags1);
    }

    public void setFLoadOverride(boolean value) {
        this.field_6_flags1 = (short)fLoadOverride.setBoolean((int)this.field_6_flags1, value);
    }

    public boolean isFLoadOverride() {
        return fLoadOverride.isSet((int)this.field_6_flags1);
    }

    public void setFFarEast(boolean value) {
        this.field_6_flags1 = (short)fFarEast.setBoolean((int)this.field_6_flags1, value);
    }

    public boolean isFFarEast() {
        return fFarEast.isSet((int)this.field_6_flags1);
    }

    public void setFObfuscated(boolean value) {
        this.field_6_flags1 = (short)fObfuscated.setBoolean((int)this.field_6_flags1, value);
    }

    public boolean isFObfuscated() {
        return fObfuscated.isSet((int)this.field_6_flags1);
    }

    public void setFMac(boolean value) {
        this.field_10_flags2 = (byte)fMac.setBoolean((int)this.field_10_flags2, value);
    }

    public boolean isFMac() {
        return fMac.isSet((int)this.field_10_flags2);
    }

    public void setFEmptySpecial(boolean value) {
        this.field_10_flags2 = (byte)fEmptySpecial.setBoolean((int)this.field_10_flags2, value);
    }

    public boolean isFEmptySpecial() {
        return fEmptySpecial.isSet((int)this.field_10_flags2);
    }

    public void setFLoadOverridePage(boolean value) {
        this.field_10_flags2 = (byte)fLoadOverridePage.setBoolean((int)this.field_10_flags2, value);
    }

    public boolean isFLoadOverridePage() {
        return fLoadOverridePage.isSet((int)this.field_10_flags2);
    }

    public void setReserved1(boolean value) {
        this.field_10_flags2 = (byte)reserved1.setBoolean((int)this.field_10_flags2, value);
    }

    public boolean isReserved1() {
        return reserved1.isSet((int)this.field_10_flags2);
    }

    public void setReserved2(boolean value) {
        this.field_10_flags2 = (byte)reserved2.setBoolean((int)this.field_10_flags2, value);
    }

    public boolean isReserved2() {
        return reserved2.isSet((int)this.field_10_flags2);
    }

    public void setFSpare0(byte value) {
        this.field_10_flags2 = (byte)fSpare0.setValue((int)this.field_10_flags2, (int)value);
    }

    public byte getFSpare0() {
        return (byte)fSpare0.getValue((int)this.field_10_flags2);
    }
}

