/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model.types;

import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public abstract class FSPAAbstractType {
    protected int field_1_spid;
    protected int field_2_xaLeft;
    protected int field_3_yaTop;
    protected int field_4_xaRight;
    protected int field_5_yaBottom;
    protected short field_6_flags;
    private static BitField fHdr = new BitField(1);
    private static BitField bx = new BitField(6);
    private static BitField by = new BitField(24);
    private static BitField wr = new BitField(480);
    private static BitField wrk = new BitField(7680);
    private static BitField fRcaSimple = new BitField(8192);
    private static BitField fBelowText = new BitField(16384);
    private static BitField fAnchorLock = new BitField(32768);
    protected int field_7_cTxbx;

    protected FSPAAbstractType() {
    }

    protected void fillFields(byte[] data, int offset) {
        this.field_1_spid = LittleEndian.getInt((byte[])data, (int)(0 + offset));
        this.field_2_xaLeft = LittleEndian.getInt((byte[])data, (int)(4 + offset));
        this.field_3_yaTop = LittleEndian.getInt((byte[])data, (int)(8 + offset));
        this.field_4_xaRight = LittleEndian.getInt((byte[])data, (int)(12 + offset));
        this.field_5_yaBottom = LittleEndian.getInt((byte[])data, (int)(16 + offset));
        this.field_6_flags = LittleEndian.getShort((byte[])data, (int)(20 + offset));
        this.field_7_cTxbx = LittleEndian.getInt((byte[])data, (int)(22 + offset));
    }

    public void serialize(byte[] data, int offset) {
        LittleEndian.putInt((byte[])data, (int)(0 + offset), (int)this.field_1_spid);
        LittleEndian.putInt((byte[])data, (int)(4 + offset), (int)this.field_2_xaLeft);
        LittleEndian.putInt((byte[])data, (int)(8 + offset), (int)this.field_3_yaTop);
        LittleEndian.putInt((byte[])data, (int)(12 + offset), (int)this.field_4_xaRight);
        LittleEndian.putInt((byte[])data, (int)(16 + offset), (int)this.field_5_yaBottom);
        LittleEndian.putShort((byte[])data, (int)(20 + offset), (short)this.field_6_flags);
        LittleEndian.putInt((byte[])data, (int)(22 + offset), (int)this.field_7_cTxbx);
    }

    public static int getSize() {
        return 26;
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("[FSPA]\n");
        builder.append("    .spid                 = ");
        builder.append(" (").append(this.getSpid()).append(" )\n");
        builder.append("    .xaLeft               = ");
        builder.append(" (").append(this.getXaLeft()).append(" )\n");
        builder.append("    .yaTop                = ");
        builder.append(" (").append(this.getYaTop()).append(" )\n");
        builder.append("    .xaRight              = ");
        builder.append(" (").append(this.getXaRight()).append(" )\n");
        builder.append("    .yaBottom             = ");
        builder.append(" (").append(this.getYaBottom()).append(" )\n");
        builder.append("    .flags                = ");
        builder.append(" (").append(this.getFlags()).append(" )\n");
        builder.append("         .fHdr                     = ").append(this.isFHdr()).append('\n');
        builder.append("         .bx                       = ").append(this.getBx()).append('\n');
        builder.append("         .by                       = ").append(this.getBy()).append('\n');
        builder.append("         .wr                       = ").append(this.getWr()).append('\n');
        builder.append("         .wrk                      = ").append(this.getWrk()).append('\n');
        builder.append("         .fRcaSimple               = ").append(this.isFRcaSimple()).append('\n');
        builder.append("         .fBelowText               = ").append(this.isFBelowText()).append('\n');
        builder.append("         .fAnchorLock              = ").append(this.isFAnchorLock()).append('\n');
        builder.append("    .cTxbx                = ");
        builder.append(" (").append(this.getCTxbx()).append(" )\n");
        builder.append("[/FSPA]\n");
        return builder.toString();
    }

    public int getSpid() {
        return this.field_1_spid;
    }

    public void setSpid(int field_1_spid) {
        this.field_1_spid = field_1_spid;
    }

    public int getXaLeft() {
        return this.field_2_xaLeft;
    }

    public void setXaLeft(int field_2_xaLeft) {
        this.field_2_xaLeft = field_2_xaLeft;
    }

    public int getYaTop() {
        return this.field_3_yaTop;
    }

    public void setYaTop(int field_3_yaTop) {
        this.field_3_yaTop = field_3_yaTop;
    }

    public int getXaRight() {
        return this.field_4_xaRight;
    }

    public void setXaRight(int field_4_xaRight) {
        this.field_4_xaRight = field_4_xaRight;
    }

    public int getYaBottom() {
        return this.field_5_yaBottom;
    }

    public void setYaBottom(int field_5_yaBottom) {
        this.field_5_yaBottom = field_5_yaBottom;
    }

    public short getFlags() {
        return this.field_6_flags;
    }

    public void setFlags(short field_6_flags) {
        this.field_6_flags = field_6_flags;
    }

    public int getCTxbx() {
        return this.field_7_cTxbx;
    }

    public void setCTxbx(int field_7_cTxbx) {
        this.field_7_cTxbx = field_7_cTxbx;
    }

    public void setFHdr(boolean value) {
        this.field_6_flags = (short)fHdr.setBoolean((int)this.field_6_flags, value);
    }

    public boolean isFHdr() {
        return fHdr.isSet((int)this.field_6_flags);
    }

    public void setBx(byte value) {
        this.field_6_flags = (short)bx.setValue((int)this.field_6_flags, (int)value);
    }

    public byte getBx() {
        return (byte)bx.getValue((int)this.field_6_flags);
    }

    public void setBy(byte value) {
        this.field_6_flags = (short)by.setValue((int)this.field_6_flags, (int)value);
    }

    public byte getBy() {
        return (byte)by.getValue((int)this.field_6_flags);
    }

    public void setWr(byte value) {
        this.field_6_flags = (short)wr.setValue((int)this.field_6_flags, (int)value);
    }

    public byte getWr() {
        return (byte)wr.getValue((int)this.field_6_flags);
    }

    public void setWrk(byte value) {
        this.field_6_flags = (short)wrk.setValue((int)this.field_6_flags, (int)value);
    }

    public byte getWrk() {
        return (byte)wrk.getValue((int)this.field_6_flags);
    }

    public void setFRcaSimple(boolean value) {
        this.field_6_flags = (short)fRcaSimple.setBoolean((int)this.field_6_flags, value);
    }

    public boolean isFRcaSimple() {
        return fRcaSimple.isSet((int)this.field_6_flags);
    }

    public void setFBelowText(boolean value) {
        this.field_6_flags = (short)fBelowText.setBoolean((int)this.field_6_flags, value);
    }

    public boolean isFBelowText() {
        return fBelowText.isSet((int)this.field_6_flags);
    }

    public void setFAnchorLock(boolean value) {
        this.field_6_flags = (short)fAnchorLock.setBoolean((int)this.field_6_flags, value);
    }

    public boolean isFAnchorLock() {
        return fAnchorLock.isSet((int)this.field_6_flags);
    }
}

