/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.poi.hwpf.model.SavedByEntry;
import org.apache.poi.hwpf.model.SttbUtils;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;

public final class SavedByTable {
    private SavedByEntry[] entries;

    public SavedByTable(byte[] tableStream, int offset, int size) {
        String[] strings = SttbUtils.readSttbSavedBy(tableStream, offset);
        int numEntries = strings.length / 2;
        this.entries = new SavedByEntry[numEntries];
        int i = 0;
        while (i < numEntries) {
            this.entries[i] = new SavedByEntry(strings[i * 2], strings[i * 2 + 1]);
            ++i;
        }
    }

    public List getEntries() {
        return Collections.unmodifiableList(Arrays.asList(this.entries));
    }

    public void writeTo(HWPFOutputStream tableStream) throws IOException {
        String[] toSave = new String[this.entries.length * 2];
        int counter = 0;
        int i = 0;
        while (i < this.entries.length) {
            SavedByEntry entry = this.entries[i];
            toSave[counter++] = entry.getUserName();
            toSave[counter++] = entry.getSaveLocation();
            ++i;
        }
        SttbUtils.writeSttbSavedBy(toSave, tableStream);
    }
}

