/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public abstract class PropertyNode
implements Comparable,
Cloneable {
    private static final POILogger _logger;
    protected Object _buf;
    private int _cpStart;
    private int _cpEnd;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hwpf.model.PropertyNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _logger = POILogFactory.getLogger((Class)clazz);
    }

    protected PropertyNode(int fcStart, int fcEnd, Object buf) {
        this._cpStart = fcStart;
        this._cpEnd = fcEnd;
        this._buf = buf;
        if (this._cpStart < 0) {
            _logger.log(POILogger.WARN, (Object)("A property claimed to start before zero, at " + this._cpStart + "! Resetting it to zero, and hoping for the best"));
            this._cpStart = 0;
        }
        if (this._cpEnd < this._cpStart) {
            _logger.log(POILogger.WARN, (Object)("A property claimed to end (" + this._cpEnd + ") before start! " + "Resetting end to start, and hoping for the best"));
            this._cpEnd = this._cpStart;
        }
    }

    public int getStart() {
        return this._cpStart;
    }

    public void setStart(int start) {
        this._cpStart = start;
    }

    public int getEnd() {
        return this._cpEnd;
    }

    public void setEnd(int end) {
        this._cpEnd = end;
    }

    public void adjustForDelete(int start, int length) {
        int end = start + length;
        if (this._cpEnd > start) {
            if (this._cpStart < end) {
                this._cpEnd = end >= this._cpEnd ? start : this._cpEnd - length;
                this._cpStart = Math.min(start, this._cpStart);
            } else {
                this._cpEnd -= length;
                this._cpStart -= length;
            }
        }
    }

    protected boolean limitsAreEqual(Object o) {
        return ((PropertyNode)o).getStart() == this._cpStart && ((PropertyNode)o).getEnd() == this._cpEnd;
    }

    public int hashCode() {
        return this._cpStart * 31 + this._buf.hashCode();
    }

    public boolean equals(Object o) {
        if (this.limitsAreEqual(o)) {
            Object testBuf = ((PropertyNode)o)._buf;
            if (testBuf instanceof byte[] && this._buf instanceof byte[]) {
                return Arrays.equals((byte[])testBuf, (byte[])this._buf);
            }
            return this._buf.equals(testBuf);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int compareTo(Object in_o) {
        PropertyNode o = (PropertyNode)in_o;
        int cpEnd = o.getEnd();
        if (this._cpEnd == cpEnd) {
            return 0;
        }
        if (this._cpEnd < cpEnd) {
            return -1;
        }
        return 1;
    }

    public static final class EndComparator
    implements Comparator {
        public static EndComparator instance = new EndComparator();

        public int compare(Object in_o1, Object in_o2) {
            int anotherVal;
            PropertyNode o1 = (PropertyNode)in_o1;
            PropertyNode o2 = (PropertyNode)in_o2;
            int thisVal = o1.getEnd();
            return thisVal < (anotherVal = o2.getEnd()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }

    public static final class StartComparator
    implements Comparator {
        public static StartComparator instance = new StartComparator();

        public int compare(Object in_o1, Object in_o2) {
            int anotherVal;
            PropertyNode o1 = (PropertyNode)in_o1;
            PropertyNode o2 = (PropertyNode)in_o2;
            int thisVal = o1.getStart();
            return thisVal < (anotherVal = o2.getStart()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }
}

