/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.Collections;
import java.util.Iterator;
import org.apache.poi.hwpf.model.CHPBinTable;
import org.apache.poi.hwpf.model.CHPFormattedDiskPage;
import org.apache.poi.hwpf.model.CHPX;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.PropertyNode;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.util.LittleEndian;

public final class OldCHPBinTable
extends CHPBinTable {
    public OldCHPBinTable(byte[] documentStream, int offset, int size, int fcMin, TextPieceTable tpt) {
        PlexOfCps binTable = new PlexOfCps(documentStream, offset, size, 2);
        int length = binTable.length();
        int x = 0;
        while (x < length) {
            GenericPropertyNode node = binTable.getProperty(x);
            int pageNum = LittleEndian.getUShort((byte[])node.getBytes());
            int pageOffset = 512 * pageNum;
            CHPFormattedDiskPage cfkp = new CHPFormattedDiskPage(documentStream, pageOffset, tpt);
            Iterator iterator = cfkp.getCHPXs().iterator();
            while (iterator.hasNext()) {
                CHPX chpx = (CHPX)iterator.next();
                if (chpx == null) continue;
                this._textRuns.add(chpx);
            }
            ++x;
        }
        Collections.sort(this._textRuns, PropertyNode.StartComparator.instance);
    }
}

