/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.hwpf.model.CHPFormattedDiskPage;
import org.apache.poi.hwpf.model.CHPX;
import org.apache.poi.hwpf.model.CharIndexTranslator;
import org.apache.poi.hwpf.model.ComplexFileTable;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.PropertyModifier;
import org.apache.poi.hwpf.model.PropertyNode;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.hwpf.model.io.HWPFFileSystem;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.hwpf.sprm.SprmBuffer;
import org.apache.poi.hwpf.sprm.SprmIterator;
import org.apache.poi.hwpf.sprm.SprmOperation;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class CHPBinTable {
    private static final POILogger logger;
    protected ArrayList _textRuns = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hwpf.model.CHPBinTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = POILogFactory.getLogger((Class)clazz);
    }

    public CHPBinTable() {
    }

    public CHPBinTable(byte[] documentStream, byte[] tableStream, int offset, int size, int fcMin, TextPieceTable tpt) {
        this(documentStream, tableStream, offset, size, tpt);
    }

    public CHPBinTable(byte[] documentStream, byte[] tableStream, int offset, int size, CharIndexTranslator translator) {
        long start = System.currentTimeMillis();
        PlexOfCps bte = new PlexOfCps(tableStream, offset, size, 4);
        int length = bte.length();
        int x = 0;
        while (x < length) {
            GenericPropertyNode node = bte.getProperty(x);
            int pageNum = LittleEndian.getInt((byte[])node.getBytes());
            int pageOffset = 512 * pageNum;
            CHPFormattedDiskPage cfkp = new CHPFormattedDiskPage(documentStream, pageOffset, translator);
            Iterator iterator = cfkp.getCHPXs().iterator();
            while (iterator.hasNext()) {
                CHPX chpx = (CHPX)iterator.next();
                if (chpx == null) continue;
                this._textRuns.add(chpx);
            }
            ++x;
        }
        logger.log(POILogger.DEBUG, (Object)"CHPX FKPs loaded in ", (Object)new Long(System.currentTimeMillis() - start), (Object)" ms (", (Object)new Integer(this._textRuns.size()), (Object)" elements)");
        if (this._textRuns.isEmpty()) {
            logger.log(POILogger.WARN, (Object)"CHPX FKPs are empty");
            this._textRuns.add(new CHPX(0, 0, new SprmBuffer(0)));
        }
    }

    public void rebuild(ComplexFileTable complexFileTable) {
        Object iterator;
        long start = System.currentTimeMillis();
        if (complexFileTable != null) {
            SprmBuffer[] sprmBuffers = complexFileTable.getGrpprls();
            Iterator iterator2 = complexFileTable.getTextPieceTable().getTextPieces().iterator();
            while (iterator2.hasNext()) {
                SprmBuffer newSprmBuffer;
                TextPiece textPiece = (TextPiece)iterator2.next();
                PropertyModifier prm = textPiece.getPieceDescriptor().getPrm();
                if (!prm.isComplex()) continue;
                short igrpprl = prm.getIgrpprl();
                if (igrpprl < 0 || igrpprl >= sprmBuffers.length) {
                    logger.log(POILogger.WARN, (Object)(textPiece + "'s PRM references to unknown grpprl"));
                    continue;
                }
                boolean hasChp = false;
                SprmBuffer sprmBuffer = sprmBuffers[igrpprl];
                iterator = sprmBuffer.iterator();
                while (((SprmIterator)iterator).hasNext()) {
                    SprmOperation sprmOperation = ((SprmIterator)iterator).next();
                    if (sprmOperation.getType() != 2) continue;
                    hasChp = true;
                    break;
                }
                if (!hasChp) continue;
                try {
                    newSprmBuffer = (SprmBuffer)sprmBuffer.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new Error(e);
                }
                CHPX chpx = new CHPX(textPiece.getStart(), textPiece.getEnd(), newSprmBuffer);
                this._textRuns.add(chpx);
            }
            logger.log(POILogger.DEBUG, (Object)"Merged with CHPX from complex file table in ", (Object)new Long(System.currentTimeMillis() - start), (Object)" ms (", (Object)new Integer(this._textRuns.size()), (Object)" elements in total)");
            start = System.currentTimeMillis();
        }
        ArrayList oldChpxSortedByStartPos = new ArrayList(this._textRuns);
        Collections.sort(oldChpxSortedByStartPos, PropertyNode.StartComparator.instance);
        logger.log(POILogger.DEBUG, (Object)"CHPX sorted by start position in ", (Object)new Long(System.currentTimeMillis() - start), (Object)" ms");
        start = System.currentTimeMillis();
        final IdentityHashMap<CHPX, Integer> chpxToFileOrder = new IdentityHashMap<CHPX, Integer>();
        int counter = 0;
        Iterator iterator2 = this._textRuns.iterator();
        while (iterator2.hasNext()) {
            CHPX chpx = (CHPX)iterator2.next();
            chpxToFileOrder.put(chpx, new Integer(counter++));
        }
        Comparator chpxFileOrderComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer i1 = (Integer)chpxToFileOrder.get((CHPX)o1);
                Integer i2 = (Integer)chpxToFileOrder.get((CHPX)o2);
                return i1.compareTo(i2);
            }
        };
        logger.log(POILogger.DEBUG, (Object)"CHPX's order map created in ", (Object)new Long(System.currentTimeMillis() - start), (Object)" ms");
        start = System.currentTimeMillis();
        HashSet<Integer> textRunsBoundariesSet = new HashSet<Integer>();
        Iterator iterator3 = this._textRuns.iterator();
        while (iterator3.hasNext()) {
            CHPX chpx = (CHPX)iterator3.next();
            textRunsBoundariesSet.add(new Integer(chpx.getStart()));
            textRunsBoundariesSet.add(new Integer(chpx.getEnd()));
        }
        textRunsBoundariesSet.remove(new Integer(0));
        ArrayList textRunsBoundariesList = new ArrayList(textRunsBoundariesSet);
        Collections.sort(textRunsBoundariesList);
        logger.log(POILogger.DEBUG, (Object)"Texts CHPX boundaries collected in ", (Object)new Long(System.currentTimeMillis() - start), (Object)" ms");
        start = System.currentTimeMillis();
        LinkedList<CHPX> newChpxs = new LinkedList<CHPX>();
        int lastTextRunStart = 0;
        Iterator iterator4 = textRunsBoundariesList.iterator();
        while (iterator4.hasNext()) {
            CHPX existing;
            int endExclusive;
            Integer objBoundary = (Integer)iterator4.next();
            int boundary = objBoundary;
            int startInclusive = lastTextRunStart;
            lastTextRunStart = endExclusive = boundary;
            int startPosition = CHPBinTable.binarySearch(oldChpxSortedByStartPos, boundary);
            startPosition = Math.abs(startPosition);
            while (startPosition >= oldChpxSortedByStartPos.size()) {
                --startPosition;
            }
            while (startPosition > 0 && ((PropertyNode)oldChpxSortedByStartPos.get(startPosition)).getStart() >= boundary) {
                --startPosition;
            }
            LinkedList<CHPX> chpxs = new LinkedList<CHPX>();
            int c = startPosition;
            while (c < oldChpxSortedByStartPos.size()) {
                int right;
                CHPX chpx = (CHPX)oldChpxSortedByStartPos.get(c);
                if (boundary < chpx.getStart()) break;
                int left = Math.max(startInclusive, chpx.getStart());
                if (left < (right = Math.min(endExclusive, chpx.getEnd()))) {
                    chpxs.add(chpx);
                }
                ++c;
            }
            if (chpxs.size() == 0) {
                logger.log(POILogger.WARN, (Object)"Text piece [", (Object)new Integer(startInclusive), (Object)"; ", (Object)new Integer(endExclusive), (Object)") has no CHPX. Creating new one.");
                CHPX chpx = new CHPX(startInclusive, endExclusive, new SprmBuffer(0));
                newChpxs.add(chpx);
                continue;
            }
            if (chpxs.size() == 1 && (existing = (CHPX)chpxs.get(0)).getStart() == startInclusive && existing.getEnd() == endExclusive) {
                newChpxs.add(existing);
                continue;
            }
            Collections.sort(chpxs, chpxFileOrderComparator);
            SprmBuffer sprmBuffer = new SprmBuffer(0);
            Iterator iterator22 = chpxs.iterator();
            while (iterator22.hasNext()) {
                CHPX chpx = (CHPX)iterator22.next();
                sprmBuffer.append(chpx.getGrpprl(), 0);
            }
            CHPX newChpx = new CHPX(startInclusive, endExclusive, sprmBuffer);
            newChpxs.add(newChpx);
        }
        this._textRuns = new ArrayList(newChpxs);
        logger.log(POILogger.DEBUG, (Object)"CHPX rebuilded in ", (Object)new Long(System.currentTimeMillis() - start), (Object)" ms (", (Object)new Integer(this._textRuns.size()), (Object)" elements)");
        start = System.currentTimeMillis();
        CHPX previous = null;
        iterator = this._textRuns.iterator();
        while (iterator.hasNext()) {
            CHPX current = (CHPX)iterator.next();
            if (previous == null) {
                previous = current;
                continue;
            }
            if (previous.getEnd() == current.getStart() && Arrays.equals(previous.getGrpprl(), current.getGrpprl())) {
                previous.setEnd(current.getEnd());
                iterator.remove();
                continue;
            }
            previous = current;
        }
        logger.log(POILogger.DEBUG, (Object)"CHPX compacted in ", (Object)new Long(System.currentTimeMillis() - start), (Object)" ms (", (Object)new Integer(this._textRuns.size()), (Object)" elements)");
    }

    private static int binarySearch(List chpxs, int startPosition) {
        int low = 0;
        int high = chpxs.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            CHPX midVal = (CHPX)chpxs.get(mid);
            int midValue = midVal.getStart();
            if (midValue < startPosition) {
                low = mid + 1;
                continue;
            }
            if (midValue > startPosition) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void adjustForDelete(int listIndex, int offset, int length) {
        int x;
        int size = this._textRuns.size();
        int endMark = offset + length;
        int endIndex = listIndex;
        CHPX chpx = (CHPX)this._textRuns.get(endIndex);
        while (chpx.getEnd() < endMark) {
            chpx = (CHPX)this._textRuns.get(++endIndex);
        }
        if (listIndex == endIndex) {
            chpx = (CHPX)this._textRuns.get(endIndex);
            chpx.setEnd(chpx.getEnd() - endMark + offset);
        } else {
            chpx = (CHPX)this._textRuns.get(listIndex);
            chpx.setEnd(offset);
            x = listIndex + 1;
            while (x < endIndex) {
                chpx = (CHPX)this._textRuns.get(x);
                chpx.setStart(offset);
                chpx.setEnd(offset);
                ++x;
            }
            chpx = (CHPX)this._textRuns.get(endIndex);
            chpx.setEnd(chpx.getEnd() - endMark + offset);
        }
        x = endIndex + 1;
        while (x < size) {
            chpx = (CHPX)this._textRuns.get(x);
            chpx.setStart(chpx.getStart() - length);
            chpx.setEnd(chpx.getEnd() - length);
            ++x;
        }
    }

    public void insert(int listIndex, int cpStart, SprmBuffer buf) {
        CHPX insertChpx = new CHPX(0, 0, buf);
        insertChpx.setStart(cpStart);
        insertChpx.setEnd(cpStart);
        if (listIndex == this._textRuns.size()) {
            this._textRuns.add(insertChpx);
        } else {
            CHPX chpx = (CHPX)this._textRuns.get(listIndex);
            if (chpx.getStart() < cpStart) {
                CHPX clone = new CHPX(0, 0, chpx.getSprmBuf());
                clone.setStart(cpStart);
                clone.setEnd(chpx.getEnd());
                chpx.setEnd(cpStart);
                this._textRuns.add(listIndex + 1, insertChpx);
                this._textRuns.add(listIndex + 2, clone);
            } else {
                this._textRuns.add(listIndex, insertChpx);
            }
        }
    }

    public void adjustForInsert(int listIndex, int length) {
        int size = this._textRuns.size();
        CHPX chpx = (CHPX)this._textRuns.get(listIndex);
        chpx.setEnd(chpx.getEnd() + length);
        int x = listIndex + 1;
        while (x < size) {
            chpx = (CHPX)this._textRuns.get(x);
            chpx.setStart(chpx.getStart() + length);
            chpx.setEnd(chpx.getEnd() + length);
            ++x;
        }
    }

    public List getTextRuns() {
        return this._textRuns;
    }

    public void writeTo(HWPFFileSystem sys, int fcMin, CharIndexTranslator translator) throws IOException {
        HWPFOutputStream docStream = sys.getStream("WordDocument");
        HWPFOutputStream tableStream = sys.getStream("1Table");
        this.writeTo(docStream, tableStream, fcMin, translator);
    }

    public void writeTo(HWPFOutputStream wordDocumentStream, HWPFOutputStream tableStream, int fcMin, CharIndexTranslator translator) throws IOException {
        PlexOfCps bte = new PlexOfCps(4);
        int docOffset = wordDocumentStream.getOffset();
        int mod = docOffset % 512;
        if (mod != 0) {
            byte[] padding = new byte[512 - mod];
            wordDocumentStream.write(padding);
        }
        docOffset = wordDocumentStream.getOffset();
        int pageNum = docOffset / 512;
        int endingFc = translator.getByteIndex(((PropertyNode)this._textRuns.get(this._textRuns.size() - 1)).getEnd());
        ArrayList overflow = this._textRuns;
        do {
            CHPX startingProp = (CHPX)overflow.get(0);
            int start = translator.getByteIndex(startingProp.getStart());
            CHPFormattedDiskPage cfkp = new CHPFormattedDiskPage();
            cfkp.fill(overflow);
            byte[] bufFkp = cfkp.toByteArray(translator);
            wordDocumentStream.write(bufFkp);
            overflow = cfkp.getOverflow();
            int end = endingFc;
            if (overflow != null) {
                end = translator.getByteIndex(((PropertyNode)overflow.get(0)).getStart());
            }
            byte[] intHolder = new byte[4];
            LittleEndian.putInt((byte[])intHolder, (int)pageNum++);
            bte.addProperty(new GenericPropertyNode(start, end, intHolder));
        } while (overflow != null);
        tableStream.write(bte.toByteArray());
    }
}

