/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.ChunkGroup;
import org.apache.poi.hsmf.datatypes.Chunks;
import org.apache.poi.hsmf.datatypes.DirectoryChunk;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.MessageSubmissionChunk;
import org.apache.poi.hsmf.datatypes.NameIdChunks;
import org.apache.poi.hsmf.datatypes.RecipientChunks;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.hsmf.datatypes.Types;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class POIFSChunkParser {
    public static ChunkGroup[] parse(POIFSFileSystem fs) throws IOException {
        return POIFSChunkParser.parse(fs.getRoot());
    }

    public static ChunkGroup[] parse(DirectoryNode node) throws IOException {
        Chunks mainChunks = new Chunks();
        ArrayList<ChunkGroup> groups = new ArrayList<ChunkGroup>();
        groups.add(mainChunks);
        Iterator iterator = node.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (!(entry instanceof DirectoryNode)) continue;
            DirectoryNode dir = (DirectoryNode)entry;
            ChunkGroup group = null;
            if (dir.getName().startsWith("__attach_version1.0_#")) {
                group = new AttachmentChunks(dir.getName());
            }
            if (dir.getName().startsWith("__nameid_version1.0")) {
                group = new NameIdChunks();
            }
            if (dir.getName().startsWith("__recip_version1.0_#")) {
                group = new RecipientChunks(dir.getName());
            }
            if (group == null) continue;
            POIFSChunkParser.processChunks(dir, group);
            groups.add(group);
        }
        POIFSChunkParser.processChunks(node, mainChunks);
        return groups.toArray(new ChunkGroup[groups.size()]);
    }

    protected static void processChunks(DirectoryNode node, ChunkGroup grouping) {
        Iterator iterator = node.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry instanceof DocumentNode) {
                POIFSChunkParser.process(entry, grouping);
                continue;
            }
            if (!(entry instanceof DirectoryNode) || !entry.getName().endsWith(Types.asFileEnding(13))) continue;
            POIFSChunkParser.process(entry, grouping);
        }
    }

    protected static void process(Entry entry, ChunkGroup grouping) {
        String entryName = entry.getName();
        if (entryName.length() < 9) {
            return;
        }
        if (entryName.indexOf(95) == -1) {
            return;
        }
        int splitAt = entryName.lastIndexOf(95);
        String namePrefix = entryName.substring(0, splitAt + 1);
        String ids = entryName.substring(splitAt + 1);
        if (namePrefix.equals("Olk10SideProps") || namePrefix.equals("Olk10SideProps_")) {
            return;
        }
        if (splitAt > entryName.length() - 8) {
            throw new IllegalArgumentException("Invalid chunk name " + entryName);
        }
        try {
            int chunkId = Integer.parseInt(ids.substring(0, 4), 16);
            int type = Integer.parseInt(ids.substring(4, 8), 16);
            Chunk chunk = null;
            if (chunkId == MAPIProperty.MESSAGE_SUBMISSION_ID.id) {
                chunk = new MessageSubmissionChunk(namePrefix, chunkId, type);
            } else {
                switch (type) {
                    case 258: {
                        chunk = new ByteChunk(namePrefix, chunkId, type);
                        break;
                    }
                    case 13: {
                        if (!(entry instanceof DirectoryNode)) break;
                        chunk = new DirectoryChunk((DirectoryNode)entry, namePrefix, chunkId, type);
                        break;
                    }
                    case 30: 
                    case 31: {
                        chunk = new StringChunk(namePrefix, chunkId, type);
                    }
                }
            }
            if (chunk != null) {
                if (entry instanceof DocumentNode) {
                    try {
                        DocumentInputStream inp = new DocumentInputStream((DocumentEntry)((DocumentNode)entry));
                        chunk.readValue((InputStream)inp);
                        grouping.record(chunk);
                    }
                    catch (IOException e) {
                        System.err.println("Error reading from part " + entry.getName() + " - " + e.toString());
                    }
                } else {
                    grouping.record(chunk);
                }
            }
        }
        catch (NumberFormatException e) {
            return;
        }
    }
}

