/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model.textproperties;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import org.apache.poi.hslf.model.textproperties.BitMaskTextProp;
import org.apache.poi.hslf.model.textproperties.TextProp;
import org.apache.poi.hslf.record.StyleTextPropAtom;
import org.apache.poi.util.LittleEndian;

public class TextPropCollection {
    private int charactersCovered;
    private short reservedField;
    private LinkedList textPropList;
    private int maskSpecial = 0;

    public int getSpecialMask() {
        return this.maskSpecial;
    }

    public int getCharactersCovered() {
        return this.charactersCovered;
    }

    public LinkedList getTextPropList() {
        return this.textPropList;
    }

    public TextProp findByName(String textPropName) {
        int i = 0;
        while (i < this.textPropList.size()) {
            TextProp prop = (TextProp)this.textPropList.get(i);
            if (prop.getName().equals(textPropName)) {
                return prop;
            }
            ++i;
        }
        return null;
    }

    public TextProp addWithName(String name) {
        TextProp base = null;
        int i = 0;
        while (i < StyleTextPropAtom.characterTextPropTypes.length) {
            if (StyleTextPropAtom.characterTextPropTypes[i].getName().equals(name)) {
                base = StyleTextPropAtom.characterTextPropTypes[i];
            }
            ++i;
        }
        i = 0;
        while (i < StyleTextPropAtom.paragraphTextPropTypes.length) {
            if (StyleTextPropAtom.paragraphTextPropTypes[i].getName().equals(name)) {
                base = StyleTextPropAtom.paragraphTextPropTypes[i];
            }
            ++i;
        }
        if (base == null) {
            throw new IllegalArgumentException("No TextProp with name " + name + " is defined to add from");
        }
        TextProp textProp = (TextProp)base.clone();
        int pos = 0;
        int i2 = 0;
        while (i2 < this.textPropList.size()) {
            TextProp curProp = (TextProp)this.textPropList.get(i2);
            if (textProp.getMask() > curProp.getMask()) {
                ++pos;
            }
            ++i2;
        }
        this.textPropList.add(pos, textProp);
        return textProp;
    }

    /*
     * Unable to fully structure code
     */
    public int buildTextPropList(int containsField, TextProp[] potentialProperties, byte[] data, int dataOffset) {
        bytesPassed = 0;
        i = 0;
        while (i < potentialProperties.length) {
            block4: {
                block6: {
                    block5: {
                        if ((containsField & potentialProperties[i].getMask()) == 0) break block4;
                        if (dataOffset + bytesPassed >= data.length) {
                            this.maskSpecial |= potentialProperties[i].getMask();
                            return bytesPassed;
                        }
                        prop = (TextProp)potentialProperties[i].clone();
                        val = 0;
                        if (prop.getSize() != 2) break block5;
                        val = LittleEndian.getShort((byte[])data, (int)(dataOffset + bytesPassed));
                        ** GOTO lbl-1000
                    }
                    if (prop.getSize() != 4) break block6;
                    val = LittleEndian.getInt((byte[])data, (int)(dataOffset + bytesPassed));
                    ** GOTO lbl-1000
                }
                if (prop.getSize() == 0) {
                    this.maskSpecial |= potentialProperties[i].getMask();
                } else lbl-1000:
                // 3 sources

                {
                    prop.setValue(val);
                    bytesPassed += prop.getSize();
                    this.textPropList.add(prop);
                }
            }
            ++i;
        }
        return bytesPassed;
    }

    public TextPropCollection(int charactersCovered, short reservedField) {
        this.charactersCovered = charactersCovered;
        this.reservedField = reservedField;
        this.textPropList = new LinkedList();
    }

    public TextPropCollection(int textSize) {
        this.charactersCovered = textSize;
        this.reservedField = (short)-1;
        this.textPropList = new LinkedList();
    }

    public void updateTextSize(int textSize) {
        this.charactersCovered = textSize;
    }

    public void writeOut(OutputStream o) throws IOException {
        TextProp textProp;
        StyleTextPropAtom.writeLittleEndian(this.charactersCovered, o);
        if (this.reservedField > -1) {
            StyleTextPropAtom.writeLittleEndian(this.reservedField, o);
        }
        int mask = this.maskSpecial;
        int i = 0;
        while (i < this.textPropList.size()) {
            textProp = (TextProp)this.textPropList.get(i);
            if (textProp instanceof BitMaskTextProp) {
                if (mask == 0) {
                    mask |= textProp.getWriteMask();
                }
            } else {
                mask |= textProp.getWriteMask();
            }
            ++i;
        }
        StyleTextPropAtom.writeLittleEndian(mask, o);
        i = 0;
        while (i < this.textPropList.size()) {
            textProp = (TextProp)this.textPropList.get(i);
            int val = textProp.getValue();
            if (textProp.getSize() == 2) {
                StyleTextPropAtom.writeLittleEndian((short)val, o);
            } else if (textProp.getSize() == 4) {
                StyleTextPropAtom.writeLittleEndian(val, o);
            }
            ++i;
        }
    }

    public short getReservedField() {
        return this.reservedField;
    }

    public void setReservedField(short val) {
        this.reservedField = val;
    }
}

