/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.geom.Point2D;
import org.apache.poi.ddf.EscherArrayProperty;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.hslf.model.AutoShape;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.ShapeGroup;
import org.apache.poi.util.LittleEndian;

public final class Polygon
extends AutoShape {
    protected Polygon(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    public Polygon(Shape parent) {
        super(null, parent);
        this._escherContainer = this.createSpContainer(0, parent instanceof ShapeGroup);
    }

    public Polygon() {
        this(null);
    }

    public void setPoints(float[] xPoints, float[] yPoints) {
        float right = this.findBiggest(xPoints);
        float bottom = this.findBiggest(yPoints);
        float left = this.findSmallest(xPoints);
        float top = this.findSmallest(yPoints);
        EscherOptRecord opt = (EscherOptRecord)Polygon.getEscherChild(this._escherContainer, -4085);
        opt.addEscherProperty((EscherProperty)new EscherSimpleProperty(322, (int)((right - left) * 72.0f / 576.0f)));
        opt.addEscherProperty((EscherProperty)new EscherSimpleProperty(323, (int)((bottom - top) * 72.0f / 576.0f)));
        int i = 0;
        while (i < xPoints.length) {
            int n = i;
            xPoints[n] = xPoints[n] + -left;
            int n2 = i++;
            yPoints[n2] = yPoints[n2] + -top;
        }
        int numpoints = xPoints.length;
        EscherArrayProperty verticesProp = new EscherArrayProperty(325, false, new byte[0]);
        verticesProp.setNumberOfElementsInArray(numpoints + 1);
        verticesProp.setNumberOfElementsInMemory(numpoints + 1);
        verticesProp.setSizeOfElements(65520);
        int i2 = 0;
        while (i2 < numpoints) {
            byte[] data = new byte[4];
            LittleEndian.putShort((byte[])data, (int)0, (short)((short)(xPoints[i2] * 72.0f / 576.0f)));
            LittleEndian.putShort((byte[])data, (int)2, (short)((short)(yPoints[i2] * 72.0f / 576.0f)));
            verticesProp.setElement(i2, data);
            ++i2;
        }
        byte[] data = new byte[4];
        LittleEndian.putShort((byte[])data, (int)0, (short)((short)(xPoints[0] * 72.0f / 576.0f)));
        LittleEndian.putShort((byte[])data, (int)2, (short)((short)(yPoints[0] * 72.0f / 576.0f)));
        verticesProp.setElement(numpoints, data);
        opt.addEscherProperty((EscherProperty)verticesProp);
        EscherArrayProperty segmentsProp = new EscherArrayProperty(326, false, null);
        segmentsProp.setSizeOfElements(2);
        segmentsProp.setNumberOfElementsInArray(numpoints * 2 + 4);
        segmentsProp.setNumberOfElementsInMemory(numpoints * 2 + 4);
        byte[] byArray = new byte[2];
        byArray[1] = 64;
        segmentsProp.setElement(0, byArray);
        byte[] byArray2 = new byte[2];
        byArray2[1] = -84;
        segmentsProp.setElement(1, byArray2);
        int i3 = 0;
        while (i3 < numpoints) {
            byte[] byArray3 = new byte[2];
            byArray3[0] = 1;
            segmentsProp.setElement(2 + i3 * 2, byArray3);
            byte[] byArray4 = new byte[2];
            byArray4[1] = -84;
            segmentsProp.setElement(3 + i3 * 2, byArray4);
            ++i3;
        }
        segmentsProp.setElement(segmentsProp.getNumberOfElementsInArray() - 2, new byte[]{1, 96});
        byte[] byArray5 = new byte[2];
        byArray5[1] = -128;
        segmentsProp.setElement(segmentsProp.getNumberOfElementsInArray() - 1, byArray5);
        opt.addEscherProperty((EscherProperty)segmentsProp);
        opt.sortProperties();
    }

    public void setPoints(Point2D[] points) {
        float[] xpoints = new float[points.length];
        float[] ypoints = new float[points.length];
        int i = 0;
        while (i < points.length) {
            xpoints[i] = (float)points[i].getX();
            ypoints[i] = (float)points[i].getY();
            ++i;
        }
        this.setPoints(xpoints, ypoints);
    }

    private float findBiggest(float[] values) {
        float result = Float.MIN_VALUE;
        int i = 0;
        while (i < values.length) {
            if (values[i] > result) {
                result = values[i];
            }
            ++i;
        }
        return result;
    }

    private float findSmallest(float[] values) {
        float result = Float.MAX_VALUE;
        int i = 0;
        while (i < values.length) {
            if (values[i] < result) {
                result = values[i];
            }
            ++i;
        }
        return result;
    }
}

