/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.dev;

import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.record.Document;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.SlideListWithText;
import org.apache.poi.hslf.record.SlidePersistAtom;
import org.apache.poi.hslf.record.TextBytesAtom;
import org.apache.poi.hslf.record.TextCharsAtom;

public final class SLWTTextListing {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Need to give a filename");
            System.exit(1);
        }
        HSLFSlideShow ss = new HSLFSlideShow(args[0]);
        Record[] records = ss.getRecords();
        int i = 0;
        while (i < records.length) {
            if (records[i] instanceof Document) {
                Record docRecord = records[i];
                Record[] docChildren = docRecord.getChildRecords();
                int j = 0;
                while (j < docChildren.length) {
                    if (docChildren[j] instanceof SlideListWithText) {
                        System.out.println("Found SLWT at pos " + j + " in the Document at " + i);
                        System.out.println("  Has " + docChildren[j].getChildRecords().length + " children");
                        SlideListWithText slwt = (SlideListWithText)docChildren[j];
                        SlideListWithText.SlideAtomsSet[] thisSets = slwt.getSlideAtomsSets();
                        System.out.println("  Has " + thisSets.length + " AtomSets in it");
                        int k = 0;
                        while (k < thisSets.length) {
                            SlidePersistAtom spa = thisSets[k].getSlidePersistAtom();
                            System.out.println("    " + k + " has slide id " + spa.getSlideIdentifier());
                            System.out.println("    " + k + " has ref id " + spa.getRefID());
                            Record[] slwtc = thisSets[k].getSlideRecords();
                            int l = 0;
                            while (l < slwtc.length) {
                                String text = null;
                                if (slwtc[l] instanceof TextBytesAtom) {
                                    TextBytesAtom tba = (TextBytesAtom)slwtc[l];
                                    text = tba.getText();
                                }
                                if (slwtc[l] instanceof TextCharsAtom) {
                                    TextCharsAtom tca = (TextCharsAtom)slwtc[l];
                                    text = tca.getText();
                                }
                                if (text != null) {
                                    text = text.replace('\r', '\n');
                                    System.out.println("        ''" + text + "''");
                                }
                                ++l;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

