/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.dev;

import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.record.EscherTextboxWrapper;
import org.apache.poi.hslf.record.PPDrawing;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.TextBytesAtom;
import org.apache.poi.hslf.record.TextCharsAtom;

public final class PPDrawingTextListing {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Need to give a filename");
            System.exit(1);
        }
        HSLFSlideShow ss = new HSLFSlideShow(args[0]);
        Record[] records = ss.getRecords();
        int i = 0;
        while (i < records.length) {
            Record[] children = records[i].getChildRecords();
            if (children != null && children.length != 0) {
                int j = 0;
                while (j < children.length) {
                    if (children[j] instanceof PPDrawing) {
                        System.out.println("Found PPDrawing at " + j + " in top level record " + i + " (" + records[i].getRecordType() + ")");
                        PPDrawing ppd = (PPDrawing)children[j];
                        EscherTextboxWrapper[] wrappers = ppd.getTextboxWrappers();
                        System.out.println("  Has " + wrappers.length + " textbox wrappers within");
                        int k = 0;
                        while (k < wrappers.length) {
                            EscherTextboxWrapper tbw = wrappers[k];
                            System.out.println("    " + k + " has " + tbw.getChildRecords().length + " PPT atoms within");
                            Record[] pptatoms = tbw.getChildRecords();
                            int l = 0;
                            while (l < pptatoms.length) {
                                String text = null;
                                if (pptatoms[l] instanceof TextBytesAtom) {
                                    TextBytesAtom tba = (TextBytesAtom)pptatoms[l];
                                    text = tba.getText();
                                }
                                if (pptatoms[l] instanceof TextCharsAtom) {
                                    TextCharsAtom tca = (TextCharsAtom)pptatoms[l];
                                    text = tca.getText();
                                }
                                if (text != null) {
                                    text = text.replace('\r', '\n');
                                    System.out.println("        ''" + text + "''");
                                }
                                ++l;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

