/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdf.extractor;

import org.apache.poi.hdf.extractor.Utils;

public final class FontTable {
    String[] fontNames;

    public FontTable(byte[] fontTable) {
        int size = Utils.convertBytesToShort(fontTable, 0);
        this.fontNames = new String[size];
        int currentIndex = 4;
        int x = 0;
        while (x < size) {
            byte ffnLength = fontTable[currentIndex];
            int nameOffset = currentIndex + 40;
            StringBuffer nameBuf = new StringBuffer();
            char ch = Utils.getUnicodeCharacter(fontTable, nameOffset);
            while (ch != '\u0000') {
                nameBuf.append(ch);
                ch = Utils.getUnicodeCharacter(fontTable, nameOffset += 2);
            }
            this.fontNames[x] = nameBuf.toString();
            if (this.fontNames[x].startsWith("Times")) {
                this.fontNames[x] = "Times";
            }
            currentIndex += ffnLength + 1;
            ++x;
        }
    }

    public String getFont(int index) {
        return this.fontNames[index];
    }
}

