/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */
package org.apache.poi.xslf.usermodel;

/**
 * @author Yegor Kozlov
 */
public class LineDash {

	public static final LineDash SOLID = new LineDash(0);
	public static final LineDash DOT = new LineDash(1);
	public static final LineDash DASH = new LineDash(2);
	public static final LineDash LG_DASH = new LineDash(3);
	public static final LineDash DASH_DOT = new LineDash(4);
	public static final LineDash LG_DASH_DOT = new LineDash(5);
	public static final LineDash LG_DASH_DOT_DOT = new LineDash(6);
	public static final LineDash SYS_DASH = new LineDash(7);
	public static final LineDash SYS_DOT = new LineDash(8);
	public static final LineDash SYS_DASH_DOT = new LineDash(9);
	public static final LineDash SYS_DASH_DOT_DOT = new LineDash(10);

	private int _ordinal;

	public LineDash(int ordinal) {
		this._ordinal = ordinal;
	}

	public int ordinal() {
		return this._ordinal;
	}

	public static LineDash[] values() {
		return new LineDash[] { SOLID, DOT, DASH, LG_DASH, DASH_DOT,
				LG_DASH_DOT, LG_DASH_DOT_DOT, SYS_DASH, SYS_DOT, SYS_DASH_DOT,
				SYS_DASH_DOT_DOT };
	}
}
