/*
 *  ====================================================================
 *    Licensed to the Apache Software Foundation (ASF) under one or more
 *    contributor license agreements.  See the NOTICE file distributed with
 *    this work for additional information regarding copyright ownership.
 *    The ASF licenses this file to You under the Apache License, Version 2.0
 *    (the "License"); you may not use this file except in compliance with
 *    the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 * ====================================================================
 */

package org.apache.poi.xslf.model.geom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.openxmlformats.schemas.drawingml.x2006.main.CTCustomGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomGuide;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomGuideList;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomRect;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DList;

import poi.support.Iterable;

/**
 * Definition of a custom geometric shape
 *
 * @author Yegor Kozlov
 */
public class CustomGeometry implements Iterable{
    List adjusts = new ArrayList();
    List guides = new ArrayList();
    List paths = new ArrayList();
    Path textBounds;

    public CustomGeometry(CTCustomGeometry2D geom) {
        CTGeomGuideList avLst = geom.getAvLst();
        if(avLst != null)
        	for (Iterator iterator = Arrays.asList(avLst.getGdArray()).iterator(); iterator.hasNext();) {
				CTGeomGuide gd = (CTGeomGuide) iterator.next();
        		adjusts.add(new AdjustValue(gd));
        	}

        CTGeomGuideList gdLst = geom.getGdLst();
        if(gdLst != null)
        	for (Iterator iterator = Arrays.asList(gdLst.getGdArray()).iterator(); iterator.hasNext();) {
				CTGeomGuide gd = (CTGeomGuide) iterator.next();
	            guides.add(new Guide(gd));
	        }

        CTPath2DList pathLst = geom.getPathLst();
        if(pathLst != null)
        	for (Iterator iterator = Arrays.asList(pathLst.getPathArray()).iterator(); iterator.hasNext();) {
				CTPath2D spPath = (CTPath2D) iterator.next();
        		paths.add(new Path(spPath));
        	}

        if(geom.isSetRect()) {
            CTGeomRect rect = geom.getRect();
            textBounds = new Path();
            textBounds.addCommand(
                    new MoveToCommand(rect.getL().toString(), rect.getT().toString()));
            textBounds.addCommand(
                    new LineToCommand(rect.getR().toString(), rect.getT().toString()));
            textBounds.addCommand(
                    new LineToCommand(rect.getR().toString(), rect.getB().toString()));
            textBounds.addCommand(
                    new LineToCommand(rect.getL().toString(), rect.getB().toString()));
            textBounds.addCommand(
                    new ClosePathCommand());
        }
    }



    public Iterator iterator() {
        return paths.iterator();
    }

    public Path getTextBounds(){
        return textBounds;
    }
}
