/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hwpf.model.ListFormatOverrideLevel;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.LittleEndian;

class LFOData {
    private int _cp;
    private ListFormatOverrideLevel[] _rgLfoLvl;

    LFOData(byte[] buf, int startOffset, int cLfolvl) {
        int offset = startOffset;
        this._cp = LittleEndian.getInt((byte[])buf, (int)offset);
        offset += 4;
        this._rgLfoLvl = new ListFormatOverrideLevel[cLfolvl];
        int x = 0;
        while (x < cLfolvl) {
            this._rgLfoLvl[x] = new ListFormatOverrideLevel(buf, offset);
            offset += this._rgLfoLvl[x].getSizeInBytes();
            ++x;
        }
    }

    int getCp() {
        return this._cp;
    }

    ListFormatOverrideLevel[] getRgLfoLvl() {
        return this._rgLfoLvl;
    }

    int getSizeInBytes() {
        int result = 0;
        result += 4;
        int i = 0;
        while (i < this._rgLfoLvl.length) {
            ListFormatOverrideLevel lfolvl = this._rgLfoLvl[i];
            result += lfolvl.getSizeInBytes();
            ++i;
        }
        return result;
    }

    void writeTo(HWPFOutputStream tableStream) throws IOException {
        LittleEndian.putInt((int)this._cp, (OutputStream)tableStream);
        int i = 0;
        while (i < this._rgLfoLvl.length) {
            ListFormatOverrideLevel lfolvl = this._rgLfoLvl[i];
            tableStream.write(lfolvl.toByteArray());
            ++i;
        }
    }
}

