/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.dev;

public class RecordUtil {
    public static String getBitFieldFunction(String name, String bitMask, String parentType, String withType) {
        String type = RecordUtil.getBitFieldType(name, bitMask, parentType);
        String retVal = new String();
        if (withType.equals("true")) {
            retVal = String.valueOf(type) + " ";
        }
        retVal = type.equals("boolean") ? String.valueOf(retVal) + "is" + RecordUtil.getFieldName1stCap(name, 0) : String.valueOf(retVal) + "get" + RecordUtil.getFieldName1stCap(name, 0);
        return retVal;
    }

    public static String getBitFieldGet(String name, String bitMask, String parentType, String parentField) {
        String type = RecordUtil.getBitFieldType(name, bitMask, parentType);
        String retVal = null;
        retVal = type.equals("boolean") ? String.valueOf(name) + ".isSet(" + parentField + ");" : "( " + type + " )" + name + ".getValue(" + parentField + ");";
        return retVal;
    }

    public static String getBitFieldSet(String name, String bitMask, String parentType, String parentField) {
        String type = RecordUtil.getBitFieldType(name, bitMask, parentType);
        String retVal = null;
        retVal = type.equals("boolean") ? (parentType.equals("int") ? String.valueOf(RecordUtil.getFieldName(name, 0)) + ".setBoolean(" + parentField + ", value)" : "(" + parentType + ")" + RecordUtil.getFieldName(name, 0) + ".setBoolean(" + parentField + ", value)") : (parentType.equals("int") ? String.valueOf(RecordUtil.getFieldName(name, 0)) + ".setValue(" + parentField + ", value)" : "(" + parentType + ")" + RecordUtil.getFieldName(name, 0) + ".setValue(" + parentField + ", value)");
        return retVal;
    }

    public static String getBitFieldType(String name, String bitMask, String parentType) {
        int parentSize = 0;
        int numBits = 0;
        int mask = (int)Long.parseLong(bitMask.substring(2), 16);
        if (parentType.equals("byte")) {
            parentSize = 8;
        } else if (parentType.equals("short")) {
            parentSize = 16;
        } else if (parentType.equals("int")) {
            parentSize = 32;
        }
        int x = 0;
        while (x < parentSize) {
            int temp = mask;
            numBits = (byte)(numBits + (temp >> x & 1));
            ++x;
        }
        if (numBits == 1) {
            return "boolean";
        }
        if (numBits < 8) {
            return "byte";
        }
        if (numBits < 16) {
            return "short";
        }
        return "int";
    }

    public static String getConstName(String parentName, String constName, int padTo) {
        StringBuffer fieldName = new StringBuffer();
        RecordUtil.toConstIdentifier(parentName, fieldName);
        fieldName.append('_');
        RecordUtil.toConstIdentifier(constName, fieldName);
        RecordUtil.pad(fieldName, padTo);
        return fieldName.toString();
    }

    public static String getFieldName(int position, String name, int padTo) {
        StringBuffer fieldName = new StringBuffer("field_" + position + "_");
        RecordUtil.toIdentifier(name, fieldName);
        RecordUtil.pad(fieldName, padTo);
        return fieldName.toString();
    }

    public static String getFieldName(String name, int padTo) {
        StringBuffer fieldName = new StringBuffer();
        RecordUtil.toIdentifier(name, fieldName);
        RecordUtil.pad(fieldName, padTo);
        return fieldName.toString();
    }

    public static String getFieldName1stCap(String name, int padTo) {
        StringBuffer fieldName = new StringBuffer();
        RecordUtil.toIdentifier(name, fieldName);
        fieldName.setCharAt(0, Character.toUpperCase(fieldName.charAt(0)));
        RecordUtil.pad(fieldName, padTo);
        return fieldName.toString();
    }

    public static String getType1stCap(String size, String type, int padTo) {
        StringBuffer result = new StringBuffer();
        result.append(type);
        result = RecordUtil.pad(result, padTo);
        result.setCharAt(0, Character.toUpperCase(result.charAt(0)));
        return result.toString();
    }

    protected static StringBuffer pad(StringBuffer fieldName, int padTo) {
        int i = fieldName.length();
        while (i < padTo) {
            fieldName.append(' ');
            ++i;
        }
        return fieldName;
    }

    private static void toConstIdentifier(String name, StringBuffer fieldName) {
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == ' ') {
                fieldName.append('_');
            } else {
                fieldName.append(Character.toUpperCase(name.charAt(i)));
            }
            ++i;
        }
    }

    private static void toIdentifier(String name, StringBuffer fieldName) {
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == ' ') {
                fieldName.append(Character.toUpperCase(name.charAt(++i)));
            } else {
                fieldName.append(name.charAt(i));
            }
            ++i;
        }
    }
}

