/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.ColorSchemeAtom;
import org.apache.poi.hslf.record.PPDrawing;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.SheetContainer;
import org.apache.poi.hslf.record.SlideAtom;
import org.apache.poi.util.LittleEndian;

public final class Slide
extends SheetContainer {
    private byte[] _header = new byte[8];
    private static long _type = 1006L;
    private SlideAtom slideAtom;
    private PPDrawing ppDrawing;
    private ColorSchemeAtom _colorScheme;

    public SlideAtom getSlideAtom() {
        return this.slideAtom;
    }

    public PPDrawing getPPDrawing() {
        return this.ppDrawing;
    }

    protected Slide(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        int i = 0;
        while (i < this._children.length) {
            if (this._children[i] instanceof SlideAtom) {
                this.slideAtom = (SlideAtom)this._children[i];
            } else if (this._children[i] instanceof PPDrawing) {
                this.ppDrawing = (PPDrawing)this._children[i];
            }
            if (this.ppDrawing != null && this._children[i] instanceof ColorSchemeAtom) {
                this._colorScheme = (ColorSchemeAtom)this._children[i];
            }
            ++i;
        }
    }

    public Slide() {
        LittleEndian.putUShort((byte[])this._header, (int)0, (int)15);
        LittleEndian.putUShort((byte[])this._header, (int)2, (int)((int)_type));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)0);
        this.slideAtom = new SlideAtom();
        this.ppDrawing = new PPDrawing();
        ColorSchemeAtom colorAtom = new ColorSchemeAtom();
        this._children = new Record[]{this.slideAtom, this.ppDrawing, colorAtom};
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, out);
    }

    public ColorSchemeAtom getColorScheme() {
        return this._colorScheme;
    }
}

