/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.property;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.DocumentProperty;
import org.apache.poi.poifs.property.RootProperty;
import org.apache.poi.poifs.storage.ListManagedBlock;

class PropertyFactory {
    private PropertyFactory() {
    }

    static List convertToProperties(ListManagedBlock[] blocks) throws IOException {
        ArrayList properties = new ArrayList();
        int j = 0;
        while (j < blocks.length) {
            byte[] data = blocks[j].getData();
            PropertyFactory.convertToProperties(data, properties);
            ++j;
        }
        return properties;
    }

    static void convertToProperties(byte[] data, List properties) throws IOException {
        int property_count = data.length / 128;
        int offset = 0;
        int k = 0;
        while (k < property_count) {
            switch (data[offset + 66]) {
                case 1: {
                    properties.add(new DirectoryProperty(properties.size(), data, offset));
                    break;
                }
                case 2: {
                    properties.add(new DocumentProperty(properties.size(), data, offset));
                    break;
                }
                case 5: {
                    properties.add(new RootProperty(properties.size(), data, offset));
                    break;
                }
                default: {
                    properties.add(null);
                }
            }
            offset += 128;
            ++k;
        }
    }
}

