/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hwpf.model.NotesTables;
import org.apache.poi.hwpf.usermodel.Notes;

public class NotesImpl
implements Notes {
    private Map anchorToIndexMap = null;
    private final NotesTables notesTables;

    public NotesImpl(NotesTables notesTables) {
        this.notesTables = notesTables;
    }

    public int getNoteAnchorPosition(int index) {
        return this.notesTables.getDescriptor(index).getStart();
    }

    public int getNoteIndexByAnchorPosition(int anchorPosition) {
        this.updateAnchorToIndexMap();
        Integer index = (Integer)this.anchorToIndexMap.get(new Integer(anchorPosition));
        if (index == null) {
            return -1;
        }
        return index;
    }

    public int getNotesCount() {
        return this.notesTables.getDescriptorsCount();
    }

    public int getNoteTextEndOffset(int index) {
        return this.notesTables.getTextPosition(index).getEnd();
    }

    public int getNoteTextStartOffset(int index) {
        return this.notesTables.getTextPosition(index).getStart();
    }

    private void updateAnchorToIndexMap() {
        if (this.anchorToIndexMap != null) {
            return;
        }
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        int n = 0;
        while (n < this.notesTables.getDescriptorsCount()) {
            int anchorPosition = this.notesTables.getDescriptor(n).getStart();
            result.put(new Integer(anchorPosition), new Integer(n));
            ++n;
        }
        this.anchorToIndexMap = result;
    }
}

