/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model.types;

import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public abstract class SHD80AbstractType {
    protected short field_1_value;
    private static BitField icoFore = new BitField(31);
    private static BitField icoBack = new BitField(992);
    private static BitField ipat = new BitField(64512);

    protected SHD80AbstractType() {
    }

    protected void fillFields(byte[] data, int offset) {
        this.field_1_value = LittleEndian.getShort((byte[])data, (int)(0 + offset));
    }

    public void serialize(byte[] data, int offset) {
        LittleEndian.putShort((byte[])data, (int)(0 + offset), (short)this.field_1_value);
    }

    public static int getSize() {
        return 2;
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("[SHD80]\n");
        builder.append("    .value                = ");
        builder.append(" (").append(this.getValue()).append(" )\n");
        builder.append("         .icoFore                  = ").append(this.getIcoFore()).append('\n');
        builder.append("         .icoBack                  = ").append(this.getIcoBack()).append('\n');
        builder.append("         .ipat                     = ").append(this.getIpat()).append('\n');
        builder.append("[/SHD80]\n");
        return builder.toString();
    }

    public short getValue() {
        return this.field_1_value;
    }

    public void setValue(short field_1_value) {
        this.field_1_value = field_1_value;
    }

    public void setIcoFore(byte value) {
        this.field_1_value = (short)icoFore.setValue((int)this.field_1_value, (int)value);
    }

    public byte getIcoFore() {
        return (byte)icoFore.getValue((int)this.field_1_value);
    }

    public void setIcoBack(byte value) {
        this.field_1_value = (short)icoBack.setValue((int)this.field_1_value, (int)value);
    }

    public byte getIcoBack() {
        return (byte)icoBack.getValue((int)this.field_1_value);
    }

    public void setIpat(byte value) {
        this.field_1_value = (short)ipat.setValue((int)this.field_1_value, (int)value);
    }

    public byte getIpat() {
        return (byte)ipat.getValue((int)this.field_1_value);
    }
}

