/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.hwpf.model.FieldDescriptor;
import org.apache.poi.hwpf.model.GenericPropertyNode;

public class PlexOfField {
    private final GenericPropertyNode propertyNode;
    private final FieldDescriptor fld;

    public PlexOfField(int fcStart, int fcEnd, byte[] data) {
        this.propertyNode = new GenericPropertyNode(fcStart, fcEnd, data);
        this.fld = new FieldDescriptor(data);
    }

    public PlexOfField(GenericPropertyNode propertyNode) {
        this.propertyNode = propertyNode;
        this.fld = new FieldDescriptor(propertyNode.getBytes());
    }

    public int getFcStart() {
        return this.propertyNode.getStart();
    }

    public int getFcEnd() {
        return this.propertyNode.getEnd();
    }

    public FieldDescriptor getFld() {
        return this.fld;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[");
        s.append(this.getFcStart());
        s.append(", ");
        s.append(this.getFcEnd());
        s.append(") - FLD - 0x");
        s.append(Integer.toHexString(0xFF & this.fld.getBoundaryType()));
        s.append("; 0x");
        s.append(Integer.toHexString(0xFF & this.fld.getFlt()));
        return new String(s);
    }
}

